/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.pacl.checker;

import com.liferay.portal.kernel.configuration.Filter;
import com.liferay.portal.kernel.deploy.DeployManagerUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.ServletContextPool;
import com.liferay.portal.kernel.servlet.WebDirDetector;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PathUtil;
import com.liferay.portal.kernel.util.ReleaseInfo;
import com.liferay.portal.kernel.util.ServerDetector;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UniqueList;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.pacl.checker.AuthorizationProperty;
import com.liferay.portal.security.pacl.checker.BaseChecker;
import com.liferay.portal.spring.context.PortalContextLoaderListener;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portal.util.PropsValues;
import java.io.File;
import java.io.FilePermission;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.security.Permission;
import java.security.Permissions;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletContext;

public class FileChecker
extends BaseChecker {
    private static final String _ENV_PREFIX = "${env:";
    private static Log _log = LogFactoryUtil.getLog(FileChecker.class);
    private String[] _defaultReadPathsFromArray;
    private String[] _defaultReadPathsToArray;
    private String _globalSharedLibDir = PropsValues.LIFERAY_LIB_GLOBAL_SHARED_DIR;
    private Permissions _permissions = new Permissions();
    private String _portalDir = PropsValues.LIFERAY_WEB_PORTAL_DIR;
    private String _rootDir;
    private String _workDir;

    @Override
    public void afterPropertiesSet() {
        ServletContext servletContext;
        try {
            this._rootDir = WebDirDetector.getRootDir((ClassLoader)this.getClassLoader());
        }
        catch (Exception exception) {}
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Root directory " + this._rootDir));
        }
        if ((servletContext = ServletContextPool.get((String)this.getServletContextName())) != null) {
            File tempDir = (File)servletContext.getAttribute("javax.servlet.context.tempdir");
            this._workDir = tempDir.getAbsolutePath();
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Work directory " + this._workDir));
            }
        }
        this._defaultReadPathsFromArray = new String[]{"${/}", "${auto.deploy.installed.dir}", "${catalina.base}", "${com.sun.aas.instanceRoot}", "${com.sun.aas.installRoot}", "${file.separator}", "${java.io.tmpdir}", "${java.home}", "${jboss.home.dir}", "${jetty.home}", "${jonas.base}", "${liferay.web.portal.dir}", "${liferay.home}", "${line.separator}", "${org.apache.geronimo.home.dir}", "${path.separator}", "${plugin.servlet.context.name}", "${release.info.version}", "${resin.home}", "${user.dir}", "${user.home}", "${user.name}", "${weblogic.domain.dir}", "${websphere.cell}", "${websphere.profile.dir}", "//"};
        String installedDir = "";
        try {
            if (DeployManagerUtil.getDeployManager() != null) {
                installedDir = DeployManagerUtil.getInstalledDir();
            }
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
        this._defaultReadPathsToArray = new String[]{System.getProperty("file.separator"), installedDir, System.getProperty("catalina.base"), System.getProperty("com.sun.aas.instanceRoot"), System.getProperty("com.sun.aas.installRoot"), System.getProperty("file.separator"), System.getProperty("java.io.tmpdir"), System.getenv("JAVA_HOME"), System.getProperty("jboss.home.dir"), System.getProperty("jetty.home"), System.getProperty("jonas.base"), this._portalDir, PropsValues.LIFERAY_HOME, System.getProperty("line.separator"), System.getProperty("org.apache.geronimo.home.dir"), System.getProperty("path.separator"), this.getServletContextName(), ReleaseInfo.getVersion(), System.getProperty("resin.home"), System.getProperty("user.dir"), System.getProperty("user.home"), System.getProperty("user.name"), System.getenv("DOMAIN_HOME"), System.getenv("WAS_CELL"), System.getProperty("server.root"), "/"};
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Default read paths replace with " + StringUtil.merge((Object[])this._defaultReadPathsToArray)));
        }
        this.initPermissions();
    }

    @Override
    public AuthorizationProperty generateAuthorizationProperty(Object ... arguments) {
        if (arguments == null || arguments.length != 1 || !(arguments[0] instanceof Permission)) {
            return null;
        }
        Permission permission = (Permission)arguments[0];
        String actions = permission.getActions();
        String key = null;
        if (actions.equals("delete")) {
            key = "security-manager-files-delete";
        } else if (actions.equals("execute")) {
            key = "security-manager-files-execute";
        } else if (actions.equals("read")) {
            key = "security-manager-files-read";
        } else if (actions.equals("write")) {
            key = "security-manager-files-write";
        } else {
            return null;
        }
        AuthorizationProperty authorizationProperty = new AuthorizationProperty();
        authorizationProperty.setKey(key);
        authorizationProperty.setValue(permission.getName());
        return authorizationProperty;
    }

    public String getRootDir() {
        return this._rootDir;
    }

    @Override
    public boolean implies(Permission permission) {
        if (this._permissions.implies(permission)) {
            return true;
        }
        this.logSecurityException(_log, "Attempted to " + permission.getActions() + " on file " + permission.getName());
        return false;
    }

    protected void addCanonicalPath(List<String> paths, String path) {
        Iterator<String> itr = paths.iterator();
        while (itr.hasNext()) {
            String curPath = itr.next();
            if (curPath.startsWith(path) && curPath.length() > path.length()) {
                itr.remove();
                continue;
            }
            if (!path.startsWith(curPath)) continue;
            return;
        }
        if ((path = StringUtil.replace((String)path, (String)"\\", (String)"/")).endsWith("/")) {
            path = String.valueOf(path) + "-";
        }
        paths.add(path);
    }

    protected void addCanonicalPaths(List<String> paths, File directory) throws IOException {
        this.addCanonicalPath(paths, String.valueOf(directory.getCanonicalPath()) + "/");
        Object[] files = directory.listFiles();
        if (ArrayUtil.isEmpty((Object[])files)) {
            return;
        }
        Object[] objectArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            Object file = objectArray[n2];
            if (((File)file).isDirectory()) {
                this.addCanonicalPaths(paths, (File)file);
            } else {
                File canonicalFile = new File(((File)file).getCanonicalPath());
                File parentFile = canonicalFile.getParentFile();
                this.addCanonicalPath(paths, String.valueOf(parentFile.getPath()) + "/");
            }
            ++n2;
        }
    }

    protected void addDefaultReadPaths(List<String> paths, String selector) {
        String[] pathsArray;
        String[] stringArray = pathsArray = PropsUtil.getArray((String)"portal.security.manager.file.checker.default.read.paths", (Filter)new Filter(selector));
        int n = pathsArray.length;
        int n2 = 0;
        while (n2 < n) {
            String path = stringArray[n2];
            path = StringUtil.replace((String)path, (String[])this._defaultReadPathsFromArray, (String[])this._defaultReadPathsToArray);
            paths.add(path);
            ++n2;
        }
    }

    protected void addPermission(String path, String actions) {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Allowing " + actions + " on " + path));
        }
        String unixPath = PathUtil.toUnixPath((String)path);
        FilePermission unixPermission = new FilePermission(unixPath, actions);
        this._permissions.add(unixPermission);
        String windowsPath = PathUtil.toWindowsPath((String)path);
        FilePermission windowsPermission = new FilePermission(windowsPath, actions);
        this._permissions.add(windowsPermission);
    }

    protected void getPermissions(String key, String actions) {
        String[] paths;
        String value = this.getProperty(key);
        if (value != null) {
            int x = value.indexOf(_ENV_PREFIX);
            while (x >= 0) {
                int y = value.indexOf("}", x);
                String propertyName = value.substring(x + 6, y);
                String propertyValue = GetterUtil.getString((String)System.getenv(propertyName));
                String fullPropertyName = _ENV_PREFIX + propertyName + "}";
                if (!ArrayUtil.contains((Object[])this._defaultReadPathsFromArray, (Object)fullPropertyName)) {
                    this._defaultReadPathsFromArray = (String[])ArrayUtil.append((Object[])this._defaultReadPathsFromArray, (Object)fullPropertyName);
                    this._defaultReadPathsToArray = (String[])ArrayUtil.append((Object[])this._defaultReadPathsToArray, (Object)propertyValue);
                }
                x = value.indexOf(_ENV_PREFIX, y + 1);
            }
            value = StringUtil.replace((String)value, (String[])this._defaultReadPathsFromArray, (String[])this._defaultReadPathsToArray);
            paths = StringUtil.split((String)value);
            if (value.contains("${comma}")) {
                int i = 0;
                while (i < paths.length) {
                    paths[i] = StringUtil.replace((String)paths[i], (String)"${comma}", (String)",");
                    ++i;
                }
            }
            String[] stringArray = paths;
            int fullPropertyName = paths.length;
            int propertyValue = 0;
            while (propertyValue < fullPropertyName) {
                String path = stringArray[propertyValue];
                this.addPermission(path, actions);
                ++propertyValue;
            }
        }
        ServletContext servletContext = ServletContextPool.get((String)PortalContextLoaderListener.getPortalServlerContextName());
        if (!actions.equals("execute") && this._workDir != null) {
            this.addPermission(this._workDir, actions);
            this.addPermission(String.valueOf(this._workDir) + "/-", actions);
            if (ServerDetector.isWebLogic()) {
                this.addPermission(String.valueOf(this._workDir) + "/../-", actions);
            }
            if (servletContext != null) {
                File tempDir = (File)servletContext.getAttribute("javax.servlet.context.tempdir");
                String tempDirAbsolutePath = tempDir.getAbsolutePath();
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Temp directory " + tempDirAbsolutePath));
                }
                if (actions.equals("read")) {
                    this.addPermission(tempDirAbsolutePath, actions);
                }
                this.addPermission(String.valueOf(tempDirAbsolutePath) + "/-", actions);
            }
        }
        if (!actions.equals("read")) {
            return;
        }
        paths = new UniqueList();
        try {
            File file = new File(String.valueOf(System.getProperty("java.home")) + "/lib");
            this.addCanonicalPaths((List<String>)paths, file);
            ClassLoader classLoader = ClassLoader.getSystemClassLoader();
            Enumeration<URL> enumeration = classLoader.getResources("META-INF/MANIFEST.MF");
            while (enumeration.hasMoreElements()) {
                String resinHome;
                String jettyHome;
                String jBossHomeDir;
                URL url = enumeration.nextElement();
                URLConnection urlConnection = url.openConnection();
                if (!(urlConnection instanceof JarURLConnection)) continue;
                JarURLConnection jarURLConnection = (JarURLConnection)url.openConnection();
                URL jarFileURL = jarURLConnection.getJarFileURL();
                String fileName = jarFileURL.getFile();
                int pos = fileName.lastIndexOf(File.separatorChar);
                if (pos != -1) {
                    fileName = fileName.substring(0, pos + 1);
                }
                if (ServerDetector.isJBoss7() && fileName.startsWith(jBossHomeDir = System.getProperty("jboss.home.dir")) || ServerDetector.isJetty() && fileName.startsWith(jettyHome = System.getProperty("jetty.home")) || ServerDetector.isResin() && fileName.startsWith(resinHome = System.getProperty("resin.home"))) continue;
                this.addCanonicalPath((List<String>)paths, fileName);
            }
        }
        catch (IOException ioe) {
            _log.error((Object)ioe, (Throwable)ioe);
        }
        if (Validator.isNotNull((String)this._globalSharedLibDir)) {
            paths.add(String.valueOf(this._globalSharedLibDir) + "-");
        }
        if (this._rootDir != null) {
            paths.add(this._rootDir);
            paths.add(String.valueOf(this._rootDir) + "-");
        }
        this.addDefaultReadPaths((List<String>)paths, ServerDetector.getServerId());
        for (String path : paths) {
            this.addPermission(path, actions);
        }
    }

    protected void initPermissions() {
        this.getPermissions("security-manager-files-delete", "delete");
        this.getPermissions("security-manager-files-execute", "execute");
        this.getPermissions("security-manager-files-read", "read");
        this.getPermissions("security-manager-files-write", "write");
    }
}

