/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.Writer;
import org.hsqldb.HsqlDateTime;
import org.hsqldb.lib.FileUtil;

public class SimpleLog {
    public static final int LOG_NONE = 0;
    public static final int LOG_ERROR = 1;
    public static final int LOG_NORMAL = 2;
    public static final int LOG_DETAIL = 3;
    public static final String logTypeNameEngine = "ENGINE";
    public static final String[] logTypeNames = new String[]{"", "ERROR ", "NORMAL", "DETAIL"};
    private PrintWriter writer;
    private int level;
    private boolean isSystem;
    private String filePath;

    public SimpleLog(String path, int level) {
        this.isSystem = path == null;
        this.filePath = path;
        this.setLevel(level);
    }

    private void setupWriter() {
        if (this.level == 0) {
            this.close();
            return;
        }
        if (this.writer == null) {
            if (this.isSystem) {
                this.writer = new PrintWriter(System.out);
            } else {
                File file = new File(this.filePath);
                this.setupLog(file);
            }
        }
    }

    private void setupLog(File file) {
        try {
            FileUtil.getFileUtil().makeParentDirectories(file);
            this.writer = new PrintWriter((Writer)new FileWriter(file.getPath(), true), true);
        }
        catch (Exception e) {
            this.isSystem = true;
            this.writer = new PrintWriter(System.out);
        }
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int level) {
        this.level = level;
        this.setupWriter();
    }

    public PrintWriter getPrintWriter() {
        return this.writer;
    }

    public synchronized void logContext(int atLevel, String message) {
        if (this.level < atLevel) {
            return;
        }
        StringBuffer sb = new StringBuffer(128);
        sb.append(HsqlDateTime.getSytemTimeString()).append(' ');
        sb.append(logTypeNames[atLevel]).append(' ').append(message);
        this.writer.println(sb.toString());
    }

    public synchronized void logContext(Throwable t, String message, int atLevel) {
        if (this.level == 0) {
            return;
        }
        if (this.writer == null) {
            return;
        }
        StringBuffer sb = new StringBuffer(128);
        sb.append(HsqlDateTime.getSytemTimeString()).append(' ');
        sb.append(logTypeNames[atLevel]).append(' ').append(message);
        Throwable temp = new Throwable();
        StackTraceElement[] elements = temp.getStackTrace();
        if (elements.length > 1) {
            sb.append(elements[1].getClassName()).append('.');
            sb.append(elements[1].getMethodName());
        }
        if ((elements = t.getStackTrace()).length > 0) {
            sb.append(elements[0].getClassName()).append('.');
            sb.append(' ').append(elements[0].getMethodName());
        }
        sb.append(' ').append(t.toString());
        this.writer.println(sb.toString());
    }

    public void flush() {
        if (this.writer != null) {
            this.writer.flush();
        }
    }

    public void close() {
        if (this.writer != null && !this.isSystem) {
            this.writer.close();
        }
        this.writer = null;
    }
}

