/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib.tar;

import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import org.hsqldb.lib.tar.RB;
import org.hsqldb.lib.tar.TarMalformatException;

public class TarFileInputStream {
    protected long bytesRead = 0L;
    private InputStream readStream;
    protected byte[] readBuffer;
    protected int readBufferBlocks;
    protected int compressionType;

    public TarFileInputStream(File sourceFile) throws IOException {
        this(sourceFile, 0);
    }

    public TarFileInputStream(File sourceFile, int compressionType) throws IOException {
        this(sourceFile, compressionType, 20);
    }

    public int getReadBufferBlocks() {
        return this.readBufferBlocks;
    }

    public TarFileInputStream(File sourceFile, int compressionType, int readBufferBlocks) throws IOException {
        if (!sourceFile.isFile()) {
            throw new FileNotFoundException(sourceFile.getAbsolutePath());
        }
        if (!sourceFile.canRead()) {
            throw new IOException(RB.read_denied.getString(sourceFile.getAbsolutePath()));
        }
        this.readBufferBlocks = readBufferBlocks;
        this.compressionType = compressionType;
        this.readBuffer = new byte[readBufferBlocks * 512];
        switch (compressionType) {
            case 0: {
                this.readStream = new FileInputStream(sourceFile);
                break;
            }
            case 1: {
                this.readStream = new GZIPInputStream((InputStream)new FileInputStream(sourceFile), this.readBuffer.length);
                break;
            }
            default: {
                throw new IllegalArgumentException(RB.compression_unknown.getString(compressionType));
            }
        }
    }

    public void readBlocks(int blocks) throws IOException, TarMalformatException {
        if (this.compressionType != 0) {
            this.readCompressedBlocks(blocks);
            return;
        }
        int i = this.readStream.read(this.readBuffer, 0, blocks * 512);
        this.bytesRead += (long)i;
        if (i != blocks * 512) {
            throw new TarMalformatException(RB.insufficient_read.getString(blocks * 512, i));
        }
    }

    protected void readCompressedBlocks(int blocks) throws IOException {
        int i;
        int requiredBytes = 512 * blocks;
        for (int bytesSoFar = 0; bytesSoFar < requiredBytes; bytesSoFar += i) {
            i = this.readStream.read(this.readBuffer, bytesSoFar, requiredBytes - bytesSoFar);
            if (i < 0) {
                throw new EOFException(RB.decompression_ranout.getString(bytesSoFar, requiredBytes));
            }
            this.bytesRead += (long)i;
        }
    }

    public void readBlock() throws IOException, TarMalformatException {
        this.readBlocks(1);
    }

    public boolean readNextHeaderBlock() throws IOException, TarMalformatException {
        try {
            while (this.readStream.available() > 0) {
                this.readBlock();
                if (this.readBuffer[0] == 0) continue;
                return true;
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        this.close();
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        if (this.readStream == null) {
            return;
        }
        try {
            this.readStream.close();
            Object var2_1 = null;
            this.readStream = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.readStream = null;
            throw throwable;
        }
    }
}

