/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.hsqldb.Database;
import org.hsqldb.persist.RandomAccessInterface;

final class ScaledRAFileSimple
implements RandomAccessInterface {
    final RandomAccessFile file;
    final boolean readOnly;

    ScaledRAFileSimple(String name, String openMode) throws FileNotFoundException, IOException {
        this.file = new RandomAccessFile(name, openMode);
        this.readOnly = openMode.equals("r");
    }

    public long length() throws IOException {
        return this.file.length();
    }

    public void seek(long position) throws IOException {
        this.file.seek(position);
    }

    public long getFilePointer() throws IOException {
        return this.file.getFilePointer();
    }

    public int read() throws IOException {
        return this.file.read();
    }

    public long readLong() throws IOException {
        return this.file.readLong();
    }

    public int readInt() throws IOException {
        return this.file.readInt();
    }

    public void read(byte[] b, int offset, int length) throws IOException {
        this.file.readFully(b, offset, length);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.file.write(b, off, len);
    }

    public void writeInt(int i) throws IOException {
        this.file.writeInt(i);
    }

    public void writeLong(long i) throws IOException {
        this.file.writeLong(i);
    }

    public void close() throws IOException {
        this.file.close();
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public boolean wasNio() {
        return false;
    }

    public boolean ensureLength(long newLong) {
        return true;
    }

    public boolean setLength(long newLength) {
        try {
            this.file.setLength(newLength);
            return true;
        }
        catch (Throwable t) {
            return false;
        }
    }

    public Database getDatabase() {
        return null;
    }

    public void synch() {
        try {
            this.file.getFD().sync();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

