/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import java.io.EOFException;
import java.io.InputStream;
import org.hsqldb.ColumnSchema;
import org.hsqldb.Database;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.Session;
import org.hsqldb.Statement;
import org.hsqldb.StatementDML;
import org.hsqldb.StatementSchema;
import org.hsqldb.Table;
import org.hsqldb.error.Error;
import org.hsqldb.lib.IntKeyHashMap;
import org.hsqldb.lib.StopWatch;
import org.hsqldb.persist.Crypto;
import org.hsqldb.result.Result;
import org.hsqldb.scriptio.ScriptReaderBase;
import org.hsqldb.scriptio.ScriptReaderDecode;
import org.hsqldb.scriptio.ScriptReaderText;
import org.hsqldb.store.ValuePool;
import org.hsqldb.types.Type;

public class ScriptRunner {
    public static void runScript(Database database, InputStream inputStream) {
        ScriptReaderText scr;
        Crypto crypto = database.logger.getCrypto();
        if (crypto == null) {
            scr = new ScriptReaderText(database, inputStream);
        } else {
            try {
                scr = new ScriptReaderDecode(database, inputStream, crypto, true);
            }
            catch (Throwable e) {
                database.logger.logSevereEvent("opening log file", e);
                return;
            }
        }
        ScriptRunner.runScript(database, scr);
    }

    public static void runScript(Database database, String logFilename) {
        ScriptReaderText scr;
        Crypto crypto = database.logger.getCrypto();
        try {
            scr = crypto == null ? new ScriptReaderText(database, logFilename, false) : new ScriptReaderDecode(database, logFilename, crypto, true);
        }
        catch (Throwable e) {
            if (!(e instanceof EOFException)) {
                database.logger.logSevereEvent("opening log file", e);
            }
            return;
        }
        ScriptRunner.runScript(database, scr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void runScript(Database database, ScriptReaderBase scr) {
        IntKeyHashMap sessionMap = new IntKeyHashMap();
        Session current = null;
        int currentId = 0;
        StatementDML dummy = new StatementDML(81, 2004, null);
        dummy.setCompileTimestamp(Long.MAX_VALUE);
        database.setReferentialIntegrity(false);
        try {
            try {
                StopWatch sw = new StopWatch();
                while (scr.readLoggedStatement(current)) {
                    int sessionId = scr.getSessionNumber();
                    if ((current == null || currentId != sessionId) && (current = (Session)sessionMap.get(currentId = sessionId)) == null) {
                        current = database.getSessionManager().newSessionForLog(database);
                        sessionMap.put(currentId, current);
                    }
                    if (current.isClosed()) {
                        sessionMap.remove(currentId);
                        continue;
                    }
                    Result result = null;
                    int statementType = scr.getStatementType();
                    switch (statementType) {
                        case 1: {
                            String statement = scr.getLoggedStatement();
                            try {
                                Statement cs = current.compileStatement(statement);
                                if (database.getProperties().isVersion18() && cs.getType() == 77) {
                                    Table table = (Table)((StatementSchema)cs).getArguments()[0];
                                    for (int i = 0; i < table.getColumnCount(); ++i) {
                                        ColumnSchema column = table.getColumn(i);
                                        if (!column.getDataType().isBitType()) continue;
                                        column.setType(Type.SQL_BOOLEAN);
                                    }
                                }
                                result = current.executeCompiledStatement(cs, ValuePool.emptyObjectArray);
                            }
                            catch (Throwable e) {
                                result = Result.newErrorResult(e);
                            }
                            if (result == null || !result.isError()) break;
                            if (result.getException() != null) {
                                throw result.getException();
                            }
                            throw Error.error(result);
                        }
                        case 4: {
                            current.commit(false);
                            break;
                        }
                        case 3: {
                            current.sessionContext.currentStatement = dummy;
                            current.beginAction(dummy);
                            Object[] data = scr.getData();
                            scr.getCurrentTable().insertNoCheckFromLog(current, data);
                            current.endAction(Result.updateOneResult);
                            break;
                        }
                        case 2: {
                            current.sessionContext.currentStatement = dummy;
                            current.beginAction(dummy);
                            Object[] data = scr.getData();
                            scr.getCurrentTable().deleteNoCheckFromLog(current, data);
                            current.endAction(Result.updateOneResult);
                            break;
                        }
                        case 6: {
                            HsqlNameManager.HsqlName name = database.schemaManager.findSchemaHsqlName(scr.getCurrentSchema());
                            current.setCurrentSchemaHsqlName(name);
                            break;
                        }
                    }
                    if (!current.isClosed()) continue;
                    sessionMap.remove(currentId);
                }
                Object var16_18 = null;
                if (scr != null) {
                    scr.close();
                }
                database.getSessionManager().closeAllSessions();
                database.setReferentialIntegrity(true);
            }
            catch (Throwable e) {
                String databaseFile = database.getPath();
                if (!(e instanceof EOFException)) {
                    if (e instanceof OutOfMemoryError) {
                        database.logger.logSevereEvent("out of memory processing log" + databaseFile + " line: " + scr.getLineNumber(), e);
                        throw Error.error(460);
                    }
                    database.logger.logSevereEvent("statement error processing log " + databaseFile + "line: " + scr.getLineNumber(), e);
                }
                Object var16_19 = null;
                if (scr != null) {
                    scr.close();
                }
                database.getSessionManager().closeAllSessions();
                database.setReferentialIntegrity(true);
            }
        }
        catch (Throwable throwable) {
            Object var16_20 = null;
            if (scr != null) {
                scr.close();
            }
            database.getSessionManager().closeAllSessions();
            database.setReferentialIntegrity(true);
            throw throwable;
        }
    }
}

