/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.rowio;

import java.io.IOException;
import java.math.BigDecimal;
import org.hsqldb.Scanner;
import org.hsqldb.error.Error;
import org.hsqldb.rowio.RowInputBase;
import org.hsqldb.rowio.RowInputInterface;
import org.hsqldb.store.ValuePool;
import org.hsqldb.types.BinaryData;
import org.hsqldb.types.BlobData;
import org.hsqldb.types.BlobDataID;
import org.hsqldb.types.ClobData;
import org.hsqldb.types.ClobDataID;
import org.hsqldb.types.IntervalMonthData;
import org.hsqldb.types.IntervalSecondData;
import org.hsqldb.types.IntervalType;
import org.hsqldb.types.JavaObjectData;
import org.hsqldb.types.TimeData;
import org.hsqldb.types.TimestampData;
import org.hsqldb.types.Type;

public class RowInputText
extends RowInputBase
implements RowInputInterface {
    private String fieldSep;
    private String varSep;
    private String longvarSep;
    private int fieldSepLen;
    private int varSepLen;
    private int longvarSepLen;
    private boolean fieldSepEnd;
    private boolean varSepEnd;
    private boolean longvarSepEnd;
    private int textLen;
    protected String text;
    protected int line;
    protected int field;
    protected int next = 0;
    protected boolean allQuoted;
    protected Scanner scanner;
    private int maxPooledStringLength = ValuePool.getMaxStringLength();

    public RowInputText(String fieldSep, String varSep, String longvarSep, boolean allQuoted) {
        super(new byte[0]);
        this.scanner = new Scanner();
        if (fieldSep.endsWith("\n")) {
            this.fieldSepEnd = true;
            fieldSep = fieldSep.substring(0, fieldSep.length() - 1);
        }
        if (varSep.endsWith("\n")) {
            this.varSepEnd = true;
            varSep = varSep.substring(0, varSep.length() - 1);
        }
        if (longvarSep.endsWith("\n")) {
            this.longvarSepEnd = true;
            longvarSep = longvarSep.substring(0, longvarSep.length() - 1);
        }
        this.allQuoted = allQuoted;
        this.fieldSep = fieldSep;
        this.varSep = varSep;
        this.longvarSep = longvarSep;
        this.fieldSepLen = fieldSep.length();
        this.varSepLen = varSep.length();
        this.longvarSepLen = longvarSep.length();
    }

    public void setSource(String text, int pos, int byteSize) {
        this.size = byteSize;
        this.text = text;
        this.textLen = text.length();
        this.filePos = pos;
        this.next = 0;
        ++this.line;
        this.field = 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected String getField(String sep, int sepLen, boolean isEnd) throws IOException {
        String s = null;
        try {
            int start = this.next;
            ++this.field;
            if (isEnd) {
                if (this.next >= this.textLen && sepLen > 0) {
                    throw Error.error(488);
                }
                if (!this.text.endsWith(sep)) throw Error.error(488);
                this.next = this.textLen - sepLen;
            } else {
                this.next = this.text.indexOf(sep, start);
                if (this.next == -1) {
                    this.next = this.textLen;
                }
            }
            if (start > this.next) {
                start = this.next;
            }
            s = this.text.substring(start, this.next);
            this.next += sepLen;
            if ((s = s.trim()).length() != 0) return s;
            return null;
        }
        catch (Exception e) {
            Object[] messages = new Object[]{new Integer(this.field), e.toString()};
            throw new IOException(Error.getMessage(41, 0, messages));
        }
    }

    public String readString() throws IOException {
        return this.getField(this.fieldSep, this.fieldSepLen, this.fieldSepEnd);
    }

    private String readVarString() throws IOException {
        return this.getField(this.varSep, this.varSepLen, this.varSepEnd);
    }

    private String readLongVarString() throws IOException {
        return this.getField(this.longvarSep, this.longvarSepLen, this.longvarSepEnd);
    }

    public short readShort() throws IOException {
        return (short)this.readInt();
    }

    public int readInt() throws IOException {
        String s = this.readString();
        if (s == null) {
            return 0;
        }
        if ((s = s.trim()).length() == 0) {
            return 0;
        }
        return Integer.parseInt(s);
    }

    public long readLong() throws IOException {
        throw Error.runtimeError(201, "RowInputText");
    }

    public int readType() throws IOException {
        return 0;
    }

    protected boolean readNull() {
        return false;
    }

    protected String readChar(Type type) throws IOException {
        String s = null;
        switch (type.typeCode) {
            case 1: {
                s = this.readString();
                break;
            }
            case 12: 
            case 100: {
                s = this.readVarString();
                break;
            }
            default: {
                s = this.readLongVarString();
            }
        }
        if (s == null) {
            return null;
        }
        if (s.length() > this.maxPooledStringLength) {
            return new String(s);
        }
        return ValuePool.getString(s);
    }

    protected Integer readSmallint() throws IOException {
        String s = this.readString();
        if (s == null) {
            return null;
        }
        if ((s = s.trim()).length() == 0) {
            return null;
        }
        return ValuePool.getInt(Integer.parseInt(s));
    }

    protected Integer readInteger() throws IOException {
        String s = this.readString();
        if (s == null) {
            return null;
        }
        if ((s = s.trim()).length() == 0) {
            return null;
        }
        return ValuePool.getInt(Integer.parseInt(s));
    }

    protected Long readBigint() throws IOException {
        String s = this.readString();
        if (s == null) {
            return null;
        }
        if ((s = s.trim()).length() == 0) {
            return null;
        }
        return ValuePool.getLong(Long.parseLong(s));
    }

    protected Double readReal() throws IOException {
        String s = this.readString();
        if (s == null) {
            return null;
        }
        if ((s = s.trim()).length() == 0) {
            return null;
        }
        return Double.valueOf(s);
    }

    protected BigDecimal readDecimal(Type type) throws IOException {
        String s = this.readString();
        if (s == null) {
            return null;
        }
        if ((s = s.trim()).length() == 0) {
            return null;
        }
        return new BigDecimal(s);
    }

    protected TimeData readTime(Type type) throws IOException {
        String s = this.readString();
        if (s == null) {
            return null;
        }
        if ((s = s.trim()).length() == 0) {
            return null;
        }
        return this.scanner.newTime(s);
    }

    protected TimestampData readDate(Type type) throws IOException {
        String s = this.readString();
        if (s == null) {
            return null;
        }
        if ((s = s.trim()).length() == 0) {
            return null;
        }
        return this.scanner.newDate(s);
    }

    protected TimestampData readTimestamp(Type type) throws IOException {
        String s = this.readString();
        if (s == null) {
            return null;
        }
        if ((s = s.trim()).length() == 0) {
            return null;
        }
        return this.scanner.newTimestamp(s);
    }

    protected IntervalMonthData readYearMonthInterval(Type type) throws IOException {
        String s = this.readString();
        if (s == null) {
            return null;
        }
        if ((s = s.trim()).length() == 0) {
            return null;
        }
        return (IntervalMonthData)this.scanner.newInterval(s, (IntervalType)type);
    }

    protected IntervalSecondData readDaySecondInterval(Type type) throws IOException {
        String s = this.readString();
        if (s == null) {
            return null;
        }
        if ((s = s.trim()).length() == 0) {
            return null;
        }
        return (IntervalSecondData)this.scanner.newInterval(s, (IntervalType)type);
    }

    protected Boolean readBoole() throws IOException {
        String s = this.readString();
        if (s == null) {
            return null;
        }
        if ((s = s.trim()).length() == 0) {
            return null;
        }
        return s.equalsIgnoreCase("TRUE") ? Boolean.TRUE : Boolean.FALSE;
    }

    protected Object readOther() throws IOException {
        String s = this.readString();
        if (s == null) {
            return null;
        }
        BinaryData data = this.scanner.convertToBinary(s);
        if (data.length(null) == 0L) {
            return null;
        }
        return new JavaObjectData(data.getBytes());
    }

    protected BinaryData readBit() throws IOException {
        String s = this.readString();
        if (s == null) {
            return null;
        }
        BinaryData data = this.scanner.convertToBit(s);
        return data;
    }

    protected BinaryData readBinary() throws IOException {
        String s = this.readString();
        if (s == null) {
            return null;
        }
        BinaryData data = this.scanner.convertToBinary(s);
        return data;
    }

    protected ClobData readClob() throws IOException {
        String s = this.readString();
        if (s == null) {
            return null;
        }
        if ((s = s.trim()).length() == 0) {
            return null;
        }
        long id = Long.parseLong(s);
        return new ClobDataID(id);
    }

    protected BlobData readBlob() throws IOException {
        String s = this.readString();
        if (s == null) {
            return null;
        }
        if ((s = s.trim()).length() == 0) {
            return null;
        }
        long id = Long.parseLong(s);
        return new BlobDataID(id);
    }

    protected Object[] readArray(Type type) {
        throw Error.runtimeError(201, "RowInputText");
    }

    public int getLineNumber() {
        return this.line;
    }

    public void skippedLine() {
        ++this.line;
    }

    public void reset() {
        this.text = "";
        this.textLen = 0;
        this.filePos = 0;
        this.next = 0;
        this.field = 0;
        this.line = 0;
    }
}

