/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.types;

import java.io.InputStream;
import java.io.OutputStream;
import org.hsqldb.SessionInterface;
import org.hsqldb.error.Error;
import org.hsqldb.result.Result;
import org.hsqldb.result.ResultLob;
import org.hsqldb.types.BinaryData;
import org.hsqldb.types.BlobData;
import org.hsqldb.types.BlobInputStream;

public class BlobDataID
implements BlobData {
    long id;
    long length = -1L;

    public BlobDataID(long id) {
        this.id = id;
    }

    public BlobData duplicate(SessionInterface session) {
        return null;
    }

    public void free() {
    }

    public InputStream getBinaryStream(SessionInterface session) {
        long length = this.length(session);
        return new BlobInputStream(session, this, 0L, length);
    }

    public InputStream getBinaryStream(SessionInterface session, long pos, long length) {
        return new BlobInputStream(session, this, pos, length);
    }

    public byte[] getBytes() {
        return null;
    }

    public byte[] getBytes(SessionInterface session, long pos, int length) {
        ResultLob resultOut = ResultLob.newLobGetBytesRequest(this.id, pos, length);
        Result resultIn = session.execute(resultOut);
        if (resultIn.isError()) {
            throw Error.error(resultIn);
        }
        return ((ResultLob)resultIn).getByteArray();
    }

    public BlobData getBlob(SessionInterface session, long pos, long length) {
        ResultLob resultOut = ResultLob.newLobGetRequest(this.id, pos, length);
        Result resultIn = session.execute(resultOut);
        if (resultIn.isError()) {
            throw Error.error(resultIn);
        }
        long lobID = ((ResultLob)resultIn).getLobID();
        return new BlobDataID(lobID);
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public int getStreamBlockSize() {
        return 0;
    }

    public boolean isClosed() {
        return false;
    }

    public long length(SessionInterface session) {
        if (this.length > -1L) {
            return this.length;
        }
        ResultLob resultOut = ResultLob.newLobGetLengthRequest(this.id);
        Result resultIn = session.execute(resultOut);
        if (resultIn.isError()) {
            throw resultIn.getException();
        }
        this.length = ((ResultLob)resultIn).getBlockLength();
        return this.length;
    }

    public long bitLength(SessionInterface session) {
        return 0L;
    }

    public boolean isBits() {
        return false;
    }

    public long position(SessionInterface session, BlobData pattern, long start) {
        return 0L;
    }

    public long position(SessionInterface session, byte[] pattern, long start) {
        ResultLob resultOut = ResultLob.newLobGetBytePatternPositionRequest(this.id, pattern, start);
        ResultLob resultIn = (ResultLob)session.execute(resultOut);
        return resultIn.getOffset();
    }

    public long nonZeroLength(SessionInterface session) {
        return 0L;
    }

    public OutputStream setBinaryStream(SessionInterface session, long pos) {
        return null;
    }

    public int setBytes(SessionInterface session, long pos, byte[] bytes, int offset, int len) {
        ResultLob resultOut;
        ResultLob resultIn;
        if (offset != 0 || len != bytes.length) {
            if (!BinaryData.isInLimits(bytes.length, offset, len)) {
                throw new IndexOutOfBoundsException();
            }
            byte[] newbytes = new byte[len];
            System.arraycopy(bytes, offset, newbytes, 0, len);
            bytes = newbytes;
        }
        if ((resultIn = (ResultLob)session.execute(resultOut = ResultLob.newLobSetBytesRequest(this.id, pos, bytes))).isError()) {
            throw resultIn.getException();
        }
        return bytes.length;
    }

    public int setBytes(SessionInterface session, long pos, byte[] bytes) {
        return this.setBytes(session, pos, bytes, 0, bytes.length);
    }

    public long setBinaryStream(SessionInterface session, long pos, InputStream in) {
        return 0L;
    }

    public void setSession(SessionInterface session) {
    }

    public void truncate(SessionInterface session, long len) {
        ResultLob resultOut = ResultLob.newLobTruncateRequest(this.id, len);
        Result resultIn = session.execute(resultOut);
        if (resultIn.isError()) {
            throw resultIn.getException();
        }
    }

    public boolean isBinary() {
        return true;
    }

    public boolean equals(Object other) {
        if (other instanceof BlobDataID) {
            return this.id == ((BlobDataID)other).id;
        }
        return false;
    }

    public int hashCode() {
        return (int)this.id;
    }
}

