/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.commons.configuration.parameter;

import gr.uoa.di.madgik.commons.configuration.parameter.BooleanClassParameter;
import gr.uoa.di.madgik.commons.configuration.parameter.BooleanPrimitiveParameter;
import gr.uoa.di.madgik.commons.configuration.parameter.ByteClassParameter;
import gr.uoa.di.madgik.commons.configuration.parameter.BytePrimitiveParameter;
import gr.uoa.di.madgik.commons.configuration.parameter.DoubleClassParameter;
import gr.uoa.di.madgik.commons.configuration.parameter.DoublePrimitiveParameter;
import gr.uoa.di.madgik.commons.configuration.parameter.FloatClassParameter;
import gr.uoa.di.madgik.commons.configuration.parameter.FloatPrimitiveParameter;
import gr.uoa.di.madgik.commons.configuration.parameter.IParameter;
import gr.uoa.di.madgik.commons.configuration.parameter.IntegerClassParameter;
import gr.uoa.di.madgik.commons.configuration.parameter.IntegerPrimitiveParameter;
import gr.uoa.di.madgik.commons.configuration.parameter.LongClassParameter;
import gr.uoa.di.madgik.commons.configuration.parameter.LongPrimitiveParameter;
import gr.uoa.di.madgik.commons.configuration.parameter.ObjectParameter;
import gr.uoa.di.madgik.commons.configuration.parameter.ShortClassParameter;
import gr.uoa.di.madgik.commons.configuration.parameter.ShortPrimitiveParameter;
import gr.uoa.di.madgik.commons.configuration.parameter.StringParameter;
import gr.uoa.di.madgik.commons.configuration.parameter.XMLParameter;
import gr.uoa.di.madgik.commons.utils.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ParameterFactory {
    public static IParameter GetParameter(String xml) throws Exception {
        Document doc = XMLUtils.Deserialize(xml);
        return ParameterFactory.GetParameter(doc.getDocumentElement());
    }

    public static IParameter GetParameter(Element element) throws Exception {
        if (!XMLUtils.AttributeExists(element, "type").booleanValue()) {
            throw new Exception("Not a valid serialization of parameter");
        }
        IParameter.ParameterType paramt = IParameter.ParameterType.valueOf(XMLUtils.GetAttribute(element, "type"));
        IParameter param = null;
        switch (paramt) {
            case BooleanClass: {
                param = new BooleanClassParameter();
                break;
            }
            case BooleanPrimitive: {
                param = new BooleanPrimitiveParameter();
                break;
            }
            case ByteClass: {
                param = new ByteClassParameter();
                break;
            }
            case BytePrimitive: {
                param = new BytePrimitiveParameter();
                break;
            }
            case DoubleClass: {
                param = new DoubleClassParameter();
                break;
            }
            case DoublePrimitive: {
                param = new DoublePrimitiveParameter();
                break;
            }
            case FloatClass: {
                param = new FloatClassParameter();
                break;
            }
            case FloatPrimitive: {
                param = new FloatPrimitiveParameter();
                break;
            }
            case IntegerClass: {
                param = new IntegerClassParameter();
                break;
            }
            case IntegerPrimitive: {
                param = new IntegerPrimitiveParameter();
                break;
            }
            case LongClass: {
                param = new LongClassParameter();
                break;
            }
            case LongPrimitive: {
                param = new LongPrimitiveParameter();
                break;
            }
            case ShortClass: {
                param = new ShortClassParameter();
                break;
            }
            case ShortPrimitive: {
                param = new ShortPrimitiveParameter();
                break;
            }
            case String: {
                param = new StringParameter();
                break;
            }
            case XML: {
                param = new XMLParameter();
                break;
            }
            case Object: {
                param = new ObjectParameter();
            }
        }
        param.FromXML(element);
        return param;
    }
}

