/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.commons.utils;

import gr.uoa.di.madgik.commons.utils.ZipUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;

public class FileUtils {
    public static String ReadFileToString(File file) throws IOException {
        int numRead;
        StringBuffer sb = new StringBuffer();
        BufferedReader reader = new BufferedReader(new FileReader(file));
        char[] chars = new char[1024];
        while ((numRead = reader.read(chars)) > -1) {
            sb.append(String.valueOf(chars));
        }
        reader.close();
        return sb.toString();
    }

    public static void MakeFileExecutable(File file) throws Exception {
        if (!file.exists()) {
            return;
        }
        ProcessBuilder build = new ProcessBuilder("/bin/chmod", "u+x", file.getAbsolutePath());
        Process p = build.start();
        p.waitFor();
    }

    public static void MakeFileReadWriteOwner(File file) throws Exception {
        if (!file.exists()) {
            return;
        }
        ProcessBuilder build = new ProcessBuilder("/bin/chmod", "0600", file.getAbsolutePath());
        Process p = build.start();
        p.waitFor();
    }

    public static void MakeFilePermissions(File file, String perms) throws Exception {
        if (!file.exists()) {
            return;
        }
        ProcessBuilder build = new ProcessBuilder("/bin/chmod", perms, file.getAbsolutePath());
        Process p = build.start();
        p.waitFor();
    }

    public static void Copy(File source, OutputStream stream) throws IOException {
        int len;
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(source));
        BufferedOutputStream out = new BufferedOutputStream(stream);
        byte[] buf = new byte[1024];
        while ((len = in.read(buf)) > 0) {
            out.write(buf, 0, len);
        }
        in.close();
        out.flush();
        out.close();
    }

    public static void Copy(InputStream stream, File target) throws IOException {
        int len;
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(target));
        BufferedInputStream in = new BufferedInputStream(stream);
        byte[] buf = new byte[1024];
        while ((len = in.read(buf)) > 0) {
            out.write(buf, 0, len);
            out.flush();
        }
        in.close();
        out.flush();
        out.close();
    }

    public static void Copy(File src, File dest) throws IOException {
        FileChannel inChannel = new FileInputStream(src).getChannel();
        FileChannel outChannel = new FileOutputStream(dest).getChannel();
        try {
            inChannel.transferTo(0L, inChannel.size(), outChannel);
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (inChannel != null) {
                inChannel.close();
            }
            if (outChannel != null) {
                outChannel.close();
            }
        }
    }

    public static void Copy(File src, RandomAccessFile dest, boolean Compress) throws IOException {
        int n;
        FileInputStream fin = new FileInputStream(src);
        BufferedInputStream bin = new BufferedInputStream(fin);
        long length = src.length();
        long offset = dest.getFilePointer();
        long count = 0L;
        dest.writeLong(length);
        byte[] buf = new byte[4096];
        while ((n = bin.read(buf)) >= 0) {
            count += (long)n;
            if (!Compress) {
                dest.write(buf, 0, n);
                continue;
            }
            byte[] b = ZipUtils.ZipBytes(buf, n);
            dest.writeInt(b.length);
            dest.write(b);
        }
        long endoffset = dest.getFilePointer();
        dest.seek(offset);
        dest.writeLong(count);
        dest.seek(endoffset);
        bin.close();
        fin.close();
        buf = null;
    }

    public static void Copy(RandomAccessFile src, File dest, boolean Uncompress) throws IOException {
        FileOutputStream fout = new FileOutputStream(dest, false);
        BufferedOutputStream bout = new BufferedOutputStream(fout);
        long length = src.readLong();
        byte[] buf = new byte[4096];
        long readSoFar = 0L;
        int readnow = buf.length;
        while (true) {
            readnow = buf.length;
            long remaining = length - readSoFar;
            if (remaining <= 0L) break;
            if (remaining < (long)buf.length) {
                readnow = (int)remaining;
            }
            if (!Uncompress) {
                src.readFully(buf, 0, readnow);
                bout.write(buf, 0, readnow);
                readSoFar += (long)readnow;
                continue;
            }
            int lenCur = src.readInt();
            byte[] b = new byte[lenCur];
            src.readFully(b);
            b = ZipUtils.UnzipBytes(b);
            bout.write(b);
            readSoFar += (long)b.length;
        }
        bout.flush();
        bout.close();
        fout.close();
        buf = null;
    }

    public static void CleanUp(File target) {
        if (!target.exists()) {
            return;
        }
        if (target.isFile()) {
            target.delete();
        } else if (target.isDirectory()) {
            for (File content : target.listFiles()) {
                FileUtils.CleanUp(content);
            }
            target.delete();
        }
    }
}

