/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.concurrent;

import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import java.util.concurrent.atomic.AtomicMarkableReference;

public abstract class IncreasableEntry<K, V> {
    private final K _key;
    private final AtomicMarkableReference<V> _markedValue;

    public IncreasableEntry(K key, V value) {
        this._key = key;
        this._markedValue = new AtomicMarkableReference<V>(value, false);
    }

    public abstract V doIncrease(V var1, V var2);

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof IncreasableEntry)) {
            return false;
        }
        IncreasableEntry increasableEntry = (IncreasableEntry)obj;
        return Validator.equals(this._key, increasableEntry._key) && Validator.equals(this._markedValue.getReference(), increasableEntry._markedValue.getReference());
    }

    public final K getKey() {
        return this._key;
    }

    public final V getValue() {
        V value;
        while (!this._markedValue.attemptMark(value = this._markedValue.getReference(), true)) {
        }
        return value;
    }

    public int hashCode() {
        int hash = 77;
        if (this._key != null) {
            hash += this._key.hashCode();
        }
        hash *= 11;
        V value = this._markedValue.getReference();
        if (value != null) {
            hash += value.hashCode();
        }
        return hash;
    }

    public final boolean increase(V deltaValue) {
        V newValue;
        V originalValue;
        boolean[] marked = new boolean[1];
        do {
            originalValue = this._markedValue.get(marked);
            if (!marked[0]) continue;
            return false;
        } while (!this._markedValue.compareAndSet(originalValue, newValue = this.doIncrease(originalValue, deltaValue), false, false));
        return true;
    }

    public String toString() {
        StringBundler sb = new StringBundler(5);
        sb.append("{key=");
        sb.append(String.valueOf(this._key.toString()));
        sb.append(", value=");
        sb.append(String.valueOf(this._markedValue.getReference()));
        sb.append("}");
        return sb.toString();
    }
}

