/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.search;

import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.HitsProcessor;
import com.liferay.portal.kernel.search.QueryConfig;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchEngineUtil;
import com.liferay.portal.kernel.search.SearchException;
import java.util.Locale;

public class QueryIndexingHitsProcessor
implements HitsProcessor {
    @Override
    public boolean process(SearchContext searchContext, Hits hits) throws SearchException {
        QueryConfig queryConfig = searchContext.getQueryConfig();
        if (!queryConfig.isQueryIndexingEnabled()) {
            return true;
        }
        if (hits.getLength() >= queryConfig.getQueryIndexingThreshold()) {
            this.addDocument(searchContext.getCompanyId(), searchContext.getKeywords(), searchContext.getLocale());
        }
        return true;
    }

    protected void addDocument(long companyId, String keywords, Locale locale) throws SearchException {
        SearchEngineUtil.indexKeyword(companyId, keywords, 0.0f, "querySuggestion", locale);
    }
}

