/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.membershippolicy;

import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Role;
import com.liferay.portal.model.UserGroupRole;
import com.liferay.portal.security.membershippolicy.SiteMembershipPolicy;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.service.RoleLocalServiceUtil;
import com.liferay.portal.service.UserGroupRoleLocalServiceUtil;
import com.liferay.portal.service.persistence.GroupActionableDynamicQuery;
import com.liferay.portal.service.persistence.UserGroupRoleActionableDynamicQuery;
import com.liferay.portal.service.persistence.UserGroupRolePK;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public abstract class BaseSiteMembershipPolicy
implements SiteMembershipPolicy {
    @Override
    public void checkRoles(List<UserGroupRole> addUserGroupRoles, List<UserGroupRole> removeUserGroupRoles) throws PortalException, SystemException {
    }

    @Override
    public boolean isMembershipAllowed(long userId, long groupId) throws PortalException, SystemException {
        try {
            this.checkMembership(new long[]{userId}, new long[]{groupId}, null);
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    @Override
    public boolean isMembershipProtected(PermissionChecker permissionChecker, long userId, long groupId) throws PortalException, SystemException {
        if (permissionChecker.isGroupOwner(groupId)) {
            return false;
        }
        Role siteAdministratorRole = RoleLocalServiceUtil.getRole(permissionChecker.getCompanyId(), "Site Administrator");
        if (UserGroupRoleLocalServiceUtil.hasUserGroupRole(userId, groupId, siteAdministratorRole.getRoleId())) {
            return true;
        }
        Role siteOwnerRole = RoleLocalServiceUtil.getRole(permissionChecker.getCompanyId(), "Site Owner");
        return UserGroupRoleLocalServiceUtil.hasUserGroupRole(userId, groupId, siteOwnerRole.getRoleId());
    }

    @Override
    public boolean isMembershipRequired(long userId, long groupId) throws PortalException, SystemException {
        try {
            this.checkMembership(new long[]{userId}, null, new long[]{groupId});
        }
        catch (Exception exception) {
            return true;
        }
        return false;
    }

    @Override
    public boolean isRoleAllowed(long userId, long groupId, long roleId) throws PortalException, SystemException {
        ArrayList<UserGroupRole> userGroupRoles = new ArrayList<UserGroupRole>();
        UserGroupRolePK userGroupRolePK = new UserGroupRolePK(userId, groupId, roleId);
        UserGroupRole userGroupRole = UserGroupRoleLocalServiceUtil.createUserGroupRole(userGroupRolePK);
        userGroupRoles.add(userGroupRole);
        try {
            this.checkRoles(userGroupRoles, null);
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    @Override
    public boolean isRoleProtected(PermissionChecker permissionChecker, long userId, long groupId, long roleId) throws PortalException, SystemException {
        if (permissionChecker.isGroupOwner(groupId)) {
            return false;
        }
        Role role = RoleLocalServiceUtil.getRole(roleId);
        String roleName = role.getName();
        if (!roleName.equals("Site Administrator") && !roleName.equals("Site Owner")) {
            return false;
        }
        return UserGroupRoleLocalServiceUtil.hasUserGroupRole(userId, groupId, roleId);
    }

    @Override
    public boolean isRoleRequired(long userId, long groupId, long roleId) {
        ArrayList<UserGroupRole> userGroupRoles = new ArrayList<UserGroupRole>();
        UserGroupRolePK userGroupRolePK = new UserGroupRolePK(userId, groupId, roleId);
        UserGroupRole userGroupRole = UserGroupRoleLocalServiceUtil.createUserGroupRole(userGroupRolePK);
        userGroupRoles.add(userGroupRole);
        try {
            this.checkRoles(null, userGroupRoles);
        }
        catch (Exception exception) {
            return true;
        }
        return false;
    }

    @Override
    public void propagateRoles(List<UserGroupRole> addUserGroupRoles, List<UserGroupRole> removeUserGroupRoles) throws PortalException, SystemException {
    }

    @Override
    public void verifyPolicy() throws PortalException, SystemException {
        GroupActionableDynamicQuery groupActionableDynamicQuery = new GroupActionableDynamicQuery(){

            @Override
            protected void addCriteria(DynamicQuery dynamicQuery) {
                Property property = PropertyFactoryUtil.forName("site");
                dynamicQuery.add(property.eq(true));
            }

            @Override
            protected void performAction(Object object) throws PortalException, SystemException {
                Group group = (Group)object;
                BaseSiteMembershipPolicy.this.verifyPolicy(group);
                UserGroupRoleActionableDynamicQuery userGroupRoleActionableDynamicQuery = new UserGroupRoleActionableDynamicQuery(){

                    @Override
                    protected void performAction(Object object) throws PortalException, SystemException {
                        UserGroupRole userGroupRole = (UserGroupRole)object;
                        BaseSiteMembershipPolicy.this.verifyPolicy(userGroupRole.getRole());
                    }
                };
                userGroupRoleActionableDynamicQuery.setGroupId(group.getGroupId());
                userGroupRoleActionableDynamicQuery.performActions();
            }
        };
        groupActionableDynamicQuery.performActions();
    }

    @Override
    public void verifyPolicy(Group group) throws PortalException, SystemException {
        this.verifyPolicy(group, null, null, null, null, null);
    }

    @Override
    public void verifyPolicy(Role role) {
    }

    @Override
    public void verifyPolicy(Role role, Role oldRole, Map<String, Serializable> oldExpandoAttributes) {
    }
}

