/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.thrift;

import com.netflix.astyanax.Serializer;
import com.netflix.astyanax.model.ByteBufferRange;
import com.netflix.astyanax.model.ColumnSlice;
import com.netflix.astyanax.query.RowQuery;
import com.netflix.astyanax.thrift.ThriftUtils;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import org.apache.cassandra.thrift.SlicePredicate;
import org.apache.cassandra.thrift.SliceRange;

public abstract class AbstractRowQueryImpl<K, C>
implements RowQuery<K, C> {
    protected final SlicePredicate predicate = new SlicePredicate().setSlice_range(ThriftUtils.createAllInclusiveSliceRange());
    protected final Serializer<C> serializer;
    protected boolean isPaginating = false;
    protected boolean paginateNoMore = false;

    public AbstractRowQueryImpl(Serializer<C> serializer) {
        this.serializer = serializer;
    }

    public RowQuery<K, C> withColumnSlice(C ... columns) {
        if (columns != null) {
            this.predicate.setColumn_names(this.serializer.toBytesList(Arrays.asList(columns))).setSlice_rangeIsSet(false);
        }
        return this;
    }

    public RowQuery<K, C> withColumnSlice(Collection<C> columns) {
        if (columns != null) {
            this.predicate.setColumn_names(this.serializer.toBytesList(columns)).setSlice_rangeIsSet(false);
        }
        return this;
    }

    public RowQuery<K, C> withColumnSlice(ColumnSlice<C> slice) {
        if (slice.getColumns() != null) {
            this.predicate.setColumn_names(this.serializer.toBytesList(slice.getColumns())).setSlice_rangeIsSet(false);
        } else {
            this.predicate.setSlice_range(ThriftUtils.createSliceRange(this.serializer, slice.getStartColumn(), slice.getEndColumn(), slice.getReversed(), slice.getLimit()));
        }
        return this;
    }

    public RowQuery<K, C> withColumnRange(C startColumn, C endColumn, boolean reversed, int count) {
        this.predicate.setSlice_range(ThriftUtils.createSliceRange(this.serializer, startColumn, endColumn, reversed, count));
        return this;
    }

    public RowQuery<K, C> withColumnRange(ByteBuffer startColumn, ByteBuffer endColumn, boolean reversed, int count) {
        this.predicate.setSlice_range(new SliceRange(startColumn, endColumn, reversed, count));
        return this;
    }

    public RowQuery<K, C> setIsPaginating() {
        return this.autoPaginate(true);
    }

    public RowQuery<K, C> autoPaginate(boolean enabled) {
        this.isPaginating = enabled;
        return this;
    }

    public RowQuery<K, C> withColumnRange(ByteBufferRange range) {
        this.predicate.setSlice_range(new SliceRange().setStart(range.getStart()).setFinish(range.getEnd()).setCount(range.getLimit()).setReversed(range.isReversed()));
        return this;
    }
}

