/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.compaction;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import org.apache.cassandra.db.columniterator.OnDiskAtomIterator;
import org.apache.cassandra.db.compaction.AbstractCompactedRow;
import org.apache.cassandra.db.compaction.AbstractCompactionIterable;
import org.apache.cassandra.db.compaction.CompactionController;
import org.apache.cassandra.db.compaction.OperationType;
import org.apache.cassandra.io.sstable.ISSTableScanner;
import org.apache.cassandra.io.sstable.format.SSTableFormat;
import org.apache.cassandra.utils.CloseableIterator;
import org.apache.cassandra.utils.MergeIterator;

public class CompactionIterable
extends AbstractCompactionIterable {
    final SSTableFormat format;
    private static final Comparator<OnDiskAtomIterator> comparator = new Comparator<OnDiskAtomIterator>(){

        @Override
        public int compare(OnDiskAtomIterator i1, OnDiskAtomIterator i2) {
            return i1.getKey().compareTo(i2.getKey());
        }
    };

    public CompactionIterable(OperationType type, List<ISSTableScanner> scanners, CompactionController controller, SSTableFormat.Type formatType, UUID compactionId) {
        super(controller, type, scanners, compactionId);
        this.format = formatType.info;
    }

    @Override
    public CloseableIterator<AbstractCompactedRow> iterator() {
        return MergeIterator.get(this.scanners, comparator, new Reducer());
    }

    public String toString() {
        return this.getCompactionInfo().toString();
    }

    protected class Reducer
    extends MergeIterator.Reducer<OnDiskAtomIterator, AbstractCompactedRow> {
        protected final List<OnDiskAtomIterator> rows = new ArrayList<OnDiskAtomIterator>();

        protected Reducer() {
        }

        @Override
        public void reduce(OnDiskAtomIterator current) {
            this.rows.add(current);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected AbstractCompactedRow getReduced() {
            assert (!this.rows.isEmpty());
            CompactionIterable.this.updateCounterFor(this.rows.size());
            try {
                AbstractCompactedRow abstractCompactedRow = CompactionIterable.this.format.getCompactedRowWriter(CompactionIterable.this.controller, (ImmutableList<OnDiskAtomIterator>)ImmutableList.copyOf(this.rows));
                return abstractCompactedRow;
            }
            finally {
                this.rows.clear();
                long n = 0L;
                for (ISSTableScanner scanner : CompactionIterable.this.scanners) {
                    n += scanner.getCurrentPosition();
                }
                CompactionIterable.this.bytesRead = n;
            }
        }
    }
}

