/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ccpp;

import com.hp.hpl.mesa.rdf.jena.common.SelectorImpl;
import com.hp.hpl.mesa.rdf.jena.mem.ModelMem;
import com.hp.hpl.mesa.rdf.jena.model.Literal;
import com.hp.hpl.mesa.rdf.jena.model.NodeIterator;
import com.hp.hpl.mesa.rdf.jena.model.NsIterator;
import com.hp.hpl.mesa.rdf.jena.model.Property;
import com.hp.hpl.mesa.rdf.jena.model.RDFError;
import com.hp.hpl.mesa.rdf.jena.model.RDFException;
import com.hp.hpl.mesa.rdf.jena.model.RDFNode;
import com.hp.hpl.mesa.rdf.jena.model.Resource;
import com.hp.hpl.mesa.rdf.jena.model.Selector;
import com.hp.hpl.mesa.rdf.jena.model.Seq;
import com.hp.hpl.mesa.rdf.jena.model.Statement;
import com.hp.hpl.mesa.rdf.jena.model.StmtIterator;
import com.sun.ccpp.AttributeDescriptionImpl;
import com.sun.ccpp.AttributeImpl;
import com.sun.ccpp.ComponentDescriptionImpl;
import com.sun.ccpp.ComponentImpl;
import com.sun.ccpp.DescriptionManager;
import com.sun.ccpp.Log;
import com.sun.ccpp.ProfileDescriptionImpl;
import com.sun.ccpp.ProfileImpl;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Logger;
import javax.ccpp.Attribute;
import javax.ccpp.Component;
import javax.ccpp.ComponentDescription;
import javax.ccpp.Profile;
import javax.ccpp.ProfileFragment;
import javax.ccpp.ProfileFragmentFactory;

class FragmentProcessor {
    private Logger logger = Log.getLogger();
    private DescriptionManager dm = DescriptionManager.getInstance();
    private String rdfNS = null;
    private String ccppNS = null;
    private Property rdfType = null;

    FragmentProcessor() {
        this.setJenaReader("com.hp.hpl.mesa.rdf.jena.common.RDFXMLReader");
        this.setRdfNS("http://www.w3.org/1999/02/22-rdf-syntax-ns#");
        this.setCcppNS("http://www.w3.org/2002/11/08-ccpp-schema#");
    }

    void setJenaReader(String val) {
        System.setProperty("com.hp.hpl.mesa.rdf.jena.reader.RDF/XML", val);
    }

    void setRdfNS(String val) {
        this.rdfNS = val;
        ModelMem tmpModel = new ModelMem();
        try {
            this.rdfType = tmpModel.createProperty(this.rdfNS + "type");
        }
        catch (RDFException e) {
            this.logger.info("RDF exception creating ModelMem property. " + e.getMessage());
        }
    }

    void setCcppNS(String val) {
        this.ccppNS = val;
    }

    Profile process(ProfileFragment pf, int validation) {
        return this.process(pf, validation, false);
    }

    Profile process(ProfileFragment pf, int validation, boolean defaultFlag) {
        ProfileImpl profile = null;
        ModelMem model = this.getModel(pf);
        if (model == null) {
            this.logger.warning("Can't process model.");
            return null;
        }
        if (validation != 1 && validation != 3 && validation != 2) {
            validation = 1;
        }
        try {
            profile = this.processProfile(model, validation, defaultFlag);
        }
        catch (RDFException e) {
            this.logger.warning("RDF processing exception. " + e.getMessage());
            return null;
        }
        catch (RDFError e) {
            this.logger.warning("RDF processing error. " + e.getMessage());
            return null;
        }
        if (profile == null) {
            this.logger.warning("Can't process profile.");
            return null;
        }
        return profile;
    }

    private ModelMem getModel(ProfileFragment pf) {
        ModelMem model = new ModelMem();
        InputStream pfis = pf.getInputStream();
        if (pfis == null) {
            return null;
        }
        try {
            InputStreamReader read = new InputStreamReader(pfis);
            model.read((Reader)read, "");
        }
        catch (RDFException e) {
            this.logger.warning("RDF processing exception. " + e.getMessage());
            return null;
        }
        catch (RDFError e) {
            this.logger.warning("RDF processing error. " + e.getMessage());
            return null;
        }
        return model;
    }

    private ProfileImpl processProfile(ModelMem model, int validation, boolean defaultFlag) throws RDFException {
        if (validation == 3 && this.hasLoop(model)) {
            return null;
        }
        ProfileImpl prof = new ProfileImpl();
        NsIterator namespaces = model.listNameSpaces();
        while (namespaces.hasNext()) {
            String namespace = namespaces.next();
            if (namespace.equals(this.rdfNS)) continue;
            Property compProperty = model.createProperty(namespace + "component");
            NodeIterator compList = model.listObjectsOfProperty(compProperty);
            while (compList.hasNext()) {
                ComponentImpl comp;
                Resource compResource = (Resource)compList.next();
                Vector configNSs = this.getConfigNSs();
                if (!configNSs.contains(namespace)) {
                    this.logger.info("Unrecognized namespace for component. Namespace: " + namespace);
                    if (validation == 3) {
                        this.logger.warning("Can't process component. " + compResource.getURI());
                        return null;
                    }
                }
                if ((comp = this.processComponent(model, compResource, validation, defaultFlag)) != null) {
                    prof.addComponent(comp);
                    continue;
                }
                if (validation != 3) continue;
                this.logger.warning("Can't process component. " + compResource.getURI());
                return null;
            }
        }
        Set attrs = prof.getAttributes();
        if (attrs.isEmpty()) {
            this.logger.warning("Profile has no attributes.");
            return null;
        }
        ProfileDescriptionImpl profDesc = null;
        Attribute attr = (Attribute)attrs.iterator().next();
        String namespace = attr.getDescription().getURI().toString();
        namespace = namespace.substring(0, namespace.lastIndexOf(35) + 1);
        URI namespaceURI = null;
        try {
            namespaceURI = new URI(namespace);
            profDesc = this.dm.getProfileDescription(namespaceURI);
        }
        catch (URISyntaxException e) {
            this.logger.warning("Profile namespace is not a URI. Namespace: " + namespace + " " + e.getMessage());
            return null;
        }
        if (validation != 1) {
            if (profDesc == null) {
                this.logger.warning("Vocabulary not configured. Namespace: " + namespace);
                return null;
            }
        } else if ((profDesc = this.buildProfDesc(profDesc, prof, namespaceURI)) == null) {
            this.logger.warning("Vocabulary not configured. Namespace: " + namespace);
            return null;
        }
        prof.setDescription(profDesc);
        return prof;
    }

    private boolean hasLoop(ModelMem model) throws RDFException {
        if (model == null) {
            this.logger.info("Model is null.");
            return false;
        }
        StmtIterator si = model.listStatements();
        if (si == null) {
            this.logger.info("Can't list statements from model. Model: " + model);
            return false;
        }
        boolean hasLoop = false;
        si = model.listStatements();
        while (si.hasNext()) {
            Statement s = si.next();
            RDFNode obj = s.getObject();
            if (!(obj instanceof Resource)) continue;
            Resource subj = (Resource)obj;
            StmtIterator nextSI = model.listStatements((Selector)new SelectorImpl(subj, (Property)null, (RDFNode)null));
            if (!this.hasLoop(model, subj.toString(), nextSI)) continue;
            hasLoop = true;
        }
        return hasLoop;
    }

    private boolean hasLoop(ModelMem model, String start, StmtIterator si) throws RDFException {
        boolean hasLoop = false;
        while (si.hasNext()) {
            Resource res;
            StmtIterator nextSI;
            Statement s = si.next();
            RDFNode obj = s.getObject();
            if (start.equals(obj.toString())) {
                this.logger.info("Loop detected in statement. " + s.toString());
                hasLoop = true;
            }
            Resource subj = s.getSubject();
            if (!(obj instanceof Resource) || obj.toString().equals(subj.toString()) || !this.hasLoop(model, start, nextSI = model.listStatements((Selector)new SelectorImpl(res = (Resource)obj, (Property)null, (RDFNode)null)))) continue;
            hasLoop = true;
        }
        return hasLoop;
    }

    private ProfileDescriptionImpl buildProfDesc(ProfileDescriptionImpl profDesc, ProfileImpl prof, URI namespaceURI) {
        if (profDesc == null) {
            URI uvURI = null;
            try {
                uvURI = new URI("*");
            }
            catch (URISyntaxException e) {
                this.logger.info(e.getMessage());
            }
            ProfileDescriptionImpl uv = this.dm.getProfileDescription(uvURI);
            if (uv != null) {
                profDesc = (ProfileDescriptionImpl)uv.clone();
                profDesc.setURI(namespaceURI);
            }
        } else {
            profDesc = (ProfileDescriptionImpl)profDesc.clone();
        }
        if (profDesc != null) {
            Iterator i = prof.getComponents().iterator();
            while (i.hasNext()) {
                Component comp = (Component)i.next();
                ComponentDescription compDesc = comp.getDescription();
                profDesc.addComponentDescription(compDesc);
            }
        }
        return profDesc;
    }

    /*
     * Unable to fully structure code
     */
    private ComponentImpl processComponent(ModelMem model, Resource compResource, int validation, boolean defaultFlag) throws RDFException {
        if (compResource == null) {
            this.logger.warning("Component resource is null.");
            return null;
        }
        comp = new ComponentImpl();
        compType = null;
        typeProps = compResource.listProperties(this.rdfType);
        while (typeProps.hasNext()) {
            tmpType = typeProps.next().getObject().toString();
            if (compType == null) {
                compType = tmpType;
                continue;
            }
            if (tmpType.equals(compType)) continue;
            this.logger.info("Inconsistent type properties for component. " + compType + " and " + tmpType);
            if (validation == 3) {
                return null;
            }
            compType = null;
            break;
        }
        compName = compResource.getURI();
        if (compName != null) {
            compName = compName.substring(compName.lastIndexOf(35) + 1);
        }
        comp.setName(compName);
        defaultProcessed = false;
        stmts = compResource.listProperties();
        while (stmts.hasNext()) {
            statement = stmts.next();
            predicate = statement.getPredicate();
            if (predicate.equals((Object)this.rdfType)) continue;
            predicateStr = predicate.toString();
            predicateNS = predicateStr.substring(0, predicateStr.lastIndexOf(35) + 1);
            defaultProperty = model.createProperty(predicateNS + "defaults");
            capsDefaultProperty = model.createProperty(predicateNS + "Defaults");
            if (predicate.equals((Object)defaultProperty) || predicate.equals((Object)capsDefaultProperty)) {
                if (defaultProcessed) {
                    this.logger.info("Multiple defaults encountered. " + compResource.getURI());
                    if (validation == 3) {
                        this.logger.warning("Can't process default component. " + compResource.getURI());
                        return null;
                    }
                }
                if (!(configNSs = this.getConfigNSs()).contains(predicateNS)) {
                    this.logger.info("Unrecognized namespace for defaults. Namespace: " + predicateNS);
                    if (validation == 3) {
                        this.logger.warning("Can't process default component. " + compResource.getURI());
                        return null;
                    }
                }
                if ((defaultAttrs = this.processDefaultComponent(model, validation, statement)) == null || defaultAttrs.isEmpty()) {
                    this.logger.warning("No attributes in default component. " + statement.toString());
                    return null;
                }
                defaultProcessed = true;
                i = defaultAttrs.iterator();
                while (i.hasNext()) {
                    attr = (AttributeImpl)i.next();
                    uri = null;
                    try {
                        uri = new URI(attr.getDescription().getURI());
                        if (comp.getAttribute(uri) != null) continue;
                        attr.setComponent(comp);
                        comp.addAttribute(attr);
                    }
                    catch (URISyntaxException e) {
                        this.logger.info("URI syntax exception for default attribute. " + e.getMessage());
                    }
                }
                continue;
            }
            attr = this.processAttribute(model, statement, compType, validation, defaultFlag);
            if (attr != null) {
                uri = null;
                try {
                    uri = new URI(attr.getDescription().getURI());
                    prev = comp.getAttribute(uri);
                    if (prev == null || prev.isDefault()) {
                        attr.setComponent(comp);
                        comp.addAttribute(attr);
                        continue;
                    }
                    this.logger.info("Duplicate attribute value. " + uri.toString());
                    if (validation != 3) continue;
                    this.logger.warning("Can't process attribute. " + statement.toString());
                    return null;
                }
                catch (URISyntaxException e) {
                    this.logger.info("URI syntax exception for attribute. " + e.getMessage());
                }
                continue;
            }
            if (validation != 3) continue;
            this.logger.warning("Can't process attribute. " + statement.toString());
            return null;
        }
        attrs = comp.getAttributes();
        if (attrs.isEmpty()) {
            this.logger.warning("Component has no attributes. " + compName);
            return null;
        }
        compDesc = null;
        compTypeURI = null;
        if (compType != null) {
            try {
                compTypeURI = new URI(compType);
                compDesc = this.dm.getComponentDescription(compTypeURI);
            }
            catch (URISyntaxException e) {
                this.logger.info("Component type is not a URI. " + e.getMessage());
            }
        } else {
            this.logger.info("Component is missing rdf:type property. " + compResource.toString());
            i = attrs.iterator();
            while (i.hasNext()) {
                attr = (Attribute)i.next();
                attrCD = (ComponentDescriptionImpl)attr.getDescription().getComponentDescription();
                if (compDesc != null && !compDesc.equals(attrCD)) {
                    compDesc = null;
                    break;
                }
                compDesc = attrCD;
            }
            if (compDesc != null) {
                compTypeURI = compDesc.getURIObject();
            } else {
                this.logger.warning("Can't infer component type from attributes. " + compResource.toString());
                return null;
            }
        }
        if (validation != 1) ** GOTO lbl116
        if (compTypeURI != null) {
            compDesc = this.buildCompDesc(compDesc, comp, compTypeURI);
        } else {
            this.logger.warning("Can't get component type.");
            return null;
lbl116:
            // 1 sources

            if (compDesc == null) {
                this.logger.warning("Vocabulary component not configured. " + compType);
                return null;
            }
            i = comp.getAttributes().iterator();
            while (i.hasNext()) {
                attr = (AttributeImpl)i.next();
                if (compDesc.getAttributeDescription(attr.getName()) != null) continue;
                comp.removeAttribute(attr);
                this.logger.info("Attribute not defined in component. Attribute: " + attr.getDescription().getURI() + " " + "Component: " + compType);
                if (validation != 3) continue;
                return null;
            }
        }
        comp.setDescription(compDesc);
        return comp;
    }

    private Set processDefaultComponent(ModelMem model, int validation, Statement stmt) throws RDFException {
        Set attrs;
        block4: {
            Resource res;
            block3: {
                attrs = null;
                res = (Resource)stmt.getObject();
                StmtIterator iter = res.listProperties();
                if (!iter.hasNext()) break block3;
                ComponentImpl inlineComp = this.processComponent(model, res, validation, true);
                if (inlineComp == null) break block4;
                attrs = inlineComp.getAttributes();
                break block4;
            }
            try {
                URL refURL = new URL(res.toString());
                ProfileFragment pf = ProfileFragmentFactory.getInstance().newProfileFragment(refURL);
                ModelMem refModel = this.getModel(pf);
                Resource refRes = this.getRootResource(refModel);
                ComponentImpl refComp = this.processComponent(refModel, refRes, validation, true);
                if (refComp == null) {
                    this.logger.warning("Can't process default component reference. " + refURL.toString());
                    return null;
                }
                attrs = refComp.getAttributes();
            }
            catch (MalformedURLException e) {
                this.logger.warning("Default component reference is not a URL. " + e.getMessage());
            }
        }
        return attrs;
    }

    private Resource getRootResource(ModelMem model) throws RDFException {
        Resource root = null;
        if (model == null) {
            this.logger.warning("Model is null.");
            return null;
        }
        StmtIterator si = model.listStatements();
        if (si == null) {
            this.logger.info("Can't list statements from model. Model: " + model);
            return null;
        }
        if (!si.hasNext()) {
            this.logger.info("Model is empty. Model: " + model);
            return null;
        }
        RDFNode currentNode = si.next().getObject();
        while (root == null) {
            StmtIterator iter = model.listStatements((Selector)new SelectorImpl((Resource)null, (Property)null, currentNode));
            if (iter.hasNext()) {
                currentNode = iter.next().getSubject();
                continue;
            }
            root = (Resource)currentNode;
        }
        return root;
    }

    private ComponentDescriptionImpl buildCompDesc(ComponentDescriptionImpl compDesc, ComponentImpl comp, URI compTypeURI) {
        if (compDesc == null) {
            compDesc = new ComponentDescriptionImpl();
            compDesc.setDefined(false);
            compDesc.setURI(compTypeURI);
            compDesc.setLocalType(compTypeURI.getFragment());
        } else {
            compDesc = (ComponentDescriptionImpl)compDesc.clone();
        }
        Iterator i = comp.getAttributes().iterator();
        while (i.hasNext()) {
            AttributeImpl attr = (AttributeImpl)i.next();
            AttributeDescriptionImpl attrDesc = (AttributeDescriptionImpl)attr.getDescription();
            attrDesc.setComponentDescription(compDesc);
            compDesc.addAttributeDescription(attrDesc);
        }
        return compDesc;
    }

    private AttributeImpl processAttribute(ModelMem model, Statement statement, String compType, int validation, boolean defaultFlag) throws RDFException {
        AttributeImpl attr = null;
        URI attrURI = null;
        String attrURIStr = statement.getPredicate().toString();
        try {
            attrURI = new URI(attrURIStr);
        }
        catch (URISyntaxException e) {
            this.logger.warning("Attribute identifier is not a URI. " + e.getMessage());
            return null;
        }
        AttributeDescriptionImpl attrDesc = this.dm.getAttributeDescription(attrURI);
        Vector<String> attrValue = new Vector<String>();
        if (attrDesc == null) {
            if (validation != 1) {
                this.logger.warning("Vocabulary attribute not configured. " + attrURI.toString());
                return null;
            }
            attrDesc = this.buildAttrDesc(model, statement, attrURI);
        }
        if (attrDesc != null) {
            Class composition = attrDesc.getComposition();
            if (statement.getObject() instanceof Literal) {
                attrValue.add(new String(statement.getObject().toString().trim()));
                if (validation != 1 && composition != null) {
                    this.logger.warning("Inconsistent composition for attribute. " + attrURIStr);
                    return null;
                }
            } else {
                NodeIterator i;
                Seq theContainer;
                StmtIterator iter = model.listStatements((Selector)new SelectorImpl((Resource)statement.getObject(), this.rdfType, (RDFNode)model.createResource(this.rdfNS + "Seq")));
                if (iter.hasNext()) {
                    theContainer = model.getSeq((Resource)statement.getObject());
                    i = theContainer.iterator();
                    while (i.hasNext()) {
                        attrValue.add(new String(i.next().toString().trim()));
                    }
                    Class seqComposition = (Class)this.dm.getCompositions().get("sequence");
                    if (!(validation == 1 || composition != null && seqComposition.equals(composition))) {
                        this.logger.warning("Inconsistent composition for attribute. " + attrURIStr);
                        return null;
                    }
                }
                if ((iter = model.listStatements((Selector)new SelectorImpl((Resource)statement.getObject(), this.rdfType, (RDFNode)model.createResource(this.rdfNS + "Bag")))).hasNext()) {
                    theContainer = model.getBag((Resource)statement.getObject());
                    i = theContainer.iterator();
                    while (i.hasNext()) {
                        attrValue.add(new String(i.next().toString().trim()));
                    }
                    Class setComposition = (Class)this.dm.getCompositions().get("set");
                    if (!(validation == 1 || composition != null && setComposition.equals(composition))) {
                        this.logger.warning("Inconsistent composition for attribute. " + attrURIStr);
                        return null;
                    }
                }
            }
            try {
                Class baseType = attrDesc.getBaseType();
                if (composition != null) {
                    attr = (AttributeImpl)composition.newInstance();
                    AttributeImpl tmp = (AttributeImpl)baseType.newInstance();
                    Vector<Object> value = new Vector<Object>();
                    int i = 0;
                    while (i < attrValue.size()) {
                        tmp.setValue(attrValue.elementAt(i));
                        Object tmpValue = tmp.getValue();
                        if (tmpValue != null) {
                            value.add(tmp.getValue());
                        } else {
                            this.logger.info("Can't parse value '" + (String)attrValue.elementAt(i) + "' " + "for attribute " + attrURIStr);
                            if (validation == 3) {
                                return null;
                            }
                        }
                        ++i;
                    }
                    attr.setValue(value);
                } else {
                    attr = (AttributeImpl)baseType.newInstance();
                    if (attrValue.size() > 0) {
                        attr.setValue(attrValue.elementAt(0));
                    }
                    if (attr.getValue() == null) {
                        String logValue = null;
                        logValue = attrValue.size() > 0 ? (String)attrValue.elementAt(0) : "Null Value";
                        this.logger.info("Can't parse value '" + logValue + "' " + "for attribute " + attrURIStr);
                        return null;
                    }
                }
            }
            catch (IllegalAccessException e) {
                this.logger.warning("IllegalAccessException processing attribute. " + e.getMessage());
                return null;
            }
            catch (InstantiationException e) {
                this.logger.warning("InstantiationException processing attribute. " + e.getMessage());
                return null;
            }
            attr.setDescription(attrDesc);
            attr.setDefault(defaultFlag);
        }
        return attr;
    }

    private AttributeDescriptionImpl buildAttrDesc(ModelMem model, Statement statement, URI attrURI) throws RDFException {
        AttributeDescriptionImpl attrDesc = new AttributeDescriptionImpl();
        attrDesc.setBaseType((Class)this.dm.getBaseClasses().get("literal"));
        String compStr = "simple";
        if (!(statement.getObject() instanceof Literal)) {
            StmtIterator iterSeq;
            StmtIterator iterBag = model.listStatements((Selector)new SelectorImpl((Resource)statement.getObject(), this.rdfType, (RDFNode)model.createResource(this.rdfNS + "Bag")));
            if (iterBag.hasNext()) {
                compStr = "set";
            }
            if ((iterSeq = model.listStatements((Selector)new SelectorImpl((Resource)statement.getObject(), this.rdfType, (RDFNode)model.createResource(this.rdfNS + "Seq")))).hasNext()) {
                compStr = "sequence";
            }
        }
        Class composition = (Class)this.dm.getCompositions().get(compStr);
        attrDesc.setComposition(composition);
        attrDesc.setName(attrURI.getFragment());
        Integer resolution = (Integer)this.dm.getResPolicies().get("override");
        attrDesc.setResolution(resolution);
        attrDesc.setURI(attrURI);
        attrDesc.setDefined(false);
        return attrDesc;
    }

    private Vector getConfigNSs() {
        Vector<String> configNSs = new Vector<String>();
        configNSs.add(this.ccppNS);
        Set vocabURIs = this.dm.getVocabularyURIs();
        Iterator i = vocabURIs.iterator();
        while (i.hasNext()) {
            URI ns = (URI)i.next();
            configNSs.add(ns.toString());
        }
        return configNSs;
    }
}

