/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.urlshortener;

import java.io.IOException;
import java.util.Map;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.DefaultHttpMethodRetryHandler;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.ByteArrayRequestEntity;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.gcube.portlets.user.urlshortener.UrlEncoderUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpCallerUtil {
    public static final Logger logger = LoggerFactory.getLogger(HttpCallerUtil.class);
    public static final int TIME_OUT_REQUESTS = 5000;
    private String urlService = "";
    private HttpClient httpClient = null;
    private String username = "";
    private String password = "";

    public HttpCallerUtil(String url, String user, String password) {
        this.urlService = url;
        MultiThreadedHttpConnectionManager connectionManager = new MultiThreadedHttpConnectionManager();
        connectionManager.getParams().setSoTimeout(5000);
        this.httpClient = new HttpClient((HttpConnectionManager)connectionManager);
        this.username = user;
        this.password = password;
        UsernamePasswordCredentials defaultcreds = new UsernamePasswordCredentials(user, password);
        this.httpClient.getState().setCredentials(AuthScope.ANY, (Credentials)defaultcreds);
    }

    public String callGet(String urlMethod, Map<String, String> parameters) throws Exception {
        HttpClient client = new HttpClient();
        String query = UrlEncoderUtil.encodeQuery(parameters);
        String fullUrl = this.urlService + "/" + urlMethod + "?" + query;
        logger.info("call get .... " + fullUrl);
        GetMethod method = new GetMethod(fullUrl);
        method.getParams().setParameter("http.method.retry-handler", (Object)new DefaultHttpMethodRetryHandler(3, false));
        try {
            int statusCode = client.executeMethod((HttpMethod)method);
            if (statusCode != 200) {
                logger.error("Method failed: " + method.getStatusLine());
            }
            byte[] responseBody = method.getResponseBody();
            String string = new String(responseBody);
            return string;
        }
        catch (HttpException e) {
            logger.error("Fatal protocol violation: " + e.getMessage());
            throw new Exception("Fatal protocol violation: " + e.getMessage());
        }
        catch (IOException e) {
            logger.error("Fatal transport error: " + e.getMessage());
            throw new Exception("Fatal transport violation: " + e.getMessage());
        }
        finally {
            method.releaseConnection();
        }
    }

    public String callPost(String urlMethod, String body, String contentType) throws Exception {
        PostMethod method = new PostMethod(this.urlService + "/" + urlMethod);
        method.setRequestHeader("Content-type", contentType);
        logger.trace("call post .... " + this.urlService + "/" + urlMethod);
        logger.debug("\tcall post body.... " + body);
        method.setRequestEntity((RequestEntity)new ByteArrayRequestEntity(body.getBytes()));
        byte[] responseBody = null;
        try {
            int statusCode = this.httpClient.executeMethod((HttpMethod)method);
            if (statusCode != 200 && statusCode != 201) {
                logger.error("Method failed: " + method.getStatusLine() + "; Response bpdy: " + method.getResponseBody());
                method.releaseConnection();
                throw new Exception("Method failed: " + method.getStatusLine() + "; Response body: " + new String(method.getResponseBody()));
            }
            responseBody = method.getResponseBody();
        }
        catch (HttpException e) {
            logger.error("Fatal protocol violation: ", (Throwable)e);
            method.releaseConnection();
            throw new Exception("Fatal protocol violation: " + e.getMessage());
        }
        catch (Exception e) {
            logger.error("Fatal transport error: ", (Throwable)e);
            method.releaseConnection();
            throw new Exception("Fatal transport error: " + e.getMessage());
        }
        method.releaseConnection();
        return new String(responseBody);
    }

    public String getUrlservice() {
        return this.urlService;
    }

    public void setUrlservice(String urlservice) {
        this.urlService = urlservice;
    }

    public HttpClient getClient() {
        return this.httpClient;
    }

    public void setClient(HttpClient client) {
        this.httpClient = client;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("HttpCallerUtil [urlService=");
        builder.append(this.urlService);
        builder.append(", httpClient=");
        builder.append(this.httpClient);
        builder.append(", username=");
        builder.append(this.username);
        builder.append(", password=");
        builder.append(this.password);
        builder.append("]");
        return builder.toString();
    }
}

