/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.framework.core.security;

import java.io.IOException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JaasCallbackHandler
implements CallbackHandler {
    protected String username = null;
    protected String password = null;
    private static final Logger logger = LoggerFactory.getLogger(JaasCallbackHandler.class);

    public JaasCallbackHandler(String username, String password) {
        this.username = username;
        this.password = password;
    }

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        for (int i = 0; i < callbacks.length; ++i) {
            if (callbacks[i] instanceof NameCallback) {
                logger.debug("responding to NameCallback");
                ((NameCallback)callbacks[i]).setName(this.username);
                continue;
            }
            if (callbacks[i] instanceof PasswordCallback) {
                logger.debug("responding to PasswordCallback");
                ((PasswordCallback)callbacks[i]).setPassword(this.password != null ? this.password.toCharArray() : new char[]{});
                continue;
            }
            logger.debug("unsupported callback: " + callbacks[i].getClass());
            throw new UnsupportedCallbackException(callbacks[i]);
        }
    }
}

