/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.jackrabbit.core.fs.FileSystemException;
import org.apache.jackrabbit.core.fs.FileSystemResource;
import org.apache.jackrabbit.core.query.lucene.SynonymProvider;
import org.apache.jackrabbit.core.query.lucene.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertiesSynonymProvider
implements SynonymProvider {
    private static final Logger log = LoggerFactory.getLogger(PropertiesSynonymProvider.class);
    private static final String[] EMPTY_ARRAY = new String[0];
    private static final long CHECK_INTERVAL = 10000L;
    private FileSystemResource config;
    private long lastCheck;
    private long configLastModified;
    private Map<String, String[]> synonyms = new HashMap<String, String[]>();

    @Override
    public synchronized void initialize(FileSystemResource fsr) throws IOException {
        if (fsr == null) {
            throw new IOException("PropertiesSynonymProvider requires a path configuration");
        }
        try {
            this.config = fsr;
            this.synonyms = PropertiesSynonymProvider.getSynonyms(this.config);
            this.configLastModified = this.config.lastModified();
            this.lastCheck = System.currentTimeMillis();
        }
        catch (FileSystemException e) {
            throw Util.createIOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getSynonyms(String term) {
        String[] syns;
        this.checkConfigUpdated();
        term = term.toLowerCase();
        PropertiesSynonymProvider propertiesSynonymProvider = this;
        synchronized (propertiesSynonymProvider) {
            syns = this.synonyms.get(term);
        }
        if (syns == null) {
            syns = EMPTY_ARRAY;
        }
        return syns;
    }

    private synchronized void checkConfigUpdated() {
        if (this.lastCheck + 10000L > System.currentTimeMillis()) {
            return;
        }
        try {
            if (this.configLastModified != this.config.lastModified()) {
                this.synonyms = PropertiesSynonymProvider.getSynonyms(this.config);
                this.configLastModified = this.config.lastModified();
                log.info("Reloaded synonyms from {}", (Object)this.config.getPath());
            }
        }
        catch (Exception e) {
            log.error("Exception while reading synonyms", (Throwable)e);
        }
        this.lastCheck = System.currentTimeMillis();
    }

    private static Map<String, String[]> getSynonyms(FileSystemResource config) throws IOException {
        try {
            HashMap<String, String[]> synonyms = new HashMap<String, String[]>();
            Properties props = new Properties();
            props.load(config.getInputStream());
            for (Map.Entry<Object, Object> entry : props.entrySet()) {
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                PropertiesSynonymProvider.addSynonym(key, value, synonyms);
                PropertiesSynonymProvider.addSynonym(value, key, synonyms);
            }
            return synonyms;
        }
        catch (FileSystemException e) {
            throw Util.createIOException(e);
        }
    }

    private static void addSynonym(String term, String synonym, Map<String, String[]> synonyms) {
        String[] syns = synonyms.get(term = term.toLowerCase());
        if (syns == null) {
            syns = new String[]{synonym};
        } else {
            String[] tmp = new String[syns.length + 1];
            System.arraycopy(syns, 0, tmp, 0, syns.length);
            tmp[syns.length] = synonym;
            syns = tmp;
        }
        synonyms.put(term, syns);
    }
}

