/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.grs.store.buffer;

import gr.uoa.di.madgik.grs.proxy.IWriterProxy;
import gr.uoa.di.madgik.grs.record.Record;
import gr.uoa.di.madgik.grs.record.RecordDefinition;
import gr.uoa.di.madgik.grs.registry.GRSRegistry;
import gr.uoa.di.madgik.grs.store.buffer.BufferStoreEntry;
import gr.uoa.di.madgik.grs.store.buffer.GRS2BufferStoreAccessException;
import gr.uoa.di.madgik.grs.store.buffer.GRS2BufferStoreInvalidArgumentException;
import gr.uoa.di.madgik.grs.store.buffer.GRS2BufferStoreInvalidOperationException;
import gr.uoa.di.madgik.grs.store.buffer.IBufferStore;
import gr.uoa.di.madgik.grs.store.buffer.multiplex.FifoDemultiplex;
import gr.uoa.di.madgik.grs.store.buffer.multiplex.FirstAvailableDemultiplex;
import gr.uoa.di.madgik.grs.store.buffer.multiplex.IDemultiplex;
import gr.uoa.di.madgik.grs.writer.GRS2WriterException;
import gr.uoa.di.madgik.grs.writer.RecordWriter;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BufferStoreReader
extends Thread {
    private static Logger logger = Logger.getLogger(BufferStoreReader.class.getName());
    private String key = null;
    private IBufferStore store = null;
    private ArrayList<BufferStoreEntry> entries = null;
    private RecordDefinition[] definitions = null;
    private ArrayList<RecordDefinition[]> definitionsList = null;
    private RecordWriter<Record> writer = null;
    private IWriterProxy proxy = null;
    private IDemultiplex algo = null;

    public BufferStoreReader(String key, IWriterProxy proxy) throws GRS2BufferStoreInvalidOperationException, GRS2BufferStoreAccessException, GRS2BufferStoreInvalidArgumentException, GRS2WriterException {
        this.key = key;
        this.proxy = proxy;
        this.initialize();
    }

    public URI populate() throws GRS2WriterException {
        this.setName("buffer store access");
        this.setDaemon(true);
        this.start();
        return this.writer.getLocator();
    }

    public void dispose() {
        if (this.algo != null) {
            try {
                this.algo.dispose();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.writer != null) {
            try {
                this.writer.dispose();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.entries = null;
        this.definitions = null;
        this.definitionsList = null;
        this.proxy = null;
        this.algo = null;
    }

    @Override
    public void run() {
        block9: {
            try {
                switch (this.store.getMultiplexType()) {
                    case FIFO: {
                        this.algo = new FifoDemultiplex();
                        break;
                    }
                    case FirstAvailable: {
                        this.algo = new FirstAvailableDemultiplex();
                        break;
                    }
                    default: {
                        throw new GRS2BufferStoreInvalidArgumentException("Not recognizable multiplex type " + this.store.getMultiplexType().toString());
                    }
                }
                this.writer.setBufferStore(this.store);
                this.algo.setDefinitionsList(this.definitionsList);
                this.algo.setEntries(this.entries);
                this.algo.setWriter(this.writer);
                this.algo.setBufferStore(this.store);
                this.algo.setModificationNotify(this.store.getModificationObject());
                this.algo.demultiplex();
            }
            catch (Exception ex) {
                try {
                    if (this.writer != null) {
                        this.writer.dispose();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (!logger.isLoggable(Level.WARNING)) break block9;
                logger.log(Level.WARNING, "Could not complete store access", ex);
            }
        }
    }

    private void initialize() throws GRS2BufferStoreInvalidArgumentException, GRS2BufferStoreInvalidOperationException, GRS2BufferStoreAccessException, GRS2WriterException {
        this.store = GRSRegistry.Registry.getStore(this.key);
        if (this.store == null) {
            throw new GRS2BufferStoreInvalidArgumentException("Could not locate buffer store with provided key " + this.key);
        }
        this.store.associateStoreReader(this);
        this.entries = this.store.getEntries();
        if (this.entries == null) {
            throw new GRS2BufferStoreInvalidOperationException("No available buffer entries");
        }
        this.initDefinitions();
        this.writer = new RecordWriter(this.proxy, this.definitions);
        this.store.markActivity();
    }

    private void initDefinitions() throws GRS2BufferStoreAccessException {
        this.definitionsList = new ArrayList();
        ArrayList<RecordDefinition> definitions = new ArrayList<RecordDefinition>();
        for (BufferStoreEntry entry : this.entries) {
            RecordDefinition[] defs = entry.getDefinitions();
            definitions.addAll(Arrays.asList(defs));
            this.definitionsList.add(defs);
        }
        this.definitions = definitions.toArray(new RecordDefinition[0]);
    }
}

