/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.cache.memcached;

import com.liferay.portal.cache.memcached.MemcachePortalCache;
import com.liferay.portal.cache.memcached.MemcachedClientFactory;
import com.liferay.portal.kernel.cache.PortalCache;
import com.liferay.portal.kernel.cache.PortalCacheManager;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import net.spy.memcached.MemcachedClientIF;

public class MemcachePortalCacheManager<V>
implements PortalCacheManager<String, V> {
    private MemcachedClientFactory _memcachedClientFactory;
    private Map<String, MemcachePortalCache<V>> _memcachePortalCaches = new ConcurrentHashMap<String, MemcachePortalCache<V>>();
    private int _timeout;
    private TimeUnit _timeoutTimeUnit;

    public void clearAll() {
        this._memcachePortalCaches.clear();
    }

    public void destroy() throws Exception {
        for (MemcachePortalCache<V> memcachePortalCache : this._memcachePortalCaches.values()) {
            memcachePortalCache.destroy();
        }
    }

    public PortalCache<String, V> getCache(String name) {
        return this.getCache(name, false);
    }

    public PortalCache<String, V> getCache(String name, boolean blocking) {
        MemcachePortalCache<V> memcachePortalCache = this._memcachePortalCaches.get(name);
        if (memcachePortalCache == null) {
            try {
                MemcachedClientIF memcachedClient = this._memcachedClientFactory.getMemcachedClient();
                memcachePortalCache = new MemcachePortalCache(name, memcachedClient, this._timeout, this._timeoutTimeUnit);
                this._memcachePortalCaches.put(name, memcachePortalCache);
            }
            catch (Exception e2) {
                throw new IllegalStateException("Unable to initiatlize Memcache connection", e2);
            }
        }
        return memcachePortalCache;
    }

    public void reconfigureCaches(URL configurationURL) {
    }

    public void removeCache(String name) {
        this._memcachePortalCaches.remove(name);
    }

    public void setMemcachedClientPool(MemcachedClientFactory memcachedClientFactory) {
        this._memcachedClientFactory = memcachedClientFactory;
    }

    public void setTimeout(int timeout) {
        this._timeout = timeout;
    }

    public void setTimeoutTimeUnit(String timeoutTimeUnit) {
        this._timeoutTimeUnit = TimeUnit.valueOf(timeoutTimeUnit);
    }
}

