/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.iframe.util;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.Role;
import com.liferay.portal.model.User;
import com.liferay.portal.service.RoleLocalServiceUtil;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PropsValues;
import javax.portlet.PortletRequest;

public class IFrameUtil {
    private static Log _log = LogFactoryUtil.getLog(IFrameUtil.class);

    public static String getPassword(PortletRequest portletRequest, String password) throws PortalException, SystemException {
        if (!IFrameUtil.isPasswordTokenEnabled(portletRequest)) {
            return "";
        }
        if ((Validator.isNull((String)password) || password.equals("@password@")) && (password = PortalUtil.getUserPassword((PortletRequest)portletRequest)) == null) {
            password = "";
        }
        return password;
    }

    public static String getUserName(PortletRequest portletRequest, String userName) throws PortalException, SystemException {
        User user = PortalUtil.getUser((PortletRequest)portletRequest);
        if (user == null) {
            return userName;
        }
        if (Validator.isNull((String)userName) || userName.equals("@user_id@")) {
            userName = portletRequest.getRemoteUser();
        } else if (userName.equals("@email_address@")) {
            userName = user.getEmailAddress();
        } else if (userName.equals("@screen_name@")) {
            userName = user.getScreenName();
        }
        return userName;
    }

    public static boolean isPasswordTokenEnabled(PortletRequest portletRequest) throws PortalException, SystemException {
        block5: {
            ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
            Layout layout = themeDisplay.getLayout();
            String roleName = PropsValues.IFRAME_PASSWORD_PASSWORD_TOKEN_ROLE;
            if (Validator.isNull((String)roleName)) {
                return true;
            }
            if (layout.isPrivateLayout() && layout.getGroup().isUser()) {
                return true;
            }
            try {
                Role role = RoleLocalServiceUtil.getRole((long)themeDisplay.getCompanyId(), (String)roleName);
                if (UserLocalServiceUtil.hasRoleUser((long)role.getRoleId(), (long)themeDisplay.getUserId())) {
                    return true;
                }
            }
            catch (Exception exception) {
                if (!_log.isWarnEnabled()) break block5;
                _log.warn((Object)("Error getting role " + roleName + ". The password token " + "will be disabled."));
            }
        }
        return false;
    }
}

