/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.shopping.service.persistence;

import com.liferay.portal.kernel.cache.CacheRegistryUtil;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.EntityCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.SQLQuery;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.dao.orm.SessionFactory;
import com.liferay.portal.kernel.dao.orm.Type;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.InstanceFactory;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnmodifiableList;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.CacheModel;
import com.liferay.portal.model.ModelListener;
import com.liferay.portal.security.permission.InlineSQLHelperUtil;
import com.liferay.portal.service.persistence.impl.BasePersistenceImpl;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.shopping.NoSuchItemException;
import com.liferay.portlet.shopping.model.ShoppingItem;
import com.liferay.portlet.shopping.model.impl.ShoppingItemImpl;
import com.liferay.portlet.shopping.model.impl.ShoppingItemModelImpl;
import com.liferay.portlet.shopping.service.persistence.ShoppingItemPersistence;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class ShoppingItemPersistenceImpl
extends BasePersistenceImpl<ShoppingItem>
implements ShoppingItemPersistence {
    public static final String FINDER_CLASS_NAME_ENTITY = ShoppingItemImpl.class.getName();
    public static final String FINDER_CLASS_NAME_LIST_WITH_PAGINATION = String.valueOf(FINDER_CLASS_NAME_ENTITY) + ".List1";
    public static final String FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION = String.valueOf(FINDER_CLASS_NAME_ENTITY) + ".List2";
    public static final FinderPath FINDER_PATH_WITH_PAGINATION_FIND_ALL = new FinderPath(ShoppingItemModelImpl.ENTITY_CACHE_ENABLED, ShoppingItemModelImpl.FINDER_CACHE_ENABLED, ShoppingItemImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findAll", new String[0]);
    public static final FinderPath FINDER_PATH_WITHOUT_PAGINATION_FIND_ALL = new FinderPath(ShoppingItemModelImpl.ENTITY_CACHE_ENABLED, ShoppingItemModelImpl.FINDER_CACHE_ENABLED, ShoppingItemImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findAll", new String[0]);
    public static final FinderPath FINDER_PATH_COUNT_ALL = new FinderPath(ShoppingItemModelImpl.ENTITY_CACHE_ENABLED, ShoppingItemModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countAll", new String[0]);
    public static final FinderPath FINDER_PATH_FETCH_BY_SMALLIMAGEID = new FinderPath(ShoppingItemModelImpl.ENTITY_CACHE_ENABLED, ShoppingItemModelImpl.FINDER_CACHE_ENABLED, ShoppingItemImpl.class, FINDER_CLASS_NAME_ENTITY, "fetchBySmallImageId", new String[]{Long.class.getName()}, ShoppingItemModelImpl.SMALLIMAGEID_COLUMN_BITMASK);
    public static final FinderPath FINDER_PATH_COUNT_BY_SMALLIMAGEID = new FinderPath(ShoppingItemModelImpl.ENTITY_CACHE_ENABLED, ShoppingItemModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countBySmallImageId", new String[]{Long.class.getName()});
    private static final String _FINDER_COLUMN_SMALLIMAGEID_SMALLIMAGEID_2 = "shoppingItem.smallImageId = ?";
    public static final FinderPath FINDER_PATH_FETCH_BY_MEDIUMIMAGEID = new FinderPath(ShoppingItemModelImpl.ENTITY_CACHE_ENABLED, ShoppingItemModelImpl.FINDER_CACHE_ENABLED, ShoppingItemImpl.class, FINDER_CLASS_NAME_ENTITY, "fetchByMediumImageId", new String[]{Long.class.getName()}, ShoppingItemModelImpl.MEDIUMIMAGEID_COLUMN_BITMASK);
    public static final FinderPath FINDER_PATH_COUNT_BY_MEDIUMIMAGEID = new FinderPath(ShoppingItemModelImpl.ENTITY_CACHE_ENABLED, ShoppingItemModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByMediumImageId", new String[]{Long.class.getName()});
    private static final String _FINDER_COLUMN_MEDIUMIMAGEID_MEDIUMIMAGEID_2 = "shoppingItem.mediumImageId = ?";
    public static final FinderPath FINDER_PATH_FETCH_BY_LARGEIMAGEID = new FinderPath(ShoppingItemModelImpl.ENTITY_CACHE_ENABLED, ShoppingItemModelImpl.FINDER_CACHE_ENABLED, ShoppingItemImpl.class, FINDER_CLASS_NAME_ENTITY, "fetchByLargeImageId", new String[]{Long.class.getName()}, ShoppingItemModelImpl.LARGEIMAGEID_COLUMN_BITMASK);
    public static final FinderPath FINDER_PATH_COUNT_BY_LARGEIMAGEID = new FinderPath(ShoppingItemModelImpl.ENTITY_CACHE_ENABLED, ShoppingItemModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByLargeImageId", new String[]{Long.class.getName()});
    private static final String _FINDER_COLUMN_LARGEIMAGEID_LARGEIMAGEID_2 = "shoppingItem.largeImageId = ?";
    public static final FinderPath FINDER_PATH_WITH_PAGINATION_FIND_BY_G_C = new FinderPath(ShoppingItemModelImpl.ENTITY_CACHE_ENABLED, ShoppingItemModelImpl.FINDER_CACHE_ENABLED, ShoppingItemImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByG_C", new String[]{Long.class.getName(), Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()});
    public static final FinderPath FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_G_C = new FinderPath(ShoppingItemModelImpl.ENTITY_CACHE_ENABLED, ShoppingItemModelImpl.FINDER_CACHE_ENABLED, ShoppingItemImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByG_C", new String[]{Long.class.getName(), Long.class.getName()}, ShoppingItemModelImpl.GROUPID_COLUMN_BITMASK | ShoppingItemModelImpl.CATEGORYID_COLUMN_BITMASK);
    public static final FinderPath FINDER_PATH_COUNT_BY_G_C = new FinderPath(ShoppingItemModelImpl.ENTITY_CACHE_ENABLED, ShoppingItemModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByG_C", new String[]{Long.class.getName(), Long.class.getName()});
    private static final String _FINDER_COLUMN_G_C_GROUPID_2 = "shoppingItem.groupId = ? AND ";
    private static final String _FINDER_COLUMN_G_C_CATEGORYID_2 = "shoppingItem.categoryId = ?";
    public static final FinderPath FINDER_PATH_FETCH_BY_C_S = new FinderPath(ShoppingItemModelImpl.ENTITY_CACHE_ENABLED, ShoppingItemModelImpl.FINDER_CACHE_ENABLED, ShoppingItemImpl.class, FINDER_CLASS_NAME_ENTITY, "fetchByC_S", new String[]{Long.class.getName(), String.class.getName()}, ShoppingItemModelImpl.COMPANYID_COLUMN_BITMASK | ShoppingItemModelImpl.SKU_COLUMN_BITMASK);
    public static final FinderPath FINDER_PATH_COUNT_BY_C_S = new FinderPath(ShoppingItemModelImpl.ENTITY_CACHE_ENABLED, ShoppingItemModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByC_S", new String[]{Long.class.getName(), String.class.getName()});
    private static final String _FINDER_COLUMN_C_S_COMPANYID_2 = "shoppingItem.companyId = ? AND ";
    private static final String _FINDER_COLUMN_C_S_SKU_1 = "shoppingItem.sku IS NULL";
    private static final String _FINDER_COLUMN_C_S_SKU_2 = "shoppingItem.sku = ?";
    private static final String _FINDER_COLUMN_C_S_SKU_3 = "(shoppingItem.sku IS NULL OR shoppingItem.sku = '')";
    private static final String _SQL_SELECT_SHOPPINGITEM = "SELECT shoppingItem FROM ShoppingItem shoppingItem";
    private static final String _SQL_SELECT_SHOPPINGITEM_WHERE = "SELECT shoppingItem FROM ShoppingItem shoppingItem WHERE ";
    private static final String _SQL_COUNT_SHOPPINGITEM = "SELECT COUNT(shoppingItem) FROM ShoppingItem shoppingItem";
    private static final String _SQL_COUNT_SHOPPINGITEM_WHERE = "SELECT COUNT(shoppingItem) FROM ShoppingItem shoppingItem WHERE ";
    private static final String _FILTER_ENTITY_TABLE_FILTER_PK_COLUMN = "shoppingItem.itemId";
    private static final String _FILTER_SQL_SELECT_SHOPPINGITEM_WHERE = "SELECT DISTINCT {shoppingItem.*} FROM ShoppingItem shoppingItem WHERE ";
    private static final String _FILTER_SQL_SELECT_SHOPPINGITEM_NO_INLINE_DISTINCT_WHERE_1 = "SELECT {ShoppingItem.*} FROM (SELECT DISTINCT shoppingItem.itemId FROM ShoppingItem shoppingItem WHERE ";
    private static final String _FILTER_SQL_SELECT_SHOPPINGITEM_NO_INLINE_DISTINCT_WHERE_2 = ") TEMP_TABLE INNER JOIN ShoppingItem ON TEMP_TABLE.itemId = ShoppingItem.itemId";
    private static final String _FILTER_SQL_COUNT_SHOPPINGITEM_WHERE = "SELECT COUNT(DISTINCT shoppingItem.itemId) AS COUNT_VALUE FROM ShoppingItem shoppingItem WHERE ";
    private static final String _FILTER_ENTITY_ALIAS = "shoppingItem";
    private static final String _FILTER_ENTITY_TABLE = "ShoppingItem";
    private static final String _ORDER_BY_ENTITY_ALIAS = "shoppingItem.";
    private static final String _ORDER_BY_ENTITY_TABLE = "ShoppingItem.";
    private static final String _NO_SUCH_ENTITY_WITH_PRIMARY_KEY = "No ShoppingItem exists with the primary key ";
    private static final String _NO_SUCH_ENTITY_WITH_KEY = "No ShoppingItem exists with the key {";
    private static final boolean _HIBERNATE_CACHE_USE_SECOND_LEVEL_CACHE = PropsValues.HIBERNATE_CACHE_USE_SECOND_LEVEL_CACHE;
    private static Log _log = LogFactoryUtil.getLog(ShoppingItemPersistenceImpl.class);
    private static Set<String> _badColumnNames = SetUtil.fromArray((Object[])new String[]{"fields", "featured", "sale"});
    private static ShoppingItem _nullShoppingItem = new ShoppingItemImpl(){

        @Override
        public Object clone() {
            return this;
        }

        @Override
        public CacheModel<ShoppingItem> toCacheModel() {
            return _nullShoppingItemCacheModel;
        }
    };
    private static CacheModel<ShoppingItem> _nullShoppingItemCacheModel = new CacheModel<ShoppingItem>(){

        public ShoppingItem toEntityModel() {
            return _nullShoppingItem;
        }
    };

    public ShoppingItem findBySmallImageId(long smallImageId) throws NoSuchItemException, SystemException {
        ShoppingItem shoppingItem = this.fetchBySmallImageId(smallImageId);
        if (shoppingItem == null) {
            StringBundler msg = new StringBundler(4);
            msg.append(_NO_SUCH_ENTITY_WITH_KEY);
            msg.append("smallImageId=");
            msg.append(smallImageId);
            msg.append("}");
            if (_log.isWarnEnabled()) {
                _log.warn((Object)msg.toString());
            }
            throw new NoSuchItemException(msg.toString());
        }
        return shoppingItem;
    }

    public ShoppingItem fetchBySmallImageId(long smallImageId) throws SystemException {
        return this.fetchBySmallImageId(smallImageId, true);
    }

    public ShoppingItem fetchBySmallImageId(long smallImageId, boolean retrieveFromCache) throws SystemException {
        ShoppingItem shoppingItem;
        Object[] finderArgs = new Object[]{smallImageId};
        Object result = null;
        if (retrieveFromCache) {
            result = FinderCacheUtil.getResult((FinderPath)FINDER_PATH_FETCH_BY_SMALLIMAGEID, (Object[])finderArgs, (SessionFactory)this);
        }
        if (result instanceof ShoppingItem && smallImageId != (shoppingItem = (ShoppingItem)result).getSmallImageId()) {
            result = null;
        }
        if (result == null) {
            StringBundler query = new StringBundler(3);
            query.append(_SQL_SELECT_SHOPPINGITEM_WHERE);
            query.append(_FINDER_COLUMN_SMALLIMAGEID_SMALLIMAGEID_2);
            String sql = query.toString();
            Session session = null;
            try {
                try {
                    session = this.openSession();
                    Query q = session.createQuery(sql);
                    QueryPos qPos = QueryPos.getInstance((Query)q);
                    qPos.add(smallImageId);
                    List list = q.list();
                    if (list.isEmpty()) {
                        FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FETCH_BY_SMALLIMAGEID, (Object[])finderArgs, (Object)list);
                    } else {
                        if (list.size() > 1 && _log.isWarnEnabled()) {
                            _log.warn((Object)("ShoppingItemPersistenceImpl.fetchBySmallImageId(long, boolean) with parameters (" + StringUtil.merge((Object[])finderArgs) + ") yields a result set with more than 1 result. This violates the logical unique restriction. There is no order guarantee on which result is returned by this finder."));
                        }
                        ShoppingItem shoppingItem2 = (ShoppingItem)list.get(0);
                        result = shoppingItem2;
                        this.cacheResult(shoppingItem2);
                        if (shoppingItem2.getSmallImageId() != smallImageId) {
                            FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FETCH_BY_SMALLIMAGEID, (Object[])finderArgs, (Object)shoppingItem2);
                        }
                    }
                }
                catch (Exception e2) {
                    FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_FETCH_BY_SMALLIMAGEID, (Object[])finderArgs);
                    throw this.processException(e2);
                }
            }
            finally {
                this.closeSession(session);
            }
        }
        if (result instanceof List) {
            return null;
        }
        return (ShoppingItem)result;
    }

    public ShoppingItem removeBySmallImageId(long smallImageId) throws NoSuchItemException, SystemException {
        ShoppingItem shoppingItem = this.findBySmallImageId(smallImageId);
        return (ShoppingItem)this.remove((BaseModel)shoppingItem);
    }

    public int countBySmallImageId(long smallImageId) throws SystemException {
        FinderPath finderPath = FINDER_PATH_COUNT_BY_SMALLIMAGEID;
        Object[] finderArgs = new Object[]{smallImageId};
        Long count = (Long)FinderCacheUtil.getResult((FinderPath)finderPath, (Object[])finderArgs, (SessionFactory)this);
        if (count == null) {
            StringBundler query = new StringBundler(2);
            query.append(_SQL_COUNT_SHOPPINGITEM_WHERE);
            query.append(_FINDER_COLUMN_SMALLIMAGEID_SMALLIMAGEID_2);
            String sql = query.toString();
            Session session = null;
            try {
                try {
                    session = this.openSession();
                    Query q = session.createQuery(sql);
                    QueryPos qPos = QueryPos.getInstance((Query)q);
                    qPos.add(smallImageId);
                    count = (Long)q.uniqueResult();
                    FinderCacheUtil.putResult((FinderPath)finderPath, (Object[])finderArgs, (Object)count);
                }
                catch (Exception e2) {
                    FinderCacheUtil.removeResult((FinderPath)finderPath, (Object[])finderArgs);
                    throw this.processException(e2);
                }
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public ShoppingItem findByMediumImageId(long mediumImageId) throws NoSuchItemException, SystemException {
        ShoppingItem shoppingItem = this.fetchByMediumImageId(mediumImageId);
        if (shoppingItem == null) {
            StringBundler msg = new StringBundler(4);
            msg.append(_NO_SUCH_ENTITY_WITH_KEY);
            msg.append("mediumImageId=");
            msg.append(mediumImageId);
            msg.append("}");
            if (_log.isWarnEnabled()) {
                _log.warn((Object)msg.toString());
            }
            throw new NoSuchItemException(msg.toString());
        }
        return shoppingItem;
    }

    public ShoppingItem fetchByMediumImageId(long mediumImageId) throws SystemException {
        return this.fetchByMediumImageId(mediumImageId, true);
    }

    public ShoppingItem fetchByMediumImageId(long mediumImageId, boolean retrieveFromCache) throws SystemException {
        ShoppingItem shoppingItem;
        Object[] finderArgs = new Object[]{mediumImageId};
        Object result = null;
        if (retrieveFromCache) {
            result = FinderCacheUtil.getResult((FinderPath)FINDER_PATH_FETCH_BY_MEDIUMIMAGEID, (Object[])finderArgs, (SessionFactory)this);
        }
        if (result instanceof ShoppingItem && mediumImageId != (shoppingItem = (ShoppingItem)result).getMediumImageId()) {
            result = null;
        }
        if (result == null) {
            StringBundler query = new StringBundler(3);
            query.append(_SQL_SELECT_SHOPPINGITEM_WHERE);
            query.append(_FINDER_COLUMN_MEDIUMIMAGEID_MEDIUMIMAGEID_2);
            String sql = query.toString();
            Session session = null;
            try {
                try {
                    session = this.openSession();
                    Query q = session.createQuery(sql);
                    QueryPos qPos = QueryPos.getInstance((Query)q);
                    qPos.add(mediumImageId);
                    List list = q.list();
                    if (list.isEmpty()) {
                        FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FETCH_BY_MEDIUMIMAGEID, (Object[])finderArgs, (Object)list);
                    } else {
                        if (list.size() > 1 && _log.isWarnEnabled()) {
                            _log.warn((Object)("ShoppingItemPersistenceImpl.fetchByMediumImageId(long, boolean) with parameters (" + StringUtil.merge((Object[])finderArgs) + ") yields a result set with more than 1 result. This violates the logical unique restriction. There is no order guarantee on which result is returned by this finder."));
                        }
                        ShoppingItem shoppingItem2 = (ShoppingItem)list.get(0);
                        result = shoppingItem2;
                        this.cacheResult(shoppingItem2);
                        if (shoppingItem2.getMediumImageId() != mediumImageId) {
                            FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FETCH_BY_MEDIUMIMAGEID, (Object[])finderArgs, (Object)shoppingItem2);
                        }
                    }
                }
                catch (Exception e2) {
                    FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_FETCH_BY_MEDIUMIMAGEID, (Object[])finderArgs);
                    throw this.processException(e2);
                }
            }
            finally {
                this.closeSession(session);
            }
        }
        if (result instanceof List) {
            return null;
        }
        return (ShoppingItem)result;
    }

    public ShoppingItem removeByMediumImageId(long mediumImageId) throws NoSuchItemException, SystemException {
        ShoppingItem shoppingItem = this.findByMediumImageId(mediumImageId);
        return (ShoppingItem)this.remove((BaseModel)shoppingItem);
    }

    public int countByMediumImageId(long mediumImageId) throws SystemException {
        FinderPath finderPath = FINDER_PATH_COUNT_BY_MEDIUMIMAGEID;
        Object[] finderArgs = new Object[]{mediumImageId};
        Long count = (Long)FinderCacheUtil.getResult((FinderPath)finderPath, (Object[])finderArgs, (SessionFactory)this);
        if (count == null) {
            StringBundler query = new StringBundler(2);
            query.append(_SQL_COUNT_SHOPPINGITEM_WHERE);
            query.append(_FINDER_COLUMN_MEDIUMIMAGEID_MEDIUMIMAGEID_2);
            String sql = query.toString();
            Session session = null;
            try {
                try {
                    session = this.openSession();
                    Query q = session.createQuery(sql);
                    QueryPos qPos = QueryPos.getInstance((Query)q);
                    qPos.add(mediumImageId);
                    count = (Long)q.uniqueResult();
                    FinderCacheUtil.putResult((FinderPath)finderPath, (Object[])finderArgs, (Object)count);
                }
                catch (Exception e2) {
                    FinderCacheUtil.removeResult((FinderPath)finderPath, (Object[])finderArgs);
                    throw this.processException(e2);
                }
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public ShoppingItem findByLargeImageId(long largeImageId) throws NoSuchItemException, SystemException {
        ShoppingItem shoppingItem = this.fetchByLargeImageId(largeImageId);
        if (shoppingItem == null) {
            StringBundler msg = new StringBundler(4);
            msg.append(_NO_SUCH_ENTITY_WITH_KEY);
            msg.append("largeImageId=");
            msg.append(largeImageId);
            msg.append("}");
            if (_log.isWarnEnabled()) {
                _log.warn((Object)msg.toString());
            }
            throw new NoSuchItemException(msg.toString());
        }
        return shoppingItem;
    }

    public ShoppingItem fetchByLargeImageId(long largeImageId) throws SystemException {
        return this.fetchByLargeImageId(largeImageId, true);
    }

    public ShoppingItem fetchByLargeImageId(long largeImageId, boolean retrieveFromCache) throws SystemException {
        ShoppingItem shoppingItem;
        Object[] finderArgs = new Object[]{largeImageId};
        Object result = null;
        if (retrieveFromCache) {
            result = FinderCacheUtil.getResult((FinderPath)FINDER_PATH_FETCH_BY_LARGEIMAGEID, (Object[])finderArgs, (SessionFactory)this);
        }
        if (result instanceof ShoppingItem && largeImageId != (shoppingItem = (ShoppingItem)result).getLargeImageId()) {
            result = null;
        }
        if (result == null) {
            StringBundler query = new StringBundler(3);
            query.append(_SQL_SELECT_SHOPPINGITEM_WHERE);
            query.append(_FINDER_COLUMN_LARGEIMAGEID_LARGEIMAGEID_2);
            String sql = query.toString();
            Session session = null;
            try {
                try {
                    session = this.openSession();
                    Query q = session.createQuery(sql);
                    QueryPos qPos = QueryPos.getInstance((Query)q);
                    qPos.add(largeImageId);
                    List list = q.list();
                    if (list.isEmpty()) {
                        FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FETCH_BY_LARGEIMAGEID, (Object[])finderArgs, (Object)list);
                    } else {
                        if (list.size() > 1 && _log.isWarnEnabled()) {
                            _log.warn((Object)("ShoppingItemPersistenceImpl.fetchByLargeImageId(long, boolean) with parameters (" + StringUtil.merge((Object[])finderArgs) + ") yields a result set with more than 1 result. This violates the logical unique restriction. There is no order guarantee on which result is returned by this finder."));
                        }
                        ShoppingItem shoppingItem2 = (ShoppingItem)list.get(0);
                        result = shoppingItem2;
                        this.cacheResult(shoppingItem2);
                        if (shoppingItem2.getLargeImageId() != largeImageId) {
                            FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FETCH_BY_LARGEIMAGEID, (Object[])finderArgs, (Object)shoppingItem2);
                        }
                    }
                }
                catch (Exception e2) {
                    FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_FETCH_BY_LARGEIMAGEID, (Object[])finderArgs);
                    throw this.processException(e2);
                }
            }
            finally {
                this.closeSession(session);
            }
        }
        if (result instanceof List) {
            return null;
        }
        return (ShoppingItem)result;
    }

    public ShoppingItem removeByLargeImageId(long largeImageId) throws NoSuchItemException, SystemException {
        ShoppingItem shoppingItem = this.findByLargeImageId(largeImageId);
        return (ShoppingItem)this.remove((BaseModel)shoppingItem);
    }

    public int countByLargeImageId(long largeImageId) throws SystemException {
        FinderPath finderPath = FINDER_PATH_COUNT_BY_LARGEIMAGEID;
        Object[] finderArgs = new Object[]{largeImageId};
        Long count = (Long)FinderCacheUtil.getResult((FinderPath)finderPath, (Object[])finderArgs, (SessionFactory)this);
        if (count == null) {
            StringBundler query = new StringBundler(2);
            query.append(_SQL_COUNT_SHOPPINGITEM_WHERE);
            query.append(_FINDER_COLUMN_LARGEIMAGEID_LARGEIMAGEID_2);
            String sql = query.toString();
            Session session = null;
            try {
                try {
                    session = this.openSession();
                    Query q = session.createQuery(sql);
                    QueryPos qPos = QueryPos.getInstance((Query)q);
                    qPos.add(largeImageId);
                    count = (Long)q.uniqueResult();
                    FinderCacheUtil.putResult((FinderPath)finderPath, (Object[])finderArgs, (Object)count);
                }
                catch (Exception e2) {
                    FinderCacheUtil.removeResult((FinderPath)finderPath, (Object[])finderArgs);
                    throw this.processException(e2);
                }
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public List<ShoppingItem> findByG_C(long groupId, long categoryId) throws SystemException {
        return this.findByG_C(groupId, categoryId, -1, -1, null);
    }

    public List<ShoppingItem> findByG_C(long groupId, long categoryId, int start, int end) throws SystemException {
        return this.findByG_C(groupId, categoryId, start, end, null);
    }

    public List<ShoppingItem> findByG_C(long groupId, long categoryId, int start, int end, OrderByComparator orderByComparator) throws SystemException {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            pagination = false;
            finderPath = FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_G_C;
            finderArgs = new Object[]{groupId, categoryId};
        } else {
            finderPath = FINDER_PATH_WITH_PAGINATION_FIND_BY_G_C;
            finderArgs = new Object[]{groupId, categoryId, start, end, orderByComparator};
        }
        List list = (List)FinderCacheUtil.getResult((FinderPath)finderPath, (Object[])finderArgs, (SessionFactory)this);
        if (list != null && !list.isEmpty()) {
            for (ShoppingItem shoppingItem : list) {
                if (groupId == shoppingItem.getGroupId() && categoryId == shoppingItem.getCategoryId()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler query = null;
            query = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(4);
            query.append(_SQL_SELECT_SHOPPINGITEM_WHERE);
            query.append(_FINDER_COLUMN_G_C_GROUPID_2);
            query.append(_FINDER_COLUMN_G_C_CATEGORYID_2);
            if (orderByComparator != null) {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else if (pagination) {
                query.append(" ORDER BY shoppingItem.itemId ASC");
            }
            String sql = query.toString();
            Session session = null;
            try {
                try {
                    session = this.openSession();
                    Query q = session.createQuery(sql);
                    QueryPos qPos = QueryPos.getInstance((Query)q);
                    qPos.add(groupId);
                    qPos.add(categoryId);
                    if (!pagination) {
                        list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end, (boolean)false);
                        Collections.sort(list);
                        list = new UnmodifiableList(list);
                    } else {
                        list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
                    }
                    this.cacheResult(list);
                    FinderCacheUtil.putResult((FinderPath)finderPath, (Object[])finderArgs, (Object)list);
                }
                catch (Exception e2) {
                    FinderCacheUtil.removeResult((FinderPath)finderPath, (Object[])finderArgs);
                    throw this.processException(e2);
                }
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public ShoppingItem findByG_C_First(long groupId, long categoryId, OrderByComparator orderByComparator) throws NoSuchItemException, SystemException {
        ShoppingItem shoppingItem = this.fetchByG_C_First(groupId, categoryId, orderByComparator);
        if (shoppingItem != null) {
            return shoppingItem;
        }
        StringBundler msg = new StringBundler(6);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("groupId=");
        msg.append(groupId);
        msg.append(", categoryId=");
        msg.append(categoryId);
        msg.append("}");
        throw new NoSuchItemException(msg.toString());
    }

    public ShoppingItem fetchByG_C_First(long groupId, long categoryId, OrderByComparator orderByComparator) throws SystemException {
        List<ShoppingItem> list = this.findByG_C(groupId, categoryId, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public ShoppingItem findByG_C_Last(long groupId, long categoryId, OrderByComparator orderByComparator) throws NoSuchItemException, SystemException {
        ShoppingItem shoppingItem = this.fetchByG_C_Last(groupId, categoryId, orderByComparator);
        if (shoppingItem != null) {
            return shoppingItem;
        }
        StringBundler msg = new StringBundler(6);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("groupId=");
        msg.append(groupId);
        msg.append(", categoryId=");
        msg.append(categoryId);
        msg.append("}");
        throw new NoSuchItemException(msg.toString());
    }

    public ShoppingItem fetchByG_C_Last(long groupId, long categoryId, OrderByComparator orderByComparator) throws SystemException {
        int count = this.countByG_C(groupId, categoryId);
        if (count == 0) {
            return null;
        }
        List<ShoppingItem> list = this.findByG_C(groupId, categoryId, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public ShoppingItem[] findByG_C_PrevAndNext(long itemId, long groupId, long categoryId, OrderByComparator orderByComparator) throws NoSuchItemException, SystemException {
        ShoppingItem shoppingItem = this.findByPrimaryKey(itemId);
        Session session = null;
        try {
            session = this.openSession();
            ShoppingItem[] array = new ShoppingItemImpl[]{this.getByG_C_PrevAndNext(session, shoppingItem, groupId, categoryId, orderByComparator, true), shoppingItem, this.getByG_C_PrevAndNext(session, shoppingItem, groupId, categoryId, orderByComparator, false)};
            ShoppingItem[] shoppingItemArray = array;
            return shoppingItemArray;
        }
        catch (Exception e2) {
            throw this.processException(e2);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected ShoppingItem getByG_C_PrevAndNext(Session session, ShoppingItem shoppingItem, long groupId, long categoryId, OrderByComparator orderByComparator, boolean previous) {
        List list;
        StringBundler query = null;
        query = orderByComparator != null ? new StringBundler(6 + orderByComparator.getOrderByFields().length * 6) : new StringBundler(3);
        query.append(_SQL_SELECT_SHOPPINGITEM_WHERE);
        query.append(_FINDER_COLUMN_G_C_GROUPID_2);
        query.append(_FINDER_COLUMN_G_C_CATEGORYID_2);
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                query.append(" AND ");
            }
            int i2 = 0;
            while (i2 < orderByConditionFields.length) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByConditionFields[i2]);
                if (i2 + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" >= ? AND ");
                    } else {
                        query.append(" <= ? AND ");
                    }
                } else if (orderByComparator.isAscending() ^ previous) {
                    query.append(" >= ? ");
                } else {
                    query.append(" <= ? ");
                }
                ++i2;
            }
            query.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            int i3 = 0;
            while (i3 < orderByFields.length) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i3]);
                if (i3 + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" ASC, ");
                    } else {
                        query.append(" DESC, ");
                    }
                } else if (orderByComparator.isAscending() ^ previous) {
                    query.append(" ASC");
                } else {
                    query.append(" DESC");
                }
                ++i3;
            }
        } else {
            query.append(" ORDER BY shoppingItem.itemId ASC");
        }
        String sql = query.toString();
        Query q = session.createQuery(sql);
        q.setFirstResult(0);
        q.setMaxResults(2);
        QueryPos qPos = QueryPos.getInstance((Query)q);
        qPos.add(groupId);
        qPos.add(categoryId);
        if (orderByComparator != null) {
            Object[] values;
            Object[] objectArray = values = orderByComparator.getOrderByConditionValues((Object)shoppingItem);
            int n = values.length;
            int n2 = 0;
            while (n2 < n) {
                Object value = objectArray[n2];
                qPos.add(value);
                ++n2;
            }
        }
        if ((list = q.list()).size() == 2) {
            return (ShoppingItem)list.get(1);
        }
        return null;
    }

    public List<ShoppingItem> filterFindByG_C(long groupId, long categoryId) throws SystemException {
        return this.filterFindByG_C(groupId, categoryId, -1, -1, null);
    }

    public List<ShoppingItem> filterFindByG_C(long groupId, long categoryId, int start, int end) throws SystemException {
        return this.filterFindByG_C(groupId, categoryId, start, end, null);
    }

    public List<ShoppingItem> filterFindByG_C(long groupId, long categoryId, int start, int end, OrderByComparator orderByComparator) throws SystemException {
        if (!InlineSQLHelperUtil.isEnabled((long)groupId)) {
            return this.findByG_C(groupId, categoryId, start, end, orderByComparator);
        }
        StringBundler query = null;
        query = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(4);
        if (this.getDB().isSupportsInlineDistinct()) {
            query.append(_FILTER_SQL_SELECT_SHOPPINGITEM_WHERE);
        } else {
            query.append(_FILTER_SQL_SELECT_SHOPPINGITEM_NO_INLINE_DISTINCT_WHERE_1);
        }
        query.append(_FINDER_COLUMN_G_C_GROUPID_2);
        query.append(_FINDER_COLUMN_G_C_CATEGORYID_2);
        if (!this.getDB().isSupportsInlineDistinct()) {
            query.append(_FILTER_SQL_SELECT_SHOPPINGITEM_NO_INLINE_DISTINCT_WHERE_2);
        }
        if (orderByComparator != null) {
            if (this.getDB().isSupportsInlineDistinct()) {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator, true);
            } else {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_TABLE, orderByComparator, true);
            }
        } else if (this.getDB().isSupportsInlineDistinct()) {
            query.append(" ORDER BY shoppingItem.itemId ASC");
        } else {
            query.append(" ORDER BY ShoppingItem.itemId ASC");
        }
        String sql = InlineSQLHelperUtil.replacePermissionCheck((String)query.toString(), (String)ShoppingItem.class.getName(), (String)_FILTER_ENTITY_TABLE_FILTER_PK_COLUMN, (long)groupId);
        Session session = null;
        try {
            session = this.openSession();
            SQLQuery q = session.createSQLQuery(sql);
            if (this.getDB().isSupportsInlineDistinct()) {
                q.addEntity(_FILTER_ENTITY_ALIAS, ShoppingItemImpl.class);
            } else {
                q.addEntity(_FILTER_ENTITY_TABLE, ShoppingItemImpl.class);
            }
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(groupId);
            qPos.add(categoryId);
            List list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
            return list;
        }
        catch (Exception e2) {
            throw this.processException(e2);
        }
        finally {
            this.closeSession(session);
        }
    }

    public ShoppingItem[] filterFindByG_C_PrevAndNext(long itemId, long groupId, long categoryId, OrderByComparator orderByComparator) throws NoSuchItemException, SystemException {
        if (!InlineSQLHelperUtil.isEnabled((long)groupId)) {
            return this.findByG_C_PrevAndNext(itemId, groupId, categoryId, orderByComparator);
        }
        ShoppingItem shoppingItem = this.findByPrimaryKey(itemId);
        Session session = null;
        try {
            session = this.openSession();
            ShoppingItem[] array = new ShoppingItemImpl[]{this.filterGetByG_C_PrevAndNext(session, shoppingItem, groupId, categoryId, orderByComparator, true), shoppingItem, this.filterGetByG_C_PrevAndNext(session, shoppingItem, groupId, categoryId, orderByComparator, false)};
            ShoppingItem[] shoppingItemArray = array;
            return shoppingItemArray;
        }
        catch (Exception e2) {
            throw this.processException(e2);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected ShoppingItem filterGetByG_C_PrevAndNext(Session session, ShoppingItem shoppingItem, long groupId, long categoryId, OrderByComparator orderByComparator, boolean previous) {
        List list;
        StringBundler query = null;
        query = orderByComparator != null ? new StringBundler(6 + orderByComparator.getOrderByFields().length * 6) : new StringBundler(3);
        if (this.getDB().isSupportsInlineDistinct()) {
            query.append(_FILTER_SQL_SELECT_SHOPPINGITEM_WHERE);
        } else {
            query.append(_FILTER_SQL_SELECT_SHOPPINGITEM_NO_INLINE_DISTINCT_WHERE_1);
        }
        query.append(_FINDER_COLUMN_G_C_GROUPID_2);
        query.append(_FINDER_COLUMN_G_C_CATEGORYID_2);
        if (!this.getDB().isSupportsInlineDistinct()) {
            query.append(_FILTER_SQL_SELECT_SHOPPINGITEM_NO_INLINE_DISTINCT_WHERE_2);
        }
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                query.append(" AND ");
            }
            int i2 = 0;
            while (i2 < orderByConditionFields.length) {
                if (this.getDB().isSupportsInlineDistinct()) {
                    query.append(_ORDER_BY_ENTITY_ALIAS);
                } else {
                    query.append(_ORDER_BY_ENTITY_TABLE);
                }
                query.append(orderByConditionFields[i2]);
                if (i2 + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" >= ? AND ");
                    } else {
                        query.append(" <= ? AND ");
                    }
                } else if (orderByComparator.isAscending() ^ previous) {
                    query.append(" >= ? ");
                } else {
                    query.append(" <= ? ");
                }
                ++i2;
            }
            query.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            int i3 = 0;
            while (i3 < orderByFields.length) {
                if (this.getDB().isSupportsInlineDistinct()) {
                    query.append(_ORDER_BY_ENTITY_ALIAS);
                } else {
                    query.append(_ORDER_BY_ENTITY_TABLE);
                }
                query.append(orderByFields[i3]);
                if (i3 + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" ASC, ");
                    } else {
                        query.append(" DESC, ");
                    }
                } else if (orderByComparator.isAscending() ^ previous) {
                    query.append(" ASC");
                } else {
                    query.append(" DESC");
                }
                ++i3;
            }
        } else if (this.getDB().isSupportsInlineDistinct()) {
            query.append(" ORDER BY shoppingItem.itemId ASC");
        } else {
            query.append(" ORDER BY ShoppingItem.itemId ASC");
        }
        String sql = InlineSQLHelperUtil.replacePermissionCheck((String)query.toString(), (String)ShoppingItem.class.getName(), (String)_FILTER_ENTITY_TABLE_FILTER_PK_COLUMN, (long)groupId);
        SQLQuery q = session.createSQLQuery(sql);
        q.setFirstResult(0);
        q.setMaxResults(2);
        if (this.getDB().isSupportsInlineDistinct()) {
            q.addEntity(_FILTER_ENTITY_ALIAS, ShoppingItemImpl.class);
        } else {
            q.addEntity(_FILTER_ENTITY_TABLE, ShoppingItemImpl.class);
        }
        QueryPos qPos = QueryPos.getInstance((Query)q);
        qPos.add(groupId);
        qPos.add(categoryId);
        if (orderByComparator != null) {
            Object[] values;
            Object[] objectArray = values = orderByComparator.getOrderByConditionValues((Object)shoppingItem);
            int n = values.length;
            int n2 = 0;
            while (n2 < n) {
                Object value = objectArray[n2];
                qPos.add(value);
                ++n2;
            }
        }
        if ((list = q.list()).size() == 2) {
            return (ShoppingItem)list.get(1);
        }
        return null;
    }

    public void removeByG_C(long groupId, long categoryId) throws SystemException {
        for (ShoppingItem shoppingItem : this.findByG_C(groupId, categoryId, -1, -1, null)) {
            this.remove((BaseModel)shoppingItem);
        }
    }

    public int countByG_C(long groupId, long categoryId) throws SystemException {
        FinderPath finderPath = FINDER_PATH_COUNT_BY_G_C;
        Object[] finderArgs = new Object[]{groupId, categoryId};
        Long count = (Long)FinderCacheUtil.getResult((FinderPath)finderPath, (Object[])finderArgs, (SessionFactory)this);
        if (count == null) {
            StringBundler query = new StringBundler(3);
            query.append(_SQL_COUNT_SHOPPINGITEM_WHERE);
            query.append(_FINDER_COLUMN_G_C_GROUPID_2);
            query.append(_FINDER_COLUMN_G_C_CATEGORYID_2);
            String sql = query.toString();
            Session session = null;
            try {
                try {
                    session = this.openSession();
                    Query q = session.createQuery(sql);
                    QueryPos qPos = QueryPos.getInstance((Query)q);
                    qPos.add(groupId);
                    qPos.add(categoryId);
                    count = (Long)q.uniqueResult();
                    FinderCacheUtil.putResult((FinderPath)finderPath, (Object[])finderArgs, (Object)count);
                }
                catch (Exception e2) {
                    FinderCacheUtil.removeResult((FinderPath)finderPath, (Object[])finderArgs);
                    throw this.processException(e2);
                }
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public int filterCountByG_C(long groupId, long categoryId) throws SystemException {
        if (!InlineSQLHelperUtil.isEnabled((long)groupId)) {
            return this.countByG_C(groupId, categoryId);
        }
        StringBundler query = new StringBundler(3);
        query.append(_FILTER_SQL_COUNT_SHOPPINGITEM_WHERE);
        query.append(_FINDER_COLUMN_G_C_GROUPID_2);
        query.append(_FINDER_COLUMN_G_C_CATEGORYID_2);
        String sql = InlineSQLHelperUtil.replacePermissionCheck((String)query.toString(), (String)ShoppingItem.class.getName(), (String)_FILTER_ENTITY_TABLE_FILTER_PK_COLUMN, (long)groupId);
        Session session = null;
        try {
            session = this.openSession();
            SQLQuery q = session.createSQLQuery(sql);
            q.addScalar("COUNT_VALUE", Type.LONG);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(groupId);
            qPos.add(categoryId);
            Long count = (Long)q.uniqueResult();
            int n = count.intValue();
            return n;
        }
        catch (Exception e2) {
            throw this.processException(e2);
        }
        finally {
            this.closeSession(session);
        }
    }

    public ShoppingItem findByC_S(long companyId, String sku) throws NoSuchItemException, SystemException {
        ShoppingItem shoppingItem = this.fetchByC_S(companyId, sku);
        if (shoppingItem == null) {
            StringBundler msg = new StringBundler(6);
            msg.append(_NO_SUCH_ENTITY_WITH_KEY);
            msg.append("companyId=");
            msg.append(companyId);
            msg.append(", sku=");
            msg.append(sku);
            msg.append("}");
            if (_log.isWarnEnabled()) {
                _log.warn((Object)msg.toString());
            }
            throw new NoSuchItemException(msg.toString());
        }
        return shoppingItem;
    }

    public ShoppingItem fetchByC_S(long companyId, String sku) throws SystemException {
        return this.fetchByC_S(companyId, sku, true);
    }

    public ShoppingItem fetchByC_S(long companyId, String sku, boolean retrieveFromCache) throws SystemException {
        ShoppingItem shoppingItem;
        Object[] finderArgs = new Object[]{companyId, sku};
        Object result = null;
        if (retrieveFromCache) {
            result = FinderCacheUtil.getResult((FinderPath)FINDER_PATH_FETCH_BY_C_S, (Object[])finderArgs, (SessionFactory)this);
        }
        if (result instanceof ShoppingItem && (companyId != (shoppingItem = (ShoppingItem)result).getCompanyId() || !Validator.equals((Object)sku, (Object)shoppingItem.getSku()))) {
            result = null;
        }
        if (result == null) {
            StringBundler query = new StringBundler(4);
            query.append(_SQL_SELECT_SHOPPINGITEM_WHERE);
            query.append(_FINDER_COLUMN_C_S_COMPANYID_2);
            boolean bindSku = false;
            if (sku == null) {
                query.append(_FINDER_COLUMN_C_S_SKU_1);
            } else if (sku.equals("")) {
                query.append(_FINDER_COLUMN_C_S_SKU_3);
            } else {
                bindSku = true;
                query.append(_FINDER_COLUMN_C_S_SKU_2);
            }
            String sql = query.toString();
            Session session = null;
            try {
                try {
                    List list;
                    session = this.openSession();
                    Query q = session.createQuery(sql);
                    QueryPos qPos = QueryPos.getInstance((Query)q);
                    qPos.add(companyId);
                    if (bindSku) {
                        qPos.add(sku);
                    }
                    if ((list = q.list()).isEmpty()) {
                        FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FETCH_BY_C_S, (Object[])finderArgs, (Object)list);
                    } else {
                        ShoppingItem shoppingItem2 = (ShoppingItem)list.get(0);
                        result = shoppingItem2;
                        this.cacheResult(shoppingItem2);
                        if (shoppingItem2.getCompanyId() != companyId || shoppingItem2.getSku() == null || !shoppingItem2.getSku().equals(sku)) {
                            FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FETCH_BY_C_S, (Object[])finderArgs, (Object)shoppingItem2);
                        }
                    }
                }
                catch (Exception e2) {
                    FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_FETCH_BY_C_S, (Object[])finderArgs);
                    throw this.processException(e2);
                }
            }
            finally {
                this.closeSession(session);
            }
        }
        if (result instanceof List) {
            return null;
        }
        return (ShoppingItem)result;
    }

    public ShoppingItem removeByC_S(long companyId, String sku) throws NoSuchItemException, SystemException {
        ShoppingItem shoppingItem = this.findByC_S(companyId, sku);
        return (ShoppingItem)this.remove((BaseModel)shoppingItem);
    }

    public int countByC_S(long companyId, String sku) throws SystemException {
        FinderPath finderPath = FINDER_PATH_COUNT_BY_C_S;
        Object[] finderArgs = new Object[]{companyId, sku};
        Long count = (Long)FinderCacheUtil.getResult((FinderPath)finderPath, (Object[])finderArgs, (SessionFactory)this);
        if (count == null) {
            StringBundler query = new StringBundler(3);
            query.append(_SQL_COUNT_SHOPPINGITEM_WHERE);
            query.append(_FINDER_COLUMN_C_S_COMPANYID_2);
            boolean bindSku = false;
            if (sku == null) {
                query.append(_FINDER_COLUMN_C_S_SKU_1);
            } else if (sku.equals("")) {
                query.append(_FINDER_COLUMN_C_S_SKU_3);
            } else {
                bindSku = true;
                query.append(_FINDER_COLUMN_C_S_SKU_2);
            }
            String sql = query.toString();
            Session session = null;
            try {
                try {
                    session = this.openSession();
                    Query q = session.createQuery(sql);
                    QueryPos qPos = QueryPos.getInstance((Query)q);
                    qPos.add(companyId);
                    if (bindSku) {
                        qPos.add(sku);
                    }
                    count = (Long)q.uniqueResult();
                    FinderCacheUtil.putResult((FinderPath)finderPath, (Object[])finderArgs, (Object)count);
                }
                catch (Exception e2) {
                    FinderCacheUtil.removeResult((FinderPath)finderPath, (Object[])finderArgs);
                    throw this.processException(e2);
                }
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public ShoppingItemPersistenceImpl() {
        this.setModelClass(ShoppingItem.class);
    }

    public void cacheResult(ShoppingItem shoppingItem) {
        EntityCacheUtil.putResult((boolean)ShoppingItemModelImpl.ENTITY_CACHE_ENABLED, ShoppingItemImpl.class, (Serializable)Long.valueOf(shoppingItem.getPrimaryKey()), (Serializable)shoppingItem);
        FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FETCH_BY_SMALLIMAGEID, (Object[])new Object[]{shoppingItem.getSmallImageId()}, (Object)shoppingItem);
        FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FETCH_BY_MEDIUMIMAGEID, (Object[])new Object[]{shoppingItem.getMediumImageId()}, (Object)shoppingItem);
        FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FETCH_BY_LARGEIMAGEID, (Object[])new Object[]{shoppingItem.getLargeImageId()}, (Object)shoppingItem);
        FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FETCH_BY_C_S, (Object[])new Object[]{shoppingItem.getCompanyId(), shoppingItem.getSku()}, (Object)shoppingItem);
        shoppingItem.resetOriginalValues();
    }

    public void cacheResult(List<ShoppingItem> shoppingItems) {
        for (ShoppingItem shoppingItem : shoppingItems) {
            if (EntityCacheUtil.getResult((boolean)ShoppingItemModelImpl.ENTITY_CACHE_ENABLED, ShoppingItemImpl.class, (Serializable)Long.valueOf(shoppingItem.getPrimaryKey())) == null) {
                this.cacheResult(shoppingItem);
                continue;
            }
            shoppingItem.resetOriginalValues();
        }
    }

    public void clearCache() {
        if (_HIBERNATE_CACHE_USE_SECOND_LEVEL_CACHE) {
            CacheRegistryUtil.clear((String)ShoppingItemImpl.class.getName());
        }
        EntityCacheUtil.clearCache((String)ShoppingItemImpl.class.getName());
        FinderCacheUtil.clearCache((String)FINDER_CLASS_NAME_ENTITY);
        FinderCacheUtil.clearCache((String)FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.clearCache((String)FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }

    public void clearCache(ShoppingItem shoppingItem) {
        EntityCacheUtil.removeResult((boolean)ShoppingItemModelImpl.ENTITY_CACHE_ENABLED, ShoppingItemImpl.class, (Serializable)Long.valueOf(shoppingItem.getPrimaryKey()));
        FinderCacheUtil.clearCache((String)FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.clearCache((String)FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        this.clearUniqueFindersCache(shoppingItem);
    }

    public void clearCache(List<ShoppingItem> shoppingItems) {
        FinderCacheUtil.clearCache((String)FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.clearCache((String)FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        for (ShoppingItem shoppingItem : shoppingItems) {
            EntityCacheUtil.removeResult((boolean)ShoppingItemModelImpl.ENTITY_CACHE_ENABLED, ShoppingItemImpl.class, (Serializable)Long.valueOf(shoppingItem.getPrimaryKey()));
            this.clearUniqueFindersCache(shoppingItem);
        }
    }

    protected void cacheUniqueFindersCache(ShoppingItem shoppingItem) {
        if (shoppingItem.isNew()) {
            Object[] args = new Object[]{shoppingItem.getSmallImageId()};
            FinderCacheUtil.putResult((FinderPath)FINDER_PATH_COUNT_BY_SMALLIMAGEID, (Object[])args, (Object)1L);
            FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FETCH_BY_SMALLIMAGEID, (Object[])args, (Object)shoppingItem);
            args = new Object[]{shoppingItem.getMediumImageId()};
            FinderCacheUtil.putResult((FinderPath)FINDER_PATH_COUNT_BY_MEDIUMIMAGEID, (Object[])args, (Object)1L);
            FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FETCH_BY_MEDIUMIMAGEID, (Object[])args, (Object)shoppingItem);
            args = new Object[]{shoppingItem.getLargeImageId()};
            FinderCacheUtil.putResult((FinderPath)FINDER_PATH_COUNT_BY_LARGEIMAGEID, (Object[])args, (Object)1L);
            FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FETCH_BY_LARGEIMAGEID, (Object[])args, (Object)shoppingItem);
            args = new Object[]{shoppingItem.getCompanyId(), shoppingItem.getSku()};
            FinderCacheUtil.putResult((FinderPath)FINDER_PATH_COUNT_BY_C_S, (Object[])args, (Object)1L);
            FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FETCH_BY_C_S, (Object[])args, (Object)shoppingItem);
        } else {
            Object[] args;
            ShoppingItemModelImpl shoppingItemModelImpl = (ShoppingItemModelImpl)shoppingItem;
            if ((shoppingItemModelImpl.getColumnBitmask() & FINDER_PATH_FETCH_BY_SMALLIMAGEID.getColumnBitmask()) != 0L) {
                args = new Object[]{shoppingItem.getSmallImageId()};
                FinderCacheUtil.putResult((FinderPath)FINDER_PATH_COUNT_BY_SMALLIMAGEID, (Object[])args, (Object)1L);
                FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FETCH_BY_SMALLIMAGEID, (Object[])args, (Object)shoppingItem);
            }
            if ((shoppingItemModelImpl.getColumnBitmask() & FINDER_PATH_FETCH_BY_MEDIUMIMAGEID.getColumnBitmask()) != 0L) {
                args = new Object[]{shoppingItem.getMediumImageId()};
                FinderCacheUtil.putResult((FinderPath)FINDER_PATH_COUNT_BY_MEDIUMIMAGEID, (Object[])args, (Object)1L);
                FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FETCH_BY_MEDIUMIMAGEID, (Object[])args, (Object)shoppingItem);
            }
            if ((shoppingItemModelImpl.getColumnBitmask() & FINDER_PATH_FETCH_BY_LARGEIMAGEID.getColumnBitmask()) != 0L) {
                args = new Object[]{shoppingItem.getLargeImageId()};
                FinderCacheUtil.putResult((FinderPath)FINDER_PATH_COUNT_BY_LARGEIMAGEID, (Object[])args, (Object)1L);
                FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FETCH_BY_LARGEIMAGEID, (Object[])args, (Object)shoppingItem);
            }
            if ((shoppingItemModelImpl.getColumnBitmask() & FINDER_PATH_FETCH_BY_C_S.getColumnBitmask()) != 0L) {
                args = new Object[]{shoppingItem.getCompanyId(), shoppingItem.getSku()};
                FinderCacheUtil.putResult((FinderPath)FINDER_PATH_COUNT_BY_C_S, (Object[])args, (Object)1L);
                FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FETCH_BY_C_S, (Object[])args, (Object)shoppingItem);
            }
        }
    }

    protected void clearUniqueFindersCache(ShoppingItem shoppingItem) {
        ShoppingItemModelImpl shoppingItemModelImpl = (ShoppingItemModelImpl)shoppingItem;
        Object[] args = new Object[]{shoppingItem.getSmallImageId()};
        FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_COUNT_BY_SMALLIMAGEID, (Object[])args);
        FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_FETCH_BY_SMALLIMAGEID, (Object[])args);
        if ((shoppingItemModelImpl.getColumnBitmask() & FINDER_PATH_FETCH_BY_SMALLIMAGEID.getColumnBitmask()) != 0L) {
            args = new Object[]{shoppingItemModelImpl.getOriginalSmallImageId()};
            FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_COUNT_BY_SMALLIMAGEID, (Object[])args);
            FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_FETCH_BY_SMALLIMAGEID, (Object[])args);
        }
        args = new Object[]{shoppingItem.getMediumImageId()};
        FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_COUNT_BY_MEDIUMIMAGEID, (Object[])args);
        FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_FETCH_BY_MEDIUMIMAGEID, (Object[])args);
        if ((shoppingItemModelImpl.getColumnBitmask() & FINDER_PATH_FETCH_BY_MEDIUMIMAGEID.getColumnBitmask()) != 0L) {
            args = new Object[]{shoppingItemModelImpl.getOriginalMediumImageId()};
            FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_COUNT_BY_MEDIUMIMAGEID, (Object[])args);
            FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_FETCH_BY_MEDIUMIMAGEID, (Object[])args);
        }
        args = new Object[]{shoppingItem.getLargeImageId()};
        FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_COUNT_BY_LARGEIMAGEID, (Object[])args);
        FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_FETCH_BY_LARGEIMAGEID, (Object[])args);
        if ((shoppingItemModelImpl.getColumnBitmask() & FINDER_PATH_FETCH_BY_LARGEIMAGEID.getColumnBitmask()) != 0L) {
            args = new Object[]{shoppingItemModelImpl.getOriginalLargeImageId()};
            FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_COUNT_BY_LARGEIMAGEID, (Object[])args);
            FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_FETCH_BY_LARGEIMAGEID, (Object[])args);
        }
        args = new Object[]{shoppingItem.getCompanyId(), shoppingItem.getSku()};
        FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_COUNT_BY_C_S, (Object[])args);
        FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_FETCH_BY_C_S, (Object[])args);
        if ((shoppingItemModelImpl.getColumnBitmask() & FINDER_PATH_FETCH_BY_C_S.getColumnBitmask()) != 0L) {
            args = new Object[]{shoppingItemModelImpl.getOriginalCompanyId(), shoppingItemModelImpl.getOriginalSku()};
            FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_COUNT_BY_C_S, (Object[])args);
            FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_FETCH_BY_C_S, (Object[])args);
        }
    }

    public ShoppingItem create(long itemId) {
        ShoppingItemImpl shoppingItem = new ShoppingItemImpl();
        shoppingItem.setNew(true);
        shoppingItem.setPrimaryKey(itemId);
        return shoppingItem;
    }

    public ShoppingItem remove(long itemId) throws NoSuchItemException, SystemException {
        return this.remove(Long.valueOf(itemId));
    }

    public ShoppingItem remove(Serializable primaryKey) throws NoSuchItemException, SystemException {
        Session session = null;
        try {
            session = this.openSession();
            ShoppingItem shoppingItem = (ShoppingItem)session.get(ShoppingItemImpl.class, primaryKey);
            if (shoppingItem == null) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
                }
                throw new NoSuchItemException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
            }
            ShoppingItem shoppingItem2 = (ShoppingItem)this.remove((BaseModel)shoppingItem);
            return shoppingItem2;
        }
        catch (NoSuchItemException nsee) {
            throw nsee;
        }
        catch (Exception e2) {
            throw this.processException(e2);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected ShoppingItem removeImpl(ShoppingItem shoppingItem) throws SystemException {
        shoppingItem = this.toUnwrappedModel(shoppingItem);
        Session session = null;
        try {
            try {
                session = this.openSession();
                if (!session.contains((Object)shoppingItem)) {
                    shoppingItem = (ShoppingItem)session.get(ShoppingItemImpl.class, shoppingItem.getPrimaryKeyObj());
                }
                if (shoppingItem != null) {
                    session.delete((Object)shoppingItem);
                }
            }
            catch (Exception e2) {
                throw this.processException(e2);
            }
        }
        finally {
            this.closeSession(session);
        }
        if (shoppingItem != null) {
            this.clearCache(shoppingItem);
        }
        return shoppingItem;
    }

    public ShoppingItem updateImpl(ShoppingItem shoppingItem) throws SystemException {
        shoppingItem = this.toUnwrappedModel(shoppingItem);
        boolean isNew = shoppingItem.isNew();
        ShoppingItemModelImpl shoppingItemModelImpl = (ShoppingItemModelImpl)shoppingItem;
        Session session = null;
        try {
            try {
                session = this.openSession();
                if (shoppingItem.isNew()) {
                    session.save((Object)shoppingItem);
                    shoppingItem.setNew(false);
                } else {
                    session.merge((Object)shoppingItem);
                }
            }
            catch (Exception e2) {
                throw this.processException(e2);
            }
        }
        finally {
            this.closeSession(session);
        }
        FinderCacheUtil.clearCache((String)FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        if (isNew || !ShoppingItemModelImpl.COLUMN_BITMASK_ENABLED) {
            FinderCacheUtil.clearCache((String)FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        } else if ((shoppingItemModelImpl.getColumnBitmask() & FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_G_C.getColumnBitmask()) != 0L) {
            Object[] args = new Object[]{shoppingItemModelImpl.getOriginalGroupId(), shoppingItemModelImpl.getOriginalCategoryId()};
            FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_COUNT_BY_G_C, (Object[])args);
            FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_G_C, (Object[])args);
            args = new Object[]{shoppingItemModelImpl.getGroupId(), shoppingItemModelImpl.getCategoryId()};
            FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_COUNT_BY_G_C, (Object[])args);
            FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_G_C, (Object[])args);
        }
        EntityCacheUtil.putResult((boolean)ShoppingItemModelImpl.ENTITY_CACHE_ENABLED, ShoppingItemImpl.class, (Serializable)Long.valueOf(shoppingItem.getPrimaryKey()), (Serializable)shoppingItem);
        this.clearUniqueFindersCache(shoppingItem);
        this.cacheUniqueFindersCache(shoppingItem);
        return shoppingItem;
    }

    protected ShoppingItem toUnwrappedModel(ShoppingItem shoppingItem) {
        if (shoppingItem instanceof ShoppingItemImpl) {
            return shoppingItem;
        }
        ShoppingItemImpl shoppingItemImpl = new ShoppingItemImpl();
        shoppingItemImpl.setNew(shoppingItem.isNew());
        shoppingItemImpl.setPrimaryKey(shoppingItem.getPrimaryKey());
        shoppingItemImpl.setItemId(shoppingItem.getItemId());
        shoppingItemImpl.setGroupId(shoppingItem.getGroupId());
        shoppingItemImpl.setCompanyId(shoppingItem.getCompanyId());
        shoppingItemImpl.setUserId(shoppingItem.getUserId());
        shoppingItemImpl.setUserName(shoppingItem.getUserName());
        shoppingItemImpl.setCreateDate(shoppingItem.getCreateDate());
        shoppingItemImpl.setModifiedDate(shoppingItem.getModifiedDate());
        shoppingItemImpl.setCategoryId(shoppingItem.getCategoryId());
        shoppingItemImpl.setSku(shoppingItem.getSku());
        shoppingItemImpl.setName(shoppingItem.getName());
        shoppingItemImpl.setDescription(shoppingItem.getDescription());
        shoppingItemImpl.setProperties(shoppingItem.getProperties());
        shoppingItemImpl.setFields(shoppingItem.isFields());
        shoppingItemImpl.setFieldsQuantities(shoppingItem.getFieldsQuantities());
        shoppingItemImpl.setMinQuantity(shoppingItem.getMinQuantity());
        shoppingItemImpl.setMaxQuantity(shoppingItem.getMaxQuantity());
        shoppingItemImpl.setPrice(shoppingItem.getPrice());
        shoppingItemImpl.setDiscount(shoppingItem.getDiscount());
        shoppingItemImpl.setTaxable(shoppingItem.isTaxable());
        shoppingItemImpl.setShipping(shoppingItem.getShipping());
        shoppingItemImpl.setUseShippingFormula(shoppingItem.isUseShippingFormula());
        shoppingItemImpl.setRequiresShipping(shoppingItem.isRequiresShipping());
        shoppingItemImpl.setStockQuantity(shoppingItem.getStockQuantity());
        shoppingItemImpl.setFeatured(shoppingItem.isFeatured());
        shoppingItemImpl.setSale(shoppingItem.isSale());
        shoppingItemImpl.setSmallImage(shoppingItem.isSmallImage());
        shoppingItemImpl.setSmallImageId(shoppingItem.getSmallImageId());
        shoppingItemImpl.setSmallImageURL(shoppingItem.getSmallImageURL());
        shoppingItemImpl.setMediumImage(shoppingItem.isMediumImage());
        shoppingItemImpl.setMediumImageId(shoppingItem.getMediumImageId());
        shoppingItemImpl.setMediumImageURL(shoppingItem.getMediumImageURL());
        shoppingItemImpl.setLargeImage(shoppingItem.isLargeImage());
        shoppingItemImpl.setLargeImageId(shoppingItem.getLargeImageId());
        shoppingItemImpl.setLargeImageURL(shoppingItem.getLargeImageURL());
        return shoppingItemImpl;
    }

    public ShoppingItem findByPrimaryKey(Serializable primaryKey) throws NoSuchItemException, SystemException {
        ShoppingItem shoppingItem = this.fetchByPrimaryKey(primaryKey);
        if (shoppingItem == null) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
            }
            throw new NoSuchItemException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
        }
        return shoppingItem;
    }

    public ShoppingItem findByPrimaryKey(long itemId) throws NoSuchItemException, SystemException {
        return this.findByPrimaryKey(Long.valueOf(itemId));
    }

    public ShoppingItem fetchByPrimaryKey(Serializable primaryKey) throws SystemException {
        ShoppingItem shoppingItem = (ShoppingItem)EntityCacheUtil.getResult((boolean)ShoppingItemModelImpl.ENTITY_CACHE_ENABLED, ShoppingItemImpl.class, (Serializable)primaryKey);
        if (shoppingItem == _nullShoppingItem) {
            return null;
        }
        if (shoppingItem == null) {
            Session session = null;
            try {
                try {
                    session = this.openSession();
                    shoppingItem = (ShoppingItem)session.get(ShoppingItemImpl.class, primaryKey);
                    if (shoppingItem != null) {
                        this.cacheResult(shoppingItem);
                    } else {
                        EntityCacheUtil.putResult((boolean)ShoppingItemModelImpl.ENTITY_CACHE_ENABLED, ShoppingItemImpl.class, (Serializable)primaryKey, (Serializable)_nullShoppingItem);
                    }
                }
                catch (Exception e2) {
                    EntityCacheUtil.removeResult((boolean)ShoppingItemModelImpl.ENTITY_CACHE_ENABLED, ShoppingItemImpl.class, (Serializable)primaryKey);
                    throw this.processException(e2);
                }
            }
            finally {
                this.closeSession(session);
            }
        }
        return shoppingItem;
    }

    public ShoppingItem fetchByPrimaryKey(long itemId) throws SystemException {
        return this.fetchByPrimaryKey(Long.valueOf(itemId));
    }

    public List<ShoppingItem> findAll() throws SystemException {
        return this.findAll(-1, -1, null);
    }

    public List<ShoppingItem> findAll(int start, int end) throws SystemException {
        return this.findAll(start, end, null);
    }

    public List<ShoppingItem> findAll(int start, int end, OrderByComparator orderByComparator) throws SystemException {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            pagination = false;
            finderPath = FINDER_PATH_WITHOUT_PAGINATION_FIND_ALL;
            finderArgs = FINDER_ARGS_EMPTY;
        } else {
            finderPath = FINDER_PATH_WITH_PAGINATION_FIND_ALL;
            finderArgs = new Object[]{start, end, orderByComparator};
        }
        List list = (List)FinderCacheUtil.getResult((FinderPath)finderPath, (Object[])finderArgs, (SessionFactory)this);
        if (list == null) {
            StringBundler query = null;
            String sql = null;
            if (orderByComparator != null) {
                query = new StringBundler(2 + orderByComparator.getOrderByFields().length * 3);
                query.append(_SQL_SELECT_SHOPPINGITEM);
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
                sql = query.toString();
            } else {
                sql = _SQL_SELECT_SHOPPINGITEM;
                if (pagination) {
                    sql = sql.concat(" ORDER BY shoppingItem.itemId ASC");
                }
            }
            Session session = null;
            try {
                try {
                    session = this.openSession();
                    Query q = session.createQuery(sql);
                    if (!pagination) {
                        list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end, (boolean)false);
                        Collections.sort(list);
                        list = new UnmodifiableList(list);
                    } else {
                        list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
                    }
                    this.cacheResult(list);
                    FinderCacheUtil.putResult((FinderPath)finderPath, (Object[])finderArgs, (Object)list);
                }
                catch (Exception e2) {
                    FinderCacheUtil.removeResult((FinderPath)finderPath, (Object[])finderArgs);
                    throw this.processException(e2);
                }
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public void removeAll() throws SystemException {
        for (ShoppingItem shoppingItem : this.findAll()) {
            this.remove((BaseModel)shoppingItem);
        }
    }

    public int countAll() throws SystemException {
        Long count = (Long)FinderCacheUtil.getResult((FinderPath)FINDER_PATH_COUNT_ALL, (Object[])FINDER_ARGS_EMPTY, (SessionFactory)this);
        if (count == null) {
            Session session = null;
            try {
                try {
                    session = this.openSession();
                    Query q = session.createQuery(_SQL_COUNT_SHOPPINGITEM);
                    count = (Long)q.uniqueResult();
                    FinderCacheUtil.putResult((FinderPath)FINDER_PATH_COUNT_ALL, (Object[])FINDER_ARGS_EMPTY, (Object)count);
                }
                catch (Exception e2) {
                    FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_COUNT_ALL, (Object[])FINDER_ARGS_EMPTY);
                    throw this.processException(e2);
                }
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    protected Set<String> getBadColumnNames() {
        return _badColumnNames;
    }

    public void afterPropertiesSet() {
        String[] listenerClassNames = StringUtil.split((String)GetterUtil.getString((String)PropsUtil.get("value.object.listener.com.liferay.portlet.shopping.model.ShoppingItem")));
        if (listenerClassNames.length > 0) {
            try {
                ArrayList<ModelListener> listenersList = new ArrayList<ModelListener>();
                String[] stringArray = listenerClassNames;
                int n = listenerClassNames.length;
                int n2 = 0;
                while (n2 < n) {
                    String listenerClassName = stringArray[n2];
                    listenersList.add((ModelListener)InstanceFactory.newInstance((ClassLoader)this.getClassLoader(), (String)listenerClassName));
                    ++n2;
                }
                this.listeners = listenersList.toArray(new ModelListener[listenersList.size()]);
            }
            catch (Exception e2) {
                _log.error((Throwable)e2);
            }
        }
    }

    public void destroy() {
        EntityCacheUtil.removeCache((String)ShoppingItemImpl.class.getName());
        FinderCacheUtil.removeCache((String)FINDER_CLASS_NAME_ENTITY);
        FinderCacheUtil.removeCache((String)FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.removeCache((String)FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }
}

