/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.blobstorage.service.operation;

import org.bson.types.ObjectId;
import org.gcube.contentmanagement.blobstorage.resource.MyFile;
import org.gcube.contentmanagement.blobstorage.service.operation.GetSize;
import org.gcube.contentmanagement.blobstorage.service.operation.Monitor;
import org.gcube.contentmanagement.blobstorage.service.operation.Operation;
import org.gcube.contentmanagement.blobstorage.transport.TransportManager;
import org.gcube.contentmanagement.blobstorage.transport.TransportManagerFactory;
import org.gcube.contentmanagement.blobstorage.transport.backend.RemoteBackendException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetRemotePath
extends Operation {
    final Logger logger = LoggerFactory.getLogger(GetSize.class);
    public String file_separator = "/";
    private String rootPath;

    public GetRemotePath(String[] server, String user, String pwd, String bucket, Monitor monitor, boolean isChunk, String backendType, String[] dbs) {
        super(server, user, pwd, bucket, monitor, isChunk, backendType, dbs);
    }

    @Override
    public String doIt(MyFile myFile) throws RemoteBackendException {
        TransportManagerFactory tmf = new TransportManagerFactory(this.server, this.user, this.password);
        TransportManager tm = tmf.getTransport(this.backendType, myFile.getGcubeMemoryType(), this.dbNames, myFile.getWriteConcern(), myFile.getReadPreference());
        String path = null;
        try {
            path = tm.getRemotePath(this.bucket);
        }
        catch (Exception e) {
            tm.close();
            throw new RemoteBackendException(" Error in GetSize operation ", e.getCause());
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" PATH " + this.bucket);
        }
        this.logger.debug("\t path " + path + "\n\t rootPath: " + this.rootPath);
        int rootLength = this.rootPath.length();
        if (path.length() >= rootLength) {
            path = path.substring(rootLength - 1);
            System.out.println("new relative path " + path);
            return path;
        }
        throw new RuntimeException("expected rootPath or expected relative path are malformed: rootPath: " + this.rootPath + " relativePath: " + path);
    }

    @Override
    public String initOperation(MyFile file, String remotePath, String author, String[] server, String rootArea, boolean replaceOption) {
        boolean isId;
        this.rootPath = file.getRootPath();
        this.logger.trace("rootArea is " + file.getRootPath() + " absoluteremotepath is " + file.getAbsoluteRemotePath());
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("remotePath: " + remotePath);
        }
        if (!(isId = ObjectId.isValid((String)remotePath))) {
            throw new RuntimeException("the getRemotePath method have an invalid id" + remotePath);
        }
        this.bucket = remotePath;
        return this.bucket;
    }

    @Override
    public String initOperation(MyFile resource, String RemotePath, String author, String[] server, String rootArea) {
        throw new IllegalArgumentException("Input/Output stream is not compatible with getSize operation");
    }
}

