/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.CompositeImage;
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.measure.Calibration;
import ij.plugin.HyperStackReducer;
import ij.plugin.PlugIn;
import ij.process.ColorProcessor;
import java.util.Vector;

public class ChannelSplitter
implements PlugIn {
    public void run(String arg) {
        ImagePlus imp = IJ.getImage();
        if (imp.isComposite()) {
            ImagePlus[] channels = ChannelSplitter.split(imp);
            for (int i = 0; i < channels.length; ++i) {
                channels[i].show();
            }
            imp.changes = false;
            imp.close();
        } else if (imp.getType() == 4) {
            this.splitRGB(imp);
        } else {
            IJ.error("Split Channels", "Multichannel image required");
        }
    }

    private void splitRGB(ImagePlus imp) {
        boolean keepSource = IJ.altKeyDown();
        String title = imp.getTitle();
        Calibration cal = imp.getCalibration();
        ImageStack[] channels = ChannelSplitter.splitRGB(imp.getStack(), keepSource);
        if (!keepSource) {
            imp.unlock();
            imp.changes = false;
            imp.close();
        }
        ImagePlus rImp = new ImagePlus(title + " (red)", channels[0]);
        rImp.setCalibration(cal);
        rImp.show();
        if (IJ.isMacOSX()) {
            IJ.wait(500);
        }
        ImagePlus gImp = new ImagePlus(title + " (green)", channels[1]);
        gImp.setCalibration(cal);
        gImp.show();
        if (IJ.isMacOSX()) {
            IJ.wait(500);
        }
        ImagePlus bImp = new ImagePlus(title + " (blue)", channels[2]);
        bImp.setCalibration(cal);
        bImp.show();
    }

    public static ImagePlus[] split(ImagePlus imp) {
        if (imp.getType() == 4) {
            return null;
        }
        int width = imp.getWidth();
        int height = imp.getHeight();
        int channels = imp.getNChannels();
        int slices = imp.getNSlices();
        int frames = imp.getNFrames();
        int bitDepth = imp.getBitDepth();
        int size = slices * frames;
        Vector<ImagePlus> images = new Vector<ImagePlus>();
        HyperStackReducer reducer = new HyperStackReducer(imp);
        for (int c = 1; c <= channels; ++c) {
            ImageStack stack2 = new ImageStack(width, height, size);
            stack2.setPixels(imp.getProcessor().getPixels(), 1);
            ImagePlus imp2 = new ImagePlus("C" + c + "-" + imp.getTitle(), stack2);
            stack2.setPixels(null, 1);
            imp.setPosition(c, 1, 1);
            imp2.setDimensions(1, slices, frames);
            imp2.setCalibration(imp.getCalibration());
            reducer.reduce(imp2);
            if (imp.isComposite() && ((CompositeImage)imp).getMode() == 3) {
                IJ.run(imp2, "Grays", "");
            }
            if (imp2.getNDimensions() > 3) {
                imp2.setOpenAsHyperStack(true);
            }
            images.add(imp2);
        }
        ImagePlus[] array = new ImagePlus[images.size()];
        return images.toArray(array);
    }

    public static ImageStack[] splitRGB(ImageStack rgb, boolean keepSource) {
        int w = rgb.getWidth();
        int h = rgb.getHeight();
        ImageStack[] channels = new ImageStack[3];
        for (int i = 0; i < 3; ++i) {
            channels[i] = new ImageStack(w, h);
        }
        int slice = 1;
        int inc = keepSource ? 1 : 0;
        int n = rgb.getSize();
        for (int i = 1; i <= n; ++i) {
            IJ.showStatus(i + "/" + n);
            byte[] r = new byte[w * h];
            byte[] g = new byte[w * h];
            byte[] b = new byte[w * h];
            ColorProcessor cp = (ColorProcessor)rgb.getProcessor(slice);
            slice += inc;
            cp.getRGB(r, g, b);
            if (!keepSource) {
                rgb.deleteSlice(1);
            }
            channels[0].addSlice(null, r);
            channels[1].addSlice(null, g);
            channels[2].addSlice(null, b);
            IJ.showProgress((double)i / (double)n);
        }
        return channels;
    }
}

