/*
 * Decompiled with CFR 0.152.
 */
package ij.process;

import ij.measure.Calibration;
import ij.process.ImageProcessor;
import ij.process.ImageStatistics;

public class FloatStatistics
extends ImageStatistics {
    public FloatStatistics(ImageProcessor ip) {
        this(ip, 27, null);
    }

    public FloatStatistics(ImageProcessor ip, int mOptions, Calibration cal) {
        double maxThreshold;
        double minThreshold;
        this.width = ip.getWidth();
        this.height = ip.getHeight();
        this.setup(ip, cal);
        double minT = ip.getMinThreshold();
        if ((mOptions & 0x100) == 0 || minT == -808080.0) {
            minThreshold = -3.4028234663852886E38;
            maxThreshold = 3.4028234663852886E38;
        } else {
            minThreshold = minT;
            maxThreshold = ip.getMaxThreshold();
        }
        this.getStatistics(ip, minThreshold, maxThreshold);
        if ((mOptions & 8) != 0) {
            this.getMode();
        }
        if ((mOptions & 0x800) != 0 || (mOptions & 0x2000) != 0) {
            this.fitEllipse(ip, mOptions);
        } else if ((mOptions & 0x20) != 0) {
            this.getCentroid(ip, minThreshold, maxThreshold);
        }
        if ((mOptions & 0x60040) != 0) {
            this.calculateMoments(ip, minThreshold, maxThreshold);
        }
        if ((mOptions & 0x10000) != 0) {
            if (Double.isInfinite(this.binSize) || Double.isNaN(this.binSize)) {
                this.median = 0.0;
            } else {
                this.calculateMedian(this.histogram, 0, this.histogram.length - 1, null);
                this.median = this.histMin + this.median * this.binSize;
                if (this.binSize != 1.0) {
                    this.median += this.binSize / 2.0;
                }
            }
        }
        if ((mOptions & 0x80000) != 0) {
            this.calculateAreaFraction(ip);
        }
    }

    void getStatistics(ImageProcessor ip, double minThreshold, double maxThreshold) {
        double v;
        float[] pixels = (float[])ip.getPixels();
        this.nBins = ip.getHistogramSize();
        this.histMin = ip.getHistogramMin();
        this.histMax = ip.getHistogramMax();
        this.histogram = new int[this.nBins];
        double sum = 0.0;
        double sum2 = 0.0;
        byte[] mask = ip.getMaskArray();
        double roiMin = Double.MAX_VALUE;
        double roiMax = -1.7976931348623157E308;
        double roiMin2 = Double.MAX_VALUE;
        double roiMax2 = -1.7976931348623157E308;
        int y = this.ry;
        int my = 0;
        while (y < this.ry + this.rh) {
            int i = y * this.width + this.rx;
            int mi = my * this.rw;
            for (int x = this.rx; x < this.rx + this.rw; ++x) {
                if ((mask == null || mask[mi++] != 0) && (v = (double)pixels[i]) >= minThreshold && v <= maxThreshold) {
                    if (v < roiMin) {
                        roiMin = v;
                    }
                    if (v > roiMax) {
                        roiMax = v;
                    }
                }
                ++i;
            }
            ++y;
            ++my;
        }
        this.min = roiMin;
        this.max = roiMax;
        if (this.histMin == 0.0 && this.histMax == 0.0) {
            this.histMin = this.min;
            this.histMax = this.max;
        } else {
            if (this.min < this.histMin) {
                this.min = this.histMin;
            }
            if (this.max > this.histMax) {
                this.max = this.histMax;
            }
        }
        this.binSize = (this.histMax - this.histMin) / (double)this.nBins;
        double scale = (double)this.nBins / (this.histMax - this.histMin);
        this.pixelCount = 0;
        int y2 = this.ry;
        int my2 = 0;
        while (y2 < this.ry + this.rh) {
            int i = y2 * this.width + this.rx;
            int mi = my2 * this.rw;
            for (int x = this.rx; x < this.rx + this.rw; ++x) {
                if ((mask == null || mask[mi++] != 0) && (v = (double)pixels[i]) >= minThreshold && v <= maxThreshold && v >= this.histMin && v <= this.histMax) {
                    ++this.pixelCount;
                    sum += v;
                    sum2 += v * v;
                    int index = (int)(scale * (v - this.histMin));
                    if (index >= this.nBins) {
                        index = this.nBins - 1;
                    }
                    int n = index;
                    this.histogram[n] = this.histogram[n] + 1;
                }
                ++i;
            }
            ++y2;
            ++my2;
        }
        this.area = (double)this.pixelCount * this.pw * this.ph;
        this.umean = this.mean = sum / (double)this.pixelCount;
        this.calculateStdDev(this.pixelCount, sum, sum2);
    }

    void getMode() {
        this.maxCount = 0;
        for (int i = 0; i < this.nBins; ++i) {
            int count = this.histogram[i];
            if (count <= this.maxCount) continue;
            this.maxCount = count;
            this.mode = i;
        }
        this.dmode = this.histMin + (double)this.mode * this.binSize;
        if (this.binSize != 1.0) {
            this.dmode += this.binSize / 2.0;
        }
    }

    void calculateMoments(ImageProcessor ip, double minThreshold, double maxThreshold) {
        float[] pixels = (float[])ip.getPixels();
        byte[] mask = ip.getMaskArray();
        double sum1 = 0.0;
        double sum2 = 0.0;
        double sum3 = 0.0;
        double sum4 = 0.0;
        double xsum = 0.0;
        double ysum = 0.0;
        int y = this.ry;
        int my = 0;
        while (y < this.ry + this.rh) {
            int i = y * this.width + this.rx;
            int mi = my * this.rw;
            for (int x = this.rx; x < this.rx + this.rw; ++x) {
                double v;
                if ((mask == null || mask[mi++] != 0) && (v = (double)pixels[i] + Double.MIN_VALUE) >= minThreshold && v <= maxThreshold) {
                    double v2 = v * v;
                    sum1 += v;
                    sum2 += v2;
                    sum3 += v * v2;
                    sum4 += v2 * v2;
                    xsum += (double)x * v;
                    ysum += (double)y * v;
                }
                ++i;
            }
            ++y;
            ++my;
        }
        double mean2 = this.mean * this.mean;
        double variance = sum2 / (double)this.pixelCount - mean2;
        double sDeviation = Math.sqrt(variance);
        this.skewness = ((sum3 - 3.0 * this.mean * sum2) / (double)this.pixelCount + 2.0 * this.mean * mean2) / (variance * sDeviation);
        this.kurtosis = ((sum4 - 4.0 * this.mean * sum3 + 6.0 * mean2 * sum2) / (double)this.pixelCount - 3.0 * mean2 * mean2) / (variance * variance) - 3.0;
        this.xCenterOfMass = xsum / sum1 + 0.5;
        this.yCenterOfMass = ysum / sum1 + 0.5;
        if (this.cal != null) {
            this.xCenterOfMass = this.cal.getX(this.xCenterOfMass);
            this.yCenterOfMass = this.cal.getY(this.yCenterOfMass, this.height);
        }
    }

    void getCentroid(ImageProcessor ip, double minThreshold, double maxThreshold) {
        float[] pixels = (float[])ip.getPixels();
        byte[] mask = ip.getMaskArray();
        double count = 0.0;
        double xsum = 0.0;
        double ysum = 0.0;
        int y = this.ry;
        int my = 0;
        while (y < this.ry + this.rh) {
            int i = y * this.width + this.rx;
            int mi = my * this.rw;
            for (int x = this.rx; x < this.rx + this.rw; ++x) {
                double v;
                if ((mask == null || mask[mi++] != 0) && (v = (double)pixels[i]) >= minThreshold && v <= maxThreshold) {
                    count += 1.0;
                    xsum += (double)x;
                    ysum += (double)y;
                }
                ++i;
            }
            ++y;
            ++my;
        }
        this.xCentroid = xsum / count + 0.5;
        this.yCentroid = ysum / count + 0.5;
        if (this.cal != null) {
            this.xCentroid = this.cal.getX(this.xCentroid);
            this.yCentroid = this.cal.getY(this.yCentroid, this.height);
        }
    }

    void calculateAreaFraction(ImageProcessor ip) {
        int sum = 0;
        int total = 0;
        float t1 = (float)ip.getMinThreshold();
        float t2 = (float)ip.getMaxThreshold();
        float[] pixels = (float[])ip.getPixels();
        boolean noThresh = (double)t1 == -808080.0;
        byte[] mask = ip.getMaskArray();
        int y = this.ry;
        int my = 0;
        while (y < this.ry + this.rh) {
            int i = y * this.width + this.rx;
            int mi = my * this.rw;
            for (int x = this.rx; x < this.rx + this.rw; ++x) {
                if (mask == null || mask[mi++] != 0) {
                    float v = pixels[i];
                    ++total;
                    if (noThresh) {
                        if (v != 0.0f) {
                            ++sum;
                        }
                    } else if (v >= t1 && v <= t2) {
                        ++sum;
                    }
                }
                ++i;
            }
            ++y;
            ++my;
        }
        this.areaFraction = (double)sum * 100.0 / (double)total;
    }
}

