/*
 * Decompiled with CFR 0.152.
 */
package org.apache.abdera.security.util;

import java.io.Serializable;
import java.math.BigInteger;
import java.security.AlgorithmParameterGenerator;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.InvalidParameterSpecException;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.KeyAgreement;
import javax.crypto.spec.DHParameterSpec;
import org.apache.abdera.security.Encryption;
import org.apache.abdera.security.EncryptionOptions;
import org.apache.axiom.om.util.Base64;

public class DHContext
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 9145945368596071015L;
    BigInteger p = null;
    BigInteger g = null;
    int l = 0;
    private KeyPair keyPair;
    private Key publicKey;

    public DHContext() {
        try {
            this.init();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public DHContext(String dh) {
        try {
            this.init(dh);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private DHContext(KeyPair keyPair, BigInteger p, BigInteger g, int l) {
        this.keyPair = keyPair;
        this.p = p;
        this.g = g;
        this.l = l;
    }

    public String getRequestString() {
        StringBuilder buf = new StringBuilder();
        buf.append("DH ");
        buf.append("p=");
        buf.append(this.p.toString());
        buf.append(", ");
        buf.append("g=");
        buf.append(this.g.toString());
        buf.append(", ");
        buf.append("k=");
        buf.append(Base64.encode((byte[])this.keyPair.getPublic().getEncoded()));
        return buf.toString();
    }

    public String getResponseString() {
        StringBuilder buf = new StringBuilder();
        buf.append("DH ");
        buf.append("k=");
        buf.append(Base64.encode((byte[])this.keyPair.getPublic().getEncoded()));
        return buf.toString();
    }

    private void init() throws NoSuchAlgorithmException, InvalidAlgorithmParameterException, InvalidParameterSpecException, InvalidKeySpecException {
        AlgorithmParameterGenerator pgen = AlgorithmParameterGenerator.getInstance("DH");
        pgen.init(512);
        AlgorithmParameters params = pgen.generateParameters();
        DHParameterSpec dhspec = params.getParameterSpec(DHParameterSpec.class);
        KeyPairGenerator keypairgen = KeyPairGenerator.getInstance("DH");
        keypairgen.initialize(dhspec);
        this.keyPair = keypairgen.generateKeyPair();
        this.p = dhspec.getP();
        this.g = dhspec.getG();
        this.l = dhspec.getL();
    }

    private void init(String dh) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException, InvalidKeySpecException {
        String[] segments = dh.split("\\s+", 2);
        if (!segments[0].equalsIgnoreCase("DH")) {
            throw new IllegalArgumentException();
        }
        String[] params = segments[1].split("\\s*,\\s*");
        byte[] key = null;
        for (String param : params) {
            String name = param.substring(0, param.indexOf("="));
            String value = param.substring(param.indexOf("=") + 1);
            if (name.equalsIgnoreCase("p")) {
                this.p = new BigInteger(value);
                continue;
            }
            if (name.equalsIgnoreCase("g")) {
                this.g = new BigInteger(value);
                continue;
            }
            if (!name.equalsIgnoreCase("k")) continue;
            key = Base64.decode((String)value);
        }
        this.init(this.p, this.g, this.l, key);
    }

    private void init(BigInteger p, BigInteger g, int l, byte[] key) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException, InvalidKeySpecException {
        DHParameterSpec spec = new DHParameterSpec(p, g, l);
        KeyPairGenerator keypairgen = KeyPairGenerator.getInstance("DH");
        keypairgen.initialize(spec);
        this.keyPair = keypairgen.generateKeyPair();
        this.publicKey = this.decode(key);
    }

    public KeyPair getKeyPair() {
        return this.keyPair;
    }

    public Key getPublicKey() {
        return this.publicKey;
    }

    private Key decode(byte[] key) throws NoSuchAlgorithmException, InvalidKeySpecException {
        X509EncodedKeySpec x509KeySpec = new X509EncodedKeySpec(key);
        KeyFactory keyFact = KeyFactory.getInstance("DH");
        return keyFact.generatePublic(x509KeySpec);
    }

    public DHContext setPublicKey(String dh) throws NoSuchAlgorithmException, InvalidKeySpecException {
        String[] segments = dh.split("\\s+", 2);
        if (!segments[0].equalsIgnoreCase("DH")) {
            throw new IllegalArgumentException();
        }
        String[] tokens = segments[1].split("\\s*,\\s*");
        byte[] key = null;
        for (String token : tokens) {
            String name = token.substring(0, token.indexOf("="));
            String value = token.substring(token.indexOf("=") + 1);
            if (!name.equalsIgnoreCase("k")) continue;
            key = Base64.decode((String)value);
        }
        this.publicKey = this.decode(key);
        return this;
    }

    public Key generateSecret() throws NoSuchAlgorithmException, InvalidKeyException {
        KeyAgreement ka = KeyAgreement.getInstance("DH");
        ka.init(this.keyPair.getPrivate());
        ka.doPhase(this.publicKey, true);
        return ka.generateSecret("DESede");
    }

    public EncryptionOptions getEncryptionOptions(Encryption enc) throws InvalidKeyException, NoSuchAlgorithmException {
        EncryptionOptions options = enc.getDefaultEncryptionOptions();
        options.setDataEncryptionKey(this.generateSecret());
        options.setDataCipherAlgorithm("http://www.w3.org/2001/04/xmlenc#tripledes-cbc");
        return options;
    }

    public Object clone() throws CloneNotSupportedException {
        if (this.publicKey != null) {
            throw new CloneNotSupportedException();
        }
        return new DHContext(this.keyPair, this.p, this.g, this.l);
    }
}

