/*
 * Decompiled with CFR 0.152.
 */
package org.jamwiki.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.jamwiki.DataAccessException;
import org.jamwiki.WikiBase;
import org.jamwiki.WikiException;
import org.jamwiki.model.Topic;
import org.jamwiki.model.TopicType;
import org.jamwiki.model.TopicVersion;
import org.jamwiki.model.WikiUser;
import org.jamwiki.utils.TiddlyWiki2MediaWikiTranslator;
import org.jamwiki.utils.WikiLogger;

public class TiddlyWikiParser {
    private static final WikiLogger logger = WikiLogger.getLogger(TiddlyWikiParser.class.getName());
    private static final String DIV_START = "<div tiddler";
    private static final String DIV_END = "</div>";
    private static final String TIDLLER = "tiddler";
    private static final String MODIFIED = "modified";
    private static final SimpleDateFormat formater = new SimpleDateFormat("yyyyMMddHHmm");
    private StringBuilder messages = new StringBuilder();
    private String virtualWiki;
    private WikiUser user;
    private String authorDisplay;
    private WikiBaseFascade wikiBase = new WikiBaseFascade(){

        @Override
        public void writeTopic(Topic topic, TopicVersion topicVersion, LinkedHashMap categories, List<String> links, Object transactionObject) throws DataAccessException, WikiException {
            WikiBase.getDataHandler().writeTopic(topic, topicVersion, null, null);
        }
    };
    private TiddlyWiki2MediaWikiTranslator translator = new TiddlyWiki2MediaWikiTranslator();

    public TiddlyWikiParser(String virtualWiki, WikiUser user, String authorDisplay) {
        this.virtualWiki = virtualWiki;
        this.user = user;
        this.authorDisplay = authorDisplay;
    }

    public TiddlyWikiParser(String virtualWiki, WikiUser user, String authorDisplay, WikiBaseFascade wikiBase) {
        this(virtualWiki, user, authorDisplay);
        this.wikiBase = wikiBase;
    }

    public String parse(File file) throws DataAccessException, IOException, WikiException {
        FileReader r = new FileReader(file);
        BufferedReader br = new BufferedReader(r);
        return this.parse(br);
    }

    public String parse(BufferedReader br) throws DataAccessException, IOException, WikiException {
        String line = br.readLine();
        boolean inTiddler = false;
        int start = 0;
        int end = 0;
        StringBuilder content = new StringBuilder();
        while (line != null) {
            if (inTiddler) {
                end = line.indexOf(DIV_END);
                if (end != -1) {
                    inTiddler = false;
                    content.append(line.substring(0, end));
                    this.processContent(content.toString());
                    content.setLength(0);
                    line = line.substring(end);
                    continue;
                }
                content.append(line);
                line = br.readLine();
                continue;
            }
            start = line.indexOf(DIV_START);
            if (start != -1 && line.indexOf("<div tiddler=\"%0\"") == -1) {
                inTiddler = true;
                logger.debug("Ignoring:\n" + line.substring(0, start));
                line = line.substring(start);
                continue;
            }
            logger.debug("Div tiddler not found in: \n" + line);
            line = br.readLine();
        }
        return "DefaultTiddlers";
    }

    private void processContent(String content) throws DataAccessException, IOException, WikiException {
        logger.debug("Content: " + content);
        String name = this.findName(content, TIDLLER);
        if (name == null || "%0".equals(this.user)) {
            return;
        }
        Date lastMod = null;
        try {
            lastMod = formater.parse(this.findName(content, MODIFIED));
        }
        catch (Exception e) {
            this.messages.append("WARNING: corrupt line: ").append(content);
        }
        if (lastMod == null) {
            return;
        }
        int idx = content.indexOf(62);
        if (idx == -1) {
            logger.warn("No closing of tag");
            this.messages.append("WARNING: corrupt line: ").append(content);
            return;
        }
        String wikicode = content.substring(idx + 1);
        wikicode = this.translator.translate(wikicode);
        this.messages.append("Adding topic " + name + "\n");
        this.saveTopic(name, lastMod, wikicode);
        logger.debug("Code:" + wikicode);
    }

    private void saveTopic(String name, Date lastMod, String content) throws DataAccessException, WikiException {
        Topic topic = new Topic(this.virtualWiki, name);
        topic.setTopicContent(content);
        int charactersChanged = StringUtils.length((String)content);
        TopicVersion topicVersion = new TopicVersion(this.user, this.authorDisplay, "imported", content, charactersChanged);
        topicVersion.setEditDate(new Timestamp(lastMod.getTime()));
        topic.setTopicType(TopicType.ARTICLE);
        this.wikiBase.writeTopic(topic, topicVersion, null, null, null);
    }

    private String findName(String content, String name) {
        int startIdx = content.indexOf(name);
        if (startIdx == -1) {
            logger.warn("no tiddler name found");
            return null;
        }
        startIdx = content.indexOf(34, startIdx);
        int endIdx = content.indexOf(34, startIdx + 1);
        String value = content.substring(startIdx + 1, endIdx);
        logger.debug(name + ":" + value);
        return value;
    }

    public String getOutput() {
        return this.messages.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface WikiBaseFascade {
        public void writeTopic(Topic var1, TopicVersion var2, LinkedHashMap var3, List<String> var4, Object var5) throws DataAccessException, WikiException;
    }
}

