/*
 * Decompiled with CFR 0.152.
 */
package org.displaytag.export;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.displaytag.Messages;
import org.displaytag.exception.WrappedRuntimeException;
import org.displaytag.export.ExportView;
import org.displaytag.model.TableModel;
import org.displaytag.properties.MediaTypeEnum;
import org.displaytag.properties.TableProperties;
import org.displaytag.util.ReflectHelper;

public final class ExportViewFactory {
    private static ExportViewFactory instance;
    private static Log log;
    private final Map viewClasses = new HashMap();

    private ExportViewFactory() {
        TableProperties properties = TableProperties.getInstance(null);
        String[] exportTypes = properties.getExportTypes();
        if (log.isInfoEnabled()) {
            log.info((Object)Messages.getString("ExportViewFactory.initializing", new Object[]{ArrayUtils.toString((Object)exportTypes)}));
        }
        for (int j = 0; j < exportTypes.length; ++j) {
            String className = properties.getExportClass(exportTypes[j]);
            this.registerExportView(exportTypes[j], className);
        }
    }

    public static synchronized ExportViewFactory getInstance() {
        if (instance == null) {
            instance = new ExportViewFactory();
        }
        return instance;
    }

    public void registerExportView(String name, String viewClassName) {
        Class exportClass;
        try {
            exportClass = ReflectHelper.classForName(viewClassName);
        }
        catch (ClassNotFoundException e) {
            log.error((Object)Messages.getString("ExportViewFactory.classnotfound", new Object[]{name, viewClassName}));
            return;
        }
        catch (NoClassDefFoundError e) {
            log.warn((Object)Messages.getString("ExportViewFactory.noclassdef", new Object[]{name, viewClassName, e.getMessage()}));
            return;
        }
        try {
            exportClass.newInstance();
        }
        catch (InstantiationException e) {
            log.error((Object)Messages.getString("ExportViewFactory.instantiationexception", new Object[]{name, viewClassName, e.getMessage()}));
            return;
        }
        catch (IllegalAccessException e) {
            log.error((Object)Messages.getString("ExportViewFactory.illegalaccess", new Object[]{name, viewClassName, e.getMessage()}));
            return;
        }
        catch (NoClassDefFoundError e) {
            log.warn((Object)Messages.getString("ExportViewFactory.noclassdef", new Object[]{name, viewClassName, e.getMessage()}));
            return;
        }
        MediaTypeEnum media = MediaTypeEnum.registerMediaType(name);
        this.viewClasses.put(media, exportClass);
        if (log.isDebugEnabled()) {
            log.debug((Object)Messages.getString("ExportViewFactory.added", new Object[]{media, viewClassName}));
        }
    }

    public ExportView getView(MediaTypeEnum exportType, TableModel tableModel, boolean exportFullList, boolean includeHeader, boolean decorateValues) {
        ExportView view;
        Class viewClass = (Class)this.viewClasses.get(exportType);
        try {
            view = (ExportView)viewClass.newInstance();
        }
        catch (InstantiationException e) {
            throw new WrappedRuntimeException(this.getClass(), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new WrappedRuntimeException(this.getClass(), (Throwable)e);
        }
        view.setParameters(tableModel, exportFullList, includeHeader, decorateValues);
        return view;
    }

    static {
        log = LogFactory.getLog((Class)ExportViewFactory.class);
    }
}

