/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.util.spring.transaction;

import com.liferay.portal.kernel.bean.PortalBeanLocatorUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.PortalClassLoaderUtil;
import com.liferay.portal.kernel.util.SimplePojoClp;
import com.liferay.util.spring.transaction.TransactionStatusClp;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionException;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.TransactionSystemException;
import org.springframework.transaction.support.DefaultTransactionDefinition;

public class TransactionManagerClp
implements PlatformTransactionManager {
    private static Log _log = LogFactoryUtil.getLog(TransactionManagerClp.class);
    private SimplePojoClp<TransactionDefinition> _transactionDefinitionClp;
    private Object _transactionManager;
    private Map<String, Method> _transactionManagerMethods;

    public void commit(TransactionStatus transactionStatus) throws TransactionException {
        try {
            Method method = this._transactionManagerMethods.get("commit");
            method.invoke(this._transactionManager, this.unwrapTransactionStatus(transactionStatus));
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new TransactionSystemException(e.getMessage());
        }
    }

    public TransactionStatus getTransaction(TransactionDefinition transactionDefinition) throws TransactionException {
        Object transactionStatus = null;
        try {
            Method method = this._transactionManagerMethods.get("getTransaction");
            transactionStatus = method.invoke(this._transactionManager, this.createRemoteTransactionDefinition(transactionDefinition));
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new TransactionSystemException(e.getMessage());
        }
        return new TransactionStatusClp(transactionStatus);
    }

    @PostConstruct
    public void init() throws ClassNotFoundException {
        this._transactionManager = PortalBeanLocatorUtil.locate((String)"liferayTransactionManager");
        this._transactionDefinitionClp = new SimplePojoClp(DefaultTransactionDefinition.class, PortalClassLoaderUtil.getClassLoader());
        this.initTransactionManagerMethods();
    }

    public void rollback(TransactionStatus transactionStatus) throws TransactionException {
        try {
            Method method = this._transactionManagerMethods.get("rollback");
            method.invoke(this._transactionManager, this.unwrapTransactionStatus(transactionStatus));
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new TransactionSystemException(e.getMessage());
        }
    }

    protected Object createRemoteTransactionDefinition(TransactionDefinition transactionDefinition) throws IllegalAccessException, InstantiationException {
        return this._transactionDefinitionClp.createRemoteObject((Object)transactionDefinition);
    }

    protected void initTransactionManagerMethods() {
        Method[] methods;
        this._transactionManagerMethods = new HashMap<String, Method>();
        Method[] methodArray = methods = this._transactionManager.getClass().getMethods();
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            this._transactionManagerMethods.put(method.getName(), method);
            ++n2;
        }
    }

    protected Object unwrapTransactionStatus(TransactionStatus localTransactionStatus) {
        TransactionStatusClp transactionStatusClp = (TransactionStatusClp)localTransactionStatus;
        return transactionStatusClp.getRemoteTransactionStatus();
    }
}

