/*
 * Decompiled with CFR 0.152.
 */
package JOscarLib;

import JOscarLib.DataField;
import java.util.Vector;

public abstract class DataContainer
extends DataField {
    private Vector dataFieldVector = new Vector(0);
    private byte[] dataFieldByteAray;
    private int dataFieldLen = 0;
    private boolean dataFieldModified = true;
    protected boolean headerModified = true;

    public abstract byte[] getHeaderByteArray();

    public void addDataField(DataField data) {
        this.dataFieldVector.addElement(data);
        this.dataFieldLen += data.getByteArray().length;
        this.dataFieldModified = true;
    }

    protected Object elementAt(int i) {
        return this.dataFieldVector.elementAt(i);
    }

    public byte[] getDataFieldByteArray() {
        if (this.dataFieldModified) {
            int position = 0;
            this.dataFieldByteAray = new byte[this.dataFieldLen];
            for (int i = 0; i < this.dataFieldVector.size(); ++i) {
                DataField obj = (DataField)this.dataFieldVector.elementAt(i);
                System.arraycopy(obj.getByteArray(), 0, this.dataFieldByteAray, position, obj.getByteArray().length);
                position += obj.getByteArray().length;
            }
            this.dataFieldModified = false;
        }
        return this.dataFieldByteAray;
    }

    public byte[] getByteArray() {
        if (this.headerModified || this.dataFieldModified) {
            this.byteArray = new byte[this.getHeaderByteArray().length + this.dataFieldLen];
            System.arraycopy(this.getHeaderByteArray(), 0, this.byteArray, 0, this.getHeaderByteArray().length);
            System.arraycopy(this.getDataFieldByteArray(), 0, this.byteArray, this.getHeaderByteArray().length, this.getDataFieldByteArray().length);
            this.headerModified = false;
        }
        return this.byteArray;
    }
}

