/*
 * Decompiled with CFR 0.152.
 */
package JOscarLib.Setting;

import JOscarLib.Setting.Enum.StatusFlagEnum;
import JOscarLib.Setting.Enum.StatusModeEnum;
import JOscarLib.Setting.Enum.TcpConnectionFlagEnum;
import java.util.TreeMap;

public class Tweaker {
    private static final Integer INITIAL_STATUS_MODE = new Integer(511);
    private static final Integer INITIAL_STATUS_FLAGS = new Integer(767);
    private static final Integer TCP_CONNECTION_FLAG = new Integer(1023);
    private static final Integer P2P_PORT_LISTENING = new Integer(1279);
    private static final Integer REQUEST_FREE_FOR_CHAT_MESSAGE = new Integer(236);
    private static final Integer REQUEST_DND_MESSAGE = new Integer(235);
    private static final Integer REQUEST_OCCUPIED_MESSAGE = new Integer(233);
    private static final Integer REQUEST_NA_MESSAGE = new Integer(234);
    private static final Integer REQUEST_AWAY_MASSEGE = new Integer(232);
    private TreeMap map = new TreeMap();

    public Tweaker() {
        this.map.put(INITIAL_STATUS_MODE, new StatusModeEnum(0));
        this.map.put(INITIAL_STATUS_FLAGS, new StatusFlagEnum(0x20000000, false, false, false));
        this.map.put(TCP_CONNECTION_FLAG, new TcpConnectionFlagEnum(4));
        this.map.put(P2P_PORT_LISTENING, new Integer(5000));
    }

    public StatusFlagEnum getInitialStatusFlags() {
        return (StatusFlagEnum)this.map.get(INITIAL_STATUS_FLAGS);
    }

    public void setInitialStatusFlags(StatusFlagEnum flags) {
        this.map.put(INITIAL_STATUS_FLAGS, flags);
    }

    public StatusModeEnum getInitialStatusMode() {
        return (StatusModeEnum)this.map.get(INITIAL_STATUS_MODE);
    }

    public void setInitialStatusMode(StatusModeEnum mode) {
        this.map.put(INITIAL_STATUS_MODE, mode);
    }

    public TcpConnectionFlagEnum getTcpConnectionFlag() {
        return (TcpConnectionFlagEnum)this.map.get(TCP_CONNECTION_FLAG);
    }

    public void setTcpConnectionFlag(TcpConnectionFlagEnum flag) {
        this.map.put(TCP_CONNECTION_FLAG, flag);
    }

    public int getP2PPortListening() {
        return (Integer)this.map.get(P2P_PORT_LISTENING);
    }

    public void setP2PPortListening(int port) {
        this.map.put(P2P_PORT_LISTENING, new Integer(port));
    }

    public String getRequestMessage(int modeRequest) {
        String stored = (String)this.map.get(new Integer(modeRequest));
        if (stored != null) {
            return "" + stored;
        }
        return "";
    }

    public void setFreeForChatRequestMessage(String message) {
        this.map.put(REQUEST_FREE_FOR_CHAT_MESSAGE, new Integer(message));
    }

    public void setDNDRequestMessage(String message) {
        this.map.put(REQUEST_DND_MESSAGE, new Integer(message));
    }

    public void setOccupiedRequestMessage(String message) {
        this.map.put(REQUEST_OCCUPIED_MESSAGE, new Integer(message));
    }

    public void setNARequestMessage(String message) {
        this.map.put(REQUEST_NA_MESSAGE, new Integer(message));
    }

    public void setAwayRequestMessage(String message) {
        this.map.put(REQUEST_AWAY_MASSEGE, new Integer(message));
    }
}

