/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.thrift;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.netflix.astyanax.AstyanaxConfiguration;
import com.netflix.astyanax.CassandraOperationType;
import com.netflix.astyanax.Cluster;
import com.netflix.astyanax.Keyspace;
import com.netflix.astyanax.KeyspaceTracerFactory;
import com.netflix.astyanax.connectionpool.ConnectionContext;
import com.netflix.astyanax.connectionpool.ConnectionPool;
import com.netflix.astyanax.connectionpool.Operation;
import com.netflix.astyanax.connectionpool.OperationResult;
import com.netflix.astyanax.connectionpool.exceptions.BadRequestException;
import com.netflix.astyanax.connectionpool.exceptions.ConnectionException;
import com.netflix.astyanax.connectionpool.exceptions.NotFoundException;
import com.netflix.astyanax.connectionpool.exceptions.OperationException;
import com.netflix.astyanax.connectionpool.exceptions.SchemaDisagreementException;
import com.netflix.astyanax.ddl.ColumnDefinition;
import com.netflix.astyanax.ddl.ColumnFamilyDefinition;
import com.netflix.astyanax.ddl.KeyspaceDefinition;
import com.netflix.astyanax.ddl.SchemaChangeResult;
import com.netflix.astyanax.ddl.impl.SchemaChangeResponseImpl;
import com.netflix.astyanax.retry.RetryPolicy;
import com.netflix.astyanax.retry.RunOnce;
import com.netflix.astyanax.thrift.AbstractKeyspaceOperationImpl;
import com.netflix.astyanax.thrift.AbstractOperationImpl;
import com.netflix.astyanax.thrift.ThriftKeyspaceImpl;
import com.netflix.astyanax.thrift.ThriftUtils;
import com.netflix.astyanax.thrift.ddl.ThriftColumnDefinitionImpl;
import com.netflix.astyanax.thrift.ddl.ThriftColumnFamilyDefinitionImpl;
import com.netflix.astyanax.thrift.ddl.ThriftKeyspaceDefinitionImpl;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentMap;
import org.apache.cassandra.thrift.Cassandra;
import org.apache.cassandra.thrift.CfDef;
import org.apache.cassandra.thrift.KsDef;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThriftClusterImpl
implements Cluster {
    private static final Logger LOG = LoggerFactory.getLogger(ThriftClusterImpl.class);
    private static final int MAX_SCHEMA_CHANGE_ATTEMPTS = 6;
    private static final int SCHEMA_DISAGREEMENT_BACKOFF = 10000;
    private final ConnectionPool<Cassandra.Client> connectionPool;
    private final ConcurrentMap<String, Keyspace> keyspaces;
    private final AstyanaxConfiguration config;
    private final KeyspaceTracerFactory tracerFactory;

    public ThriftClusterImpl(AstyanaxConfiguration config, ConnectionPool<Cassandra.Client> connectionPool, KeyspaceTracerFactory tracerFactory) {
        this.config = config;
        this.connectionPool = connectionPool;
        this.tracerFactory = tracerFactory;
        this.keyspaces = Maps.newConcurrentMap();
    }

    public String describeClusterName() throws ConnectionException {
        return (String)this.connectionPool.executeWithFailover((Operation)new AbstractOperationImpl<String>(this.tracerFactory.newTracer(CassandraOperationType.DESCRIBE_CLUSTER)){

            @Override
            public String internalExecute(Cassandra.Client client, ConnectionContext context) throws Exception {
                return client.describe_cluster_name();
            }
        }, this.config.getRetryPolicy().duplicate()).getResult();
    }

    public String describeSnitch() throws ConnectionException {
        return (String)this.connectionPool.executeWithFailover((Operation)new AbstractOperationImpl<String>(this.tracerFactory.newTracer(CassandraOperationType.DESCRIBE_SNITCH)){

            @Override
            public String internalExecute(Cassandra.Client client, ConnectionContext context) throws Exception {
                return client.describe_snitch();
            }
        }, this.config.getRetryPolicy().duplicate()).getResult();
    }

    public String describePartitioner() throws ConnectionException {
        return (String)this.connectionPool.executeWithFailover((Operation)new AbstractOperationImpl<String>(this.tracerFactory.newTracer(CassandraOperationType.DESCRIBE_PARTITIONER)){

            @Override
            public String internalExecute(Cassandra.Client client, ConnectionContext context) throws Exception {
                return client.describe_partitioner();
            }
        }, this.config.getRetryPolicy().duplicate()).getResult();
    }

    public Map<String, List<String>> describeSchemaVersions() throws ConnectionException {
        return (Map)this.connectionPool.executeWithFailover((Operation)new AbstractOperationImpl<Map<String, List<String>>>(this.tracerFactory.newTracer(CassandraOperationType.DESCRIBE_SCHEMA_VERSION)){

            @Override
            public Map<String, List<String>> internalExecute(Cassandra.Client client, ConnectionContext context) throws Exception {
                return client.describe_schema_versions();
            }
        }, this.config.getRetryPolicy().duplicate()).getResult();
    }

    public String getVersion() throws ConnectionException {
        return (String)this.connectionPool.executeWithFailover((Operation)new AbstractOperationImpl<String>(this.tracerFactory.newTracer(CassandraOperationType.GET_VERSION)){

            @Override
            public String internalExecute(Cassandra.Client client, ConnectionContext state) throws Exception {
                return client.describe_version();
            }
        }, this.config.getRetryPolicy().duplicate()).getResult();
    }

    private <K> OperationResult<K> executeSchemaChangeOperation(AbstractOperationImpl<K> op) throws OperationException, ConnectionException {
        int attempt = 0;
        while (true) {
            try {
                return this.connectionPool.executeWithFailover(op, this.config.getRetryPolicy().duplicate());
            }
            catch (SchemaDisagreementException e) {
                if (++attempt >= 6) {
                    throw e;
                }
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException e1) {
                    Thread.interrupted();
                    throw new RuntimeException(e1);
                }
            }
        }
    }

    public List<KeyspaceDefinition> describeKeyspaces() throws ConnectionException {
        return (List)this.connectionPool.executeWithFailover((Operation)new AbstractOperationImpl<List<KeyspaceDefinition>>(this.tracerFactory.newTracer(CassandraOperationType.DESCRIBE_KEYSPACES)){

            @Override
            public List<KeyspaceDefinition> internalExecute(Cassandra.Client client, ConnectionContext context) throws Exception {
                List ksDefs = client.describe_keyspaces();
                return Lists.transform((List)ksDefs, (Function)new Function<KsDef, KeyspaceDefinition>(){

                    public KeyspaceDefinition apply(KsDef ksDef) {
                        return new ThriftKeyspaceDefinitionImpl(ksDef);
                    }
                });
            }
        }, this.config.getRetryPolicy().duplicate()).getResult();
    }

    public KeyspaceDefinition describeKeyspace(String ksName) throws ConnectionException {
        List<KeyspaceDefinition> ksDefs = this.describeKeyspaces();
        for (KeyspaceDefinition ksDef : ksDefs) {
            if (!ksDef.getName().equals(ksName)) continue;
            return ksDef;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Keyspace getKeyspace(String ksName) {
        Keyspace keyspace = (Keyspace)this.keyspaces.get(ksName);
        if (keyspace == null) {
            ThriftClusterImpl thriftClusterImpl = this;
            synchronized (thriftClusterImpl) {
                ThriftKeyspaceImpl newKeyspace = new ThriftKeyspaceImpl(ksName, this.connectionPool, this.config, this.tracerFactory);
                keyspace = this.keyspaces.putIfAbsent(ksName, newKeyspace);
                if (keyspace == null) {
                    keyspace = newKeyspace;
                }
            }
        }
        return keyspace;
    }

    public ColumnFamilyDefinition makeColumnFamilyDefinition() {
        return new ThriftColumnFamilyDefinitionImpl();
    }

    public OperationResult<SchemaChangeResult> addColumnFamily(ColumnFamilyDefinition def) throws ConnectionException {
        return this.internalCreateColumnFamily(((ThriftColumnFamilyDefinitionImpl)def).getThriftColumnFamilyDefinition());
    }

    public OperationResult<SchemaChangeResult> createColumnFamily(Map<String, Object> options) throws ConnectionException {
        ThriftColumnFamilyDefinitionImpl def = new ThriftColumnFamilyDefinitionImpl();
        def.setFields(options);
        return this.internalCreateColumnFamily(def.getThriftColumnFamilyDefinition());
    }

    public OperationResult<SchemaChangeResult> createColumnFamily(Properties props) throws ConnectionException {
        CfDef def;
        try {
            def = ThriftUtils.getThriftObjectFromProperties(CfDef.class, props);
        }
        catch (Exception e) {
            throw new BadRequestException("Error converting properties to CfDef", (Throwable)e);
        }
        return this.internalCreateColumnFamily(def);
    }

    private OperationResult<SchemaChangeResult> internalCreateColumnFamily(final CfDef def) throws ConnectionException {
        return this.executeSchemaChangeOperation(new AbstractKeyspaceOperationImpl<SchemaChangeResult>(this.tracerFactory.newTracer(CassandraOperationType.ADD_COLUMN_FAMILY), def.getKeyspace()){

            @Override
            public SchemaChangeResult internalExecute(Cassandra.Client client, ConnectionContext context) throws Exception {
                ThriftClusterImpl.this.precheckSchemaAgreement(client);
                return new SchemaChangeResponseImpl().setSchemaId(client.system_add_column_family(def));
            }
        });
    }

    public OperationResult<SchemaChangeResult> updateColumnFamily(ColumnFamilyDefinition def) throws ConnectionException {
        return this.internalColumnFamily(((ThriftColumnFamilyDefinitionImpl)def).getThriftColumnFamilyDefinition());
    }

    public OperationResult<SchemaChangeResult> updateColumnFamily(Map<String, Object> options) throws ConnectionException {
        ThriftColumnFamilyDefinitionImpl def = new ThriftColumnFamilyDefinitionImpl();
        def.setFields(options);
        return this.internalColumnFamily(def.getThriftColumnFamilyDefinition());
    }

    public OperationResult<SchemaChangeResult> updateColumnFamily(Properties props) throws ConnectionException {
        CfDef def;
        try {
            def = ThriftUtils.getThriftObjectFromProperties(CfDef.class, props);
        }
        catch (Exception e) {
            throw new BadRequestException("Error converting properties to CfDef", (Throwable)e);
        }
        return this.internalColumnFamily(def);
    }

    private OperationResult<SchemaChangeResult> internalColumnFamily(final CfDef def) throws ConnectionException {
        return this.executeSchemaChangeOperation(new AbstractKeyspaceOperationImpl<SchemaChangeResult>(this.tracerFactory.newTracer(CassandraOperationType.UPDATE_COLUMN_FAMILY), def.getKeyspace()){

            @Override
            public SchemaChangeResult internalExecute(Cassandra.Client client, ConnectionContext context) throws Exception {
                ThriftClusterImpl.this.precheckSchemaAgreement(client);
                return new SchemaChangeResponseImpl().setSchemaId(client.system_update_column_family(def));
            }
        });
    }

    public KeyspaceDefinition makeKeyspaceDefinition() {
        return new ThriftKeyspaceDefinitionImpl();
    }

    public OperationResult<SchemaChangeResult> addKeyspace(KeyspaceDefinition def) throws ConnectionException {
        return this.internalCreateKeyspace(((ThriftKeyspaceDefinitionImpl)def).getThriftKeyspaceDefinition());
    }

    public OperationResult<SchemaChangeResult> createKeyspace(Map<String, Object> options) throws ConnectionException {
        ThriftKeyspaceDefinitionImpl def = new ThriftKeyspaceDefinitionImpl();
        def.setFields(options);
        return this.internalCreateKeyspace(def.getThriftKeyspaceDefinition());
    }

    public OperationResult<SchemaChangeResult> createKeyspace(Properties props) throws ConnectionException {
        KsDef def;
        try {
            def = ThriftUtils.getThriftObjectFromProperties(KsDef.class, props);
            if (def.getCf_defs() == null) {
                def.setCf_defs((List)Lists.newArrayList());
            }
        }
        catch (Exception e) {
            throw new BadRequestException("Error converting properties to KsDef", (Throwable)e);
        }
        return this.internalCreateKeyspace(def);
    }

    private OperationResult<SchemaChangeResult> internalCreateKeyspace(final KsDef def) throws ConnectionException {
        return this.executeSchemaChangeOperation(new AbstractOperationImpl<SchemaChangeResult>(this.tracerFactory.newTracer(CassandraOperationType.ADD_KEYSPACE)){

            @Override
            public SchemaChangeResult internalExecute(Cassandra.Client client, ConnectionContext context) throws Exception {
                ThriftClusterImpl.this.precheckSchemaAgreement(client);
                return new SchemaChangeResponseImpl().setSchemaId(client.system_add_keyspace(def));
            }
        });
    }

    public OperationResult<SchemaChangeResult> updateKeyspace(KeyspaceDefinition def) throws ConnectionException {
        return this.internalUpdateKeyspace(((ThriftKeyspaceDefinitionImpl)def).getThriftKeyspaceDefinition());
    }

    public OperationResult<SchemaChangeResult> updateKeyspace(Map<String, Object> options) throws ConnectionException {
        ThriftKeyspaceDefinitionImpl def = new ThriftKeyspaceDefinitionImpl();
        try {
            def.setFields(options);
        }
        catch (Exception e) {
            throw new BadRequestException("Error converting properties to KsDef", (Throwable)e);
        }
        return this.internalUpdateKeyspace(def.getThriftKeyspaceDefinition());
    }

    public OperationResult<SchemaChangeResult> updateKeyspace(Properties props) throws ConnectionException {
        KsDef def;
        try {
            def = ThriftUtils.getThriftObjectFromProperties(KsDef.class, props);
            if (def.getCf_defs() == null) {
                def.setCf_defs((List)Lists.newArrayList());
            }
        }
        catch (Exception e) {
            throw new BadRequestException("Error converting properties to KsDef", (Throwable)e);
        }
        return this.internalUpdateKeyspace(def);
    }

    private OperationResult<SchemaChangeResult> internalUpdateKeyspace(final KsDef def) throws ConnectionException {
        return this.executeSchemaChangeOperation(new AbstractOperationImpl<SchemaChangeResult>(this.tracerFactory.newTracer(CassandraOperationType.UPDATE_KEYSPACE)){

            @Override
            public SchemaChangeResult internalExecute(Cassandra.Client client, ConnectionContext context) throws Exception {
                ThriftClusterImpl.this.precheckSchemaAgreement(client);
                return new SchemaChangeResponseImpl().setSchemaId(client.system_update_keyspace(def));
            }
        });
    }

    public ColumnDefinition makeColumnDefinition() {
        return new ThriftColumnDefinitionImpl();
    }

    public AstyanaxConfiguration getConfig() {
        return this.config;
    }

    public OperationResult<SchemaChangeResult> dropColumnFamily(String keyspaceName, final String columnFamilyName) throws ConnectionException {
        return this.connectionPool.executeWithFailover((Operation)new AbstractKeyspaceOperationImpl<SchemaChangeResult>(this.tracerFactory.newTracer(CassandraOperationType.DROP_COLUMN_FAMILY), keyspaceName){

            @Override
            public SchemaChangeResult internalExecute(Cassandra.Client client, ConnectionContext context) throws Exception {
                ThriftClusterImpl.this.precheckSchemaAgreement(client);
                return new SchemaChangeResponseImpl().setSchemaId(client.system_drop_column_family(columnFamilyName));
            }
        }, (RetryPolicy)RunOnce.get());
    }

    public OperationResult<SchemaChangeResult> dropKeyspace(final String keyspaceName) throws ConnectionException {
        return this.connectionPool.executeWithFailover((Operation)new AbstractKeyspaceOperationImpl<SchemaChangeResult>(this.tracerFactory.newTracer(CassandraOperationType.DROP_KEYSPACE), keyspaceName){

            @Override
            public SchemaChangeResult internalExecute(Cassandra.Client client, ConnectionContext context) throws Exception {
                ThriftClusterImpl.this.precheckSchemaAgreement(client);
                return new SchemaChangeResponseImpl().setSchemaId(client.system_drop_keyspace(keyspaceName));
            }
        }, (RetryPolicy)RunOnce.get());
    }

    public Properties getAllKeyspaceProperties() throws ConnectionException {
        List<KeyspaceDefinition> keyspaces = this.describeKeyspaces();
        Properties props = new Properties();
        for (KeyspaceDefinition ksDef : keyspaces) {
            ThriftKeyspaceDefinitionImpl thriftKsDef = (ThriftKeyspaceDefinitionImpl)ksDef;
            try {
                for (Map.Entry<Object, Object> prop : thriftKsDef.getProperties().entrySet()) {
                    props.setProperty(ksDef.getName() + "." + prop.getKey(), (String)prop.getValue());
                }
            }
            catch (Exception e) {
            }
        }
        return props;
    }

    public Properties getKeyspaceProperties(String keyspace) throws ConnectionException {
        KeyspaceDefinition ksDef = this.describeKeyspace(keyspace);
        if (ksDef == null) {
            throw new NotFoundException(String.format("Keyspace '%s' not found", keyspace));
        }
        Properties props = new Properties();
        ThriftKeyspaceDefinitionImpl thriftKsDef = (ThriftKeyspaceDefinitionImpl)ksDef;
        try {
            for (Map.Entry<Object, Object> prop : thriftKsDef.getProperties().entrySet()) {
                props.setProperty((String)prop.getKey(), (String)prop.getValue());
            }
        }
        catch (Exception e) {
            LOG.error(String.format("Error fetching properties for keyspace '%s'", keyspace));
        }
        return props;
    }

    public Properties getColumnFamilyProperties(String keyspace, String columnFamily) throws ConnectionException {
        KeyspaceDefinition ksDef = this.describeKeyspace(keyspace);
        ColumnFamilyDefinition cfDef = ksDef.getColumnFamily(columnFamily);
        if (cfDef == null) {
            throw new NotFoundException(String.format("Column family '%s' in keyspace '%s' not found", columnFamily, keyspace));
        }
        Properties props = new Properties();
        ThriftColumnFamilyDefinitionImpl thriftCfDef = (ThriftColumnFamilyDefinitionImpl)cfDef;
        try {
            for (Map.Entry<Object, Object> prop : thriftCfDef.getProperties().entrySet()) {
                props.setProperty((String)prop.getKey(), (String)prop.getValue());
            }
        }
        catch (Exception e) {
            LOG.error("Error processing column family properties");
        }
        return props;
    }

    private void precheckSchemaAgreement(Cassandra.Client client) throws Exception {
        Map schemas = client.describe_schema_versions();
        if (schemas.size() > 1) {
            throw new SchemaDisagreementException("Can't change schema due to pending schema agreement");
        }
    }
}

