/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import org.hsqldb.HsqlDateTime;
import org.hsqldb.HsqlException;
import org.hsqldb.Scanner;
import org.hsqldb.Session;
import org.hsqldb.SessionInterface;
import org.hsqldb.error.Error;
import org.hsqldb.jdbc.JDBCConnection;
import org.hsqldb.lib.DataOutputStream;
import org.hsqldb.navigator.RowSetNavigatorClient;
import org.hsqldb.persist.HsqlProperties;
import org.hsqldb.result.Result;
import org.hsqldb.result.ResultLob;
import org.hsqldb.rowio.RowInputBinary;
import org.hsqldb.rowio.RowOutputBinary;
import org.hsqldb.rowio.RowOutputInterface;
import org.hsqldb.server.HsqlSocketFactory;
import org.hsqldb.store.ValuePool;
import org.hsqldb.types.BlobDataID;
import org.hsqldb.types.ClobDataID;
import org.hsqldb.types.TimestampData;

public class ClientConnection
implements SessionInterface {
    public static final String NETWORK_COMPATIBILITY_VERSION = "2.1.0.0";
    public static final int NETWORK_COMPATIBILITY_VERSION_INT = -2010000;
    static final int BUFFER_SIZE = 4096;
    final byte[] mainBuffer = new byte[4096];
    private boolean isClosed;
    private Socket socket;
    protected DataOutputStream dataOutput;
    protected DataInputStream dataInput;
    protected RowOutputInterface rowOut;
    protected RowInputBinary rowIn;
    private Result resultOut;
    private long sessionID;
    private long lobIDSequence = -1L;
    private boolean isReadOnlyDefault = false;
    private boolean isAutoCommit = true;
    private int zoneSeconds;
    private Scanner scanner;
    private String zoneString;
    private Calendar calendar;
    JDBCConnection connection;
    String host;
    int port;
    String path;
    String database;
    boolean isTLS;
    int databaseID;
    String clientPropertiesString;
    HsqlProperties clientProperties;
    String databaseUniqueName;

    public ClientConnection(String host, int port, String path, String database, boolean isTLS, String user, String password, int timeZoneSeconds) {
        this.host = host;
        this.port = port;
        this.path = path;
        this.database = database;
        this.isTLS = isTLS;
        this.zoneSeconds = timeZoneSeconds;
        this.zoneString = TimeZone.getDefault().getID();
        this.initStructures();
        Result login = Result.newConnectionAttemptRequest(user, password, database, this.zoneString, timeZoneSeconds);
        this.initConnection(host, port, isTLS);
        Result resultIn = this.execute(login);
        if (resultIn.isError()) {
            throw Error.error(resultIn);
        }
        this.sessionID = resultIn.getSessionId();
        this.databaseID = resultIn.getDatabaseId();
        this.databaseUniqueName = resultIn.getDatabaseName();
        this.clientPropertiesString = resultIn.getMainString();
    }

    private void initStructures() {
        RowOutputBinary rowOutTemp = new RowOutputBinary(this.mainBuffer);
        this.rowOut = rowOutTemp;
        this.rowIn = new RowInputBinary(rowOutTemp);
        this.resultOut = Result.newSessionAttributesResult();
    }

    protected void initConnection(String host, int port, boolean isTLS) {
        this.openConnection(host, port, isTLS);
    }

    protected void openConnection(String host, int port, boolean isTLS) {
        try {
            this.socket = HsqlSocketFactory.getInstance(isTLS).createSocket(host, port);
            this.socket.setTcpNoDelay(true);
            this.dataOutput = new DataOutputStream(this.socket.getOutputStream());
            this.dataInput = new DataInputStream(new BufferedInputStream(this.socket.getInputStream()));
            this.handshake();
        }
        catch (Exception e) {
            throw new HsqlException(e, Error.getStateString(1301), -1301);
        }
    }

    protected void closeConnection() {
        try {
            if (this.socket != null) {
                this.socket.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.socket = null;
    }

    public synchronized Result execute(Result r) {
        try {
            r.setSessionId(this.sessionID);
            r.setDatabaseId(this.databaseID);
            this.write(r);
            return this.read();
        }
        catch (Throwable e) {
            throw Error.error(1305, e.toString());
        }
    }

    public synchronized RowSetNavigatorClient getRows(long navigatorId, int offset, int size) {
        try {
            this.resultOut.setResultType(13);
            this.resultOut.setResultId(navigatorId);
            this.resultOut.setUpdateCount(offset);
            this.resultOut.setFetchSize(size);
            Result result = this.execute(this.resultOut);
            return (RowSetNavigatorClient)result.getNavigator();
        }
        catch (Throwable e) {
            throw Error.error(1305, e.toString());
        }
    }

    public synchronized void closeNavigator(long navigatorId) {
        try {
            this.resultOut.setResultType(40);
            this.resultOut.setResultId(navigatorId);
            this.execute(this.resultOut);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public synchronized void close() {
        if (this.isClosed) {
            return;
        }
        this.isClosed = true;
        try {
            this.resultOut.setResultType(32);
            this.execute(this.resultOut);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.closeConnection();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public synchronized Object getAttribute(int id) {
        this.resultOut.setResultType(7);
        this.resultOut.setStatementType(id);
        Result in = this.execute(this.resultOut);
        if (in.isError()) {
            throw Error.error(in);
        }
        Object[] data = in.getSingleRowData();
        switch (id) {
            case 1: {
                return data[2];
            }
            case 2: {
                return data[2];
            }
            case 0: {
                return data[1];
            }
            case 3: {
                return data[3];
            }
        }
        return null;
    }

    public synchronized void setAttribute(int id, Object value) {
        this.resultOut.setResultType(6);
        Object[] data = this.resultOut.getSingleRowData();
        data[0] = ValuePool.getInt(id);
        switch (id) {
            case 1: 
            case 2: {
                data[2] = value;
                break;
            }
            case 0: {
                data[1] = value;
                break;
            }
            case 3: {
                data[3] = value;
            }
        }
        Result resultIn = this.execute(this.resultOut);
        if (resultIn.isError()) {
            throw Error.error(resultIn);
        }
    }

    public synchronized boolean isReadOnlyDefault() {
        Object info = this.getAttribute(2);
        this.isReadOnlyDefault = (Boolean)info;
        return this.isReadOnlyDefault;
    }

    public synchronized void setReadOnlyDefault(boolean mode) {
        if (mode != this.isReadOnlyDefault) {
            this.setAttribute(2, mode ? Boolean.TRUE : Boolean.FALSE);
            this.isReadOnlyDefault = mode;
        }
    }

    public synchronized boolean isAutoCommit() {
        Object info = this.getAttribute(1);
        this.isAutoCommit = (Boolean)info;
        return this.isAutoCommit;
    }

    public synchronized void setAutoCommit(boolean mode) {
        if (mode != this.isAutoCommit) {
            this.setAttribute(1, mode ? Boolean.TRUE : Boolean.FALSE);
            this.isAutoCommit = mode;
        }
    }

    public synchronized void setIsolationDefault(int level) {
        this.setAttribute(0, ValuePool.getInt(level));
    }

    public synchronized int getIsolation() {
        Object info = this.getAttribute(0);
        return (Integer)info;
    }

    public synchronized boolean isClosed() {
        return this.isClosed;
    }

    public Session getSession() {
        return null;
    }

    public synchronized void startPhasedTransaction() {
    }

    public synchronized void prepareCommit() {
        this.resultOut.setAsTransactionEndRequest(12, null);
        Result in = this.execute(this.resultOut);
        if (in.isError()) {
            throw Error.error(in);
        }
    }

    public synchronized void commit(boolean chain) {
        this.resultOut.setAsTransactionEndRequest(0, null);
        Result in = this.execute(this.resultOut);
        if (in.isError()) {
            throw Error.error(in);
        }
    }

    public synchronized void rollback(boolean chain) {
        this.resultOut.setAsTransactionEndRequest(1, null);
        Result in = this.execute(this.resultOut);
        if (in.isError()) {
            throw Error.error(in);
        }
    }

    public synchronized void rollbackToSavepoint(String name) {
        this.resultOut.setAsTransactionEndRequest(2, name);
        Result in = this.execute(this.resultOut);
        if (in.isError()) {
            throw Error.error(in);
        }
    }

    public synchronized void savepoint(String name) {
        Result result = Result.newSetSavepointRequest(name);
        Result in = this.execute(result);
        if (in.isError()) {
            throw Error.error(in);
        }
    }

    public synchronized void releaseSavepoint(String name) {
        this.resultOut.setAsTransactionEndRequest(4, name);
        Result in = this.execute(this.resultOut);
        if (in.isError()) {
            throw Error.error(in);
        }
    }

    public void addWarning(HsqlException warning) {
    }

    public synchronized long getId() {
        return this.sessionID;
    }

    public synchronized void resetSession() {
        Result login = Result.newResetSessionRequest();
        Result resultIn = this.execute(login);
        if (resultIn.isError()) {
            this.isClosed = true;
            this.closeConnection();
            throw Error.error(resultIn);
        }
        this.sessionID = resultIn.getSessionId();
        this.databaseID = resultIn.getDatabaseId();
    }

    protected void write(Result r) throws IOException, HsqlException {
        r.write(this, this.dataOutput, this.rowOut);
    }

    protected Result read() throws IOException, HsqlException {
        Result result = Result.newResult(this.dataInput, this.rowIn);
        result.readAdditionalResults(this, this.dataInput, this.rowIn);
        this.rowOut.setBuffer(this.mainBuffer);
        this.rowIn.resetRow(this.mainBuffer.length);
        return result;
    }

    public synchronized String getInternalConnectionURL() {
        return null;
    }

    public synchronized long getLobId() {
        return this.lobIDSequence--;
    }

    public BlobDataID createBlob(long length) {
        BlobDataID blob = new BlobDataID(this.getLobId());
        return blob;
    }

    public ClobDataID createClob(long length) {
        ClobDataID clob = new ClobDataID(this.getLobId());
        return clob;
    }

    public void allocateResultLob(ResultLob resultLob, InputStream dataInput) {
    }

    public Scanner getScanner() {
        if (this.scanner == null) {
            this.scanner = new Scanner();
        }
        return this.scanner;
    }

    public Calendar getCalendar() {
        if (this.calendar == null) {
            TimeZone zone = TimeZone.getTimeZone(this.zoneString);
            this.calendar = new GregorianCalendar(zone);
        }
        return this.calendar;
    }

    public TimestampData getCurrentDate() {
        long currentMillis = System.currentTimeMillis();
        long seconds = HsqlDateTime.getCurrentDateMillis(currentMillis) / 1000L;
        return new TimestampData(seconds);
    }

    public int getZoneSeconds() {
        return this.zoneSeconds;
    }

    public int getStreamBlockSize() {
        return 524288;
    }

    public HsqlProperties getClientProperties() {
        if (this.clientProperties == null) {
            if (this.clientPropertiesString.length() > 0) {
                HsqlProperties.delimitedArgPairsToProps(this.clientPropertiesString, "=", ";", null);
            } else {
                this.clientProperties = new HsqlProperties();
            }
        }
        return this.clientProperties;
    }

    public JDBCConnection getJDBCConnection() {
        return this.connection;
    }

    public void setJDBCConnection(JDBCConnection connection) {
        this.connection = connection;
    }

    public String getDatabaseUniqueName() {
        return this.databaseUniqueName;
    }

    public static String toNetCompVersionString(int i) {
        StringBuffer sb = new StringBuffer();
        sb.append((i *= -1) / 1000000);
        sb.append('.');
        sb.append((i %= 1000000) / 10000);
        sb.append('.');
        sb.append((i %= 10000) / 100);
        sb.append('.');
        sb.append(i %= 100);
        return sb.toString();
    }

    protected void handshake() throws IOException {
        this.dataOutput.writeInt(-2010000);
        this.dataOutput.flush();
    }
}

