/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.ColumnSchema;
import org.hsqldb.RangeVariable;
import org.hsqldb.Session;
import org.hsqldb.Statement;
import org.hsqldb.StatementDMQL;
import org.hsqldb.StatementResultUpdate;
import org.hsqldb.Table;
import org.hsqldb.error.Error;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.HashMappedList;
import org.hsqldb.lib.HashSet;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.LongDeque;
import org.hsqldb.navigator.RangeIterator;
import org.hsqldb.store.ValuePool;

public class SessionContext {
    Session session;
    public Boolean isAutoCommit;
    Boolean isReadOnly;
    Boolean noSQL;
    int currentMaxRows;
    HashMappedList sessionVariables;
    RangeVariable[] sessionVariablesRange;
    private HsqlArrayList stack;
    Object[] routineArguments = ValuePool.emptyObjectArray;
    Object[] routineVariables = ValuePool.emptyObjectArray;
    Object[] dynamicArguments = ValuePool.emptyObjectArray;
    Object[][] triggerArguments = null;
    public int depth;
    Number lastIdentity = ValuePool.INTEGER_0;
    HashMappedList savepoints;
    LongDeque savepointTimestamps;
    RangeIterator[] rangeIterators;
    HashMappedList sessionTables;
    HashMappedList popSessionTables;
    public Statement currentStatement;
    public int rownum;
    HashSet constraintPath;
    StatementResultUpdate rowUpdateStatement = new StatementResultUpdate();

    SessionContext(Session session) {
        this.session = session;
        this.rangeIterators = new RangeIterator[8];
        this.savepoints = new HashMappedList(4);
        this.savepointTimestamps = new LongDeque();
        this.sessionVariables = new HashMappedList();
        this.sessionVariablesRange = new RangeVariable[1];
        this.sessionVariablesRange[0] = new RangeVariable(this.sessionVariables, null, true, 4);
        this.isAutoCommit = Boolean.FALSE;
        this.isReadOnly = Boolean.FALSE;
        this.noSQL = Boolean.FALSE;
    }

    public void push() {
        if (this.session.sessionContext.depth > 256) {
            throw Error.error(458);
        }
        this.session.sessionData.persistentStoreCollection.push();
        if (this.stack == null) {
            this.stack = new HsqlArrayList(true);
        }
        this.stack.add(this.dynamicArguments);
        this.stack.add(this.routineArguments);
        this.stack.add(this.triggerArguments);
        this.stack.add(this.routineVariables);
        this.stack.add(this.rangeIterators);
        this.stack.add(this.savepoints);
        this.stack.add(this.savepointTimestamps);
        this.stack.add(this.lastIdentity);
        this.stack.add(this.isAutoCommit);
        this.stack.add(this.isReadOnly);
        this.stack.add(this.noSQL);
        this.stack.add(ValuePool.getInt(this.currentMaxRows));
        this.stack.add(ValuePool.getInt(this.rownum));
        this.rangeIterators = new RangeIterator[8];
        this.savepoints = new HashMappedList(4);
        this.savepointTimestamps = new LongDeque();
        this.isAutoCommit = Boolean.FALSE;
        this.currentMaxRows = 0;
        ++this.depth;
    }

    public void pop() {
        this.session.sessionData.persistentStoreCollection.pop();
        this.rownum = (Integer)this.stack.remove(this.stack.size() - 1);
        this.currentMaxRows = (Integer)this.stack.remove(this.stack.size() - 1);
        this.noSQL = (Boolean)this.stack.remove(this.stack.size() - 1);
        this.isReadOnly = (Boolean)this.stack.remove(this.stack.size() - 1);
        this.isAutoCommit = (Boolean)this.stack.remove(this.stack.size() - 1);
        this.lastIdentity = (Number)this.stack.remove(this.stack.size() - 1);
        this.savepointTimestamps = (LongDeque)this.stack.remove(this.stack.size() - 1);
        this.savepoints = (HashMappedList)this.stack.remove(this.stack.size() - 1);
        this.rangeIterators = (RangeIterator[])this.stack.remove(this.stack.size() - 1);
        this.routineVariables = (Object[])this.stack.remove(this.stack.size() - 1);
        this.triggerArguments = (Object[][])this.stack.remove(this.stack.size() - 1);
        this.routineArguments = (Object[])this.stack.remove(this.stack.size() - 1);
        this.dynamicArguments = (Object[])this.stack.remove(this.stack.size() - 1);
        --this.depth;
    }

    public void pushDynamicArguments(Object[] args) {
        this.push();
        this.dynamicArguments = args;
    }

    public void setDynamicArguments(Object[] args) {
        this.dynamicArguments = args;
    }

    void clearStructures(StatementDMQL cs) {
        int count = cs.rangeIteratorCount;
        if (count > this.rangeIterators.length) {
            count = this.rangeIterators.length;
        }
        for (int i = 0; i < count; ++i) {
            if (this.rangeIterators[i] == null) continue;
            this.rangeIterators[i].reset();
            this.rangeIterators[i] = null;
        }
    }

    public RangeVariable.RangeIteratorBase getCheckIterator(RangeVariable rangeVariable) {
        RangeIterator it = this.rangeIterators[0];
        if (it == null) {
            this.rangeIterators[0] = it = rangeVariable.getIterator(this.session);
        }
        return (RangeVariable.RangeIteratorBase)it;
    }

    public void setRangeIterator(RangeIterator iterator) {
        int position = iterator.getRangePosition();
        if (position >= this.rangeIterators.length) {
            this.rangeIterators = (RangeIterator[])ArrayUtil.resizeArray(this.rangeIterators, position + 4);
        }
        this.rangeIterators[iterator.getRangePosition()] = iterator;
    }

    public HashSet getConstraintPath() {
        if (this.constraintPath == null) {
            this.constraintPath = new HashSet();
        } else {
            this.constraintPath.clear();
        }
        return this.constraintPath;
    }

    public void addSessionVariable(ColumnSchema variable) {
        int index = this.sessionVariables.size();
        if (!this.sessionVariables.add(variable.getName().name, variable)) {
            throw Error.error(5504);
        }
        Object[] vars = new Object[this.sessionVariables.size()];
        ArrayUtil.copyArray(this.routineVariables, vars, this.routineVariables.length);
        this.routineVariables = vars;
        this.routineVariables[index] = variable.getDefaultValue(this.session);
    }

    public void pushRoutineTables(HashMappedList map) {
        this.popSessionTables = this.sessionTables;
        this.sessionTables = map;
    }

    public void popRoutineTables() {
        this.sessionTables = this.popSessionTables;
    }

    public void addSessionTable(Table table) {
        if (this.sessionTables == null) {
            this.sessionTables = new HashMappedList();
        }
        if (this.sessionTables.containsKey(table.getName().name)) {
            throw Error.error(5504);
        }
        this.sessionTables.add(table.getName().name, table);
    }

    public void setSessionTables(Table[] tables) {
    }

    public Table findSessionTable(String name) {
        if (this.sessionTables == null) {
            return null;
        }
        return (Table)this.sessionTables.get(name);
    }

    public void dropSessionTable(String name) {
        this.sessionTables.remove(name);
    }
}

