/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.jdbc.pool;

import java.sql.SQLException;
import java.sql.Savepoint;
import org.hsqldb.jdbc.JDBCConnection;
import org.hsqldb.jdbc.pool.JDBCXAResource;

public class JDBCXAConnectionWrapper
extends JDBCConnection {
    private JDBCXAResource xaResource;

    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.validateNotWithinTransaction();
        super.setAutoCommit(autoCommit);
    }

    public void commit() throws SQLException {
        this.validateNotWithinTransaction();
        super.commit();
    }

    public void rollback() throws SQLException {
        this.validateNotWithinTransaction();
        super.rollback();
    }

    public void rollback(Savepoint savepoint) throws SQLException {
        this.validateNotWithinTransaction();
        super.rollback(savepoint);
    }

    public Savepoint setSavepoint() throws SQLException {
        this.validateNotWithinTransaction();
        return super.setSavepoint();
    }

    public Savepoint setSavepoint(String name) throws SQLException {
        this.validateNotWithinTransaction();
        return super.setSavepoint(name);
    }

    public void setTransactionIsolation(int level) throws SQLException {
        this.validateNotWithinTransaction();
        super.setTransactionIsolation(level);
    }

    public JDBCXAConnectionWrapper(JDBCXAResource xaResource, JDBCConnection databaseConnection) throws SQLException {
        super(databaseConnection, null);
        xaResource.setConnection(this);
        this.xaResource = xaResource;
    }

    private void validateNotWithinTransaction() throws SQLException {
        if (this.xaResource.withinGlobalTransaction()) {
            throw new SQLException("Method prohibited within a global transaction");
        }
    }
}

