/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.navigator;

import java.io.IOException;
import java.util.NoSuchElementException;
import org.hsqldb.Row;
import org.hsqldb.Session;
import org.hsqldb.error.Error;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.OrderedLongKeyHashMap;
import org.hsqldb.navigator.RowSetNavigator;
import org.hsqldb.result.ResultMetaData;
import org.hsqldb.rowio.RowInputInterface;
import org.hsqldb.rowio.RowOutputInterface;
import org.hsqldb.types.Type;

public class RowSetNavigatorDataChange
extends RowSetNavigator {
    OrderedLongKeyHashMap list = new OrderedLongKeyHashMap(8, true);
    boolean enforceDeleteOrUpdate;
    boolean enforceSingeUpdate;

    public RowSetNavigatorDataChange() {
    }

    public RowSetNavigatorDataChange(boolean enforceDeleteOrUpdate, boolean enforceSingeUpdate) {
        this.enforceDeleteOrUpdate = enforceDeleteOrUpdate;
        this.enforceSingeUpdate = enforceSingeUpdate;
    }

    public Object[] getCurrent() {
        return this.getCurrentRow().getData();
    }

    public Row getCurrentRow() {
        return (Row)this.list.getValueByIndex(this.currentPos);
    }

    public Object[] getCurrentChangedData() {
        return (Object[])this.list.getSecondValueByIndex(this.currentPos);
    }

    public int[] getCurrentChangedColumns() {
        return (int[])this.list.getThirdValueByIndex(this.currentPos);
    }

    public Row getNextRow() {
        return this.next() ? this.getCurrentRow() : null;
    }

    public void remove() {
        throw new NoSuchElementException();
    }

    public boolean next() {
        return super.next();
    }

    public void reset() {
        super.reset();
    }

    public void write(RowOutputInterface out, ResultMetaData meta) throws IOException {
        this.beforeFirst();
        out.writeLong(this.id);
        out.writeInt(this.size);
        out.writeInt(0);
        out.writeInt(this.size);
        while (this.hasNext()) {
            Object[] data = this.getNext();
            out.writeData(meta.getColumnCount(), meta.columnTypes, data, null, null);
        }
        this.beforeFirst();
    }

    public void read(RowInputInterface in, ResultMetaData meta) throws IOException {
        this.id = in.readLong();
        int count = in.readInt();
        in.readInt();
        in.readInt();
        while (count-- > 0) {
            this.add(in.readData(meta.columnTypes));
        }
    }

    public void clear() {
        this.reset();
        this.list.clear();
        this.size = 0;
    }

    public void add(Object[] d) {
        throw Error.runtimeError(201, "RowSetNavigatorDataChange");
    }

    public boolean addRow(Row row) {
        int lookup = this.list.getLookup(row.getId());
        if (lookup == -1) {
            this.list.put(row.getId(), row, null);
            ++this.size;
            return true;
        }
        if (this.list.getSecondValueByIndex(lookup) != null && this.enforceDeleteOrUpdate) {
            throw Error.error(3900);
        }
        return false;
    }

    public Object[] addRow(Session session, Row row, Object[] data, Type[] types, int[] columnMap) {
        long rowId = row.getId();
        int lookup = this.list.getLookup(rowId);
        if (lookup == -1) {
            this.list.put(rowId, row, data);
            this.list.setThirdValueByIndex(this.size, columnMap);
            ++this.size;
            return data;
        }
        Object[] rowData = ((Row)this.list.getFirstByLookup(lookup)).getData();
        Object[] currentData = (Object[])this.list.getSecondValueByIndex(lookup);
        if (currentData == null && this.enforceDeleteOrUpdate) {
            throw Error.error(3900);
        }
        for (int i = 0; i < columnMap.length; ++i) {
            int j = columnMap[i];
            if (types[j].compare(session, data[j], currentData[j]) == 0) continue;
            if (types[j].compare(session, rowData[j], currentData[j]) != 0) {
                throw Error.error(3900);
            }
            currentData[j] = data[j];
        }
        int[] currentMap = (int[])this.list.getThirdValueByIndex(lookup);
        currentMap = ArrayUtil.union(currentMap, columnMap);
        this.list.setThirdValueByIndex(lookup, currentMap);
        return currentData;
    }

    public boolean containsDeletedRow(Row row) {
        int lookup = this.list.getLookup(row.getId());
        if (lookup == -1) {
            return false;
        }
        Object[] currentData = (Object[])this.list.getSecondValueByIndex(lookup);
        return currentData == null;
    }
}

