/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import java.util.Comparator;
import org.hsqldb.lib.ArraySort;
import org.hsqldb.lib.StopWatch;
import org.hsqldb.persist.CachedObject;
import org.hsqldb.persist.DataFileCache;
import org.hsqldb.store.BaseHashMap;

public class Cache
extends BaseHashMap {
    final DataFileCache dataFileCache;
    private int capacity;
    private long bytesCapacity;
    private final CachedObjectComparator rowComparator;
    private CachedObject[] rowTable;
    long cacheBytesLength;
    StopWatch saveAllTimer = new StopWatch(false);
    StopWatch sortTimer = new StopWatch(false);
    int saveRowCount = 0;

    Cache(DataFileCache dfc) {
        super(dfc.capacity(), 1, 3, true);
        this.maxCapacity = dfc.capacity();
        this.dataFileCache = dfc;
        this.capacity = dfc.capacity();
        this.bytesCapacity = dfc.bytesCapacity();
        this.rowComparator = new CachedObjectComparator();
        this.rowTable = new CachedObject[this.capacity];
        this.cacheBytesLength = 0L;
    }

    void init(int capacity, long bytesCapacity) {
    }

    long getTotalCachedBlockSize() {
        return this.cacheBytesLength;
    }

    public synchronized CachedObject get(int pos) {
        int lookup;
        if (this.accessCount > 0x7FEFFFFF) {
            this.updateAccessCounts();
            this.resetAccessCount();
            this.updateObjectAccessCounts();
        }
        if ((lookup = this.getLookup(pos)) == -1) {
            return null;
        }
        this.accessTable[lookup] = ++this.accessCount;
        CachedObject object = (CachedObject)this.objectValueTable[lookup];
        return object;
    }

    synchronized void put(int key, CachedObject row) {
        int storageSize = row.getStorageSize();
        if (this.size() >= this.capacity || (long)storageSize + this.cacheBytesLength > this.bytesCapacity) {
            this.cleanUp();
            if (this.size() >= this.capacity) {
                this.forceCleanUp();
            }
        }
        if (this.accessCount > 0x7FEFFFFF) {
            this.updateAccessCounts();
            this.resetAccessCount();
            this.updateObjectAccessCounts();
        }
        super.addOrRemove(key, row, null, false);
        row.setInMemory(true);
        this.cacheBytesLength += (long)storageSize;
    }

    synchronized CachedObject release(int i) {
        CachedObject r = (CachedObject)super.addOrRemove(i, null, null, true);
        if (r == null) {
            return null;
        }
        this.cacheBytesLength -= (long)r.getStorageSize();
        r.setInMemory(false);
        return r;
    }

    synchronized void replace(int key, CachedObject row) {
        int lookup = super.getLookup(key);
        this.objectValueTable[lookup] = row;
    }

    private void updateAccessCounts() {
        for (int i = 0; i < this.objectValueTable.length; ++i) {
            int count;
            CachedObject r = (CachedObject)this.objectValueTable[i];
            if (r == null || (count = r.getAccessCount()) <= this.accessTable[i]) continue;
            this.accessTable[i] = count;
        }
    }

    private void updateObjectAccessCounts() {
        for (int i = 0; i < this.objectValueTable.length; ++i) {
            CachedObject r = (CachedObject)this.objectValueTable[i];
            if (r == null) continue;
            int count = this.accessTable[i];
            r.updateAccessCount(count);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void cleanUp() {
        this.updateAccessCounts();
        int removeCount = this.size() / 2;
        int accessTarget = this.getAccessCountCeiling(removeCount, removeCount / 8);
        BaseHashMap.BaseHashIterator it = new BaseHashMap.BaseHashIterator(this);
        int savecount = 0;
        while (it.hasNext()) {
            boolean oldRow;
            CachedObject row = (CachedObject)it.next();
            int currentAccessCount = it.getAccessCount();
            boolean bl = oldRow = currentAccessCount <= accessTarget;
            if (oldRow) {
                CachedObject cachedObject = row;
                synchronized (cachedObject) {
                    if (row.isKeepInMemory()) {
                        it.setAccessCount(accessTarget + 1);
                    } else {
                        if (row.hasChanged()) {
                            this.rowTable[savecount++] = row;
                        }
                        row.setInMemory(false);
                        it.remove();
                        this.cacheBytesLength -= (long)row.getStorageSize();
                        --removeCount;
                    }
                }
            }
            if (savecount != this.rowTable.length) continue;
            this.saveRows(savecount);
            savecount = 0;
        }
        super.setAccessCountFloor(accessTarget);
        this.saveRows(savecount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void forceCleanUp() {
        BaseHashMap.BaseHashIterator it = new BaseHashMap.BaseHashIterator(this);
        while (it.hasNext()) {
            CachedObject row;
            CachedObject cachedObject = row = (CachedObject)it.next();
            synchronized (cachedObject) {
                if (!row.hasChanged() && !row.isKeepInMemory()) {
                    row.setInMemory(false);
                    it.remove();
                    this.cacheBytesLength -= (long)row.getStorageSize();
                }
            }
        }
    }

    private synchronized void saveRows(int count) {
        if (count == 0) {
            return;
        }
        long startTime = this.saveAllTimer.elapsedTime();
        this.rowComparator.setType(1);
        this.sortTimer.zero();
        this.sortTimer.start();
        ArraySort.sort(this.rowTable, 0, count, this.rowComparator);
        this.sortTimer.stop();
        this.saveAllTimer.start();
        this.dataFileCache.saveRows(this.rowTable, 0, count);
        this.saveRowCount += count;
        this.saveAllTimer.stop();
        this.logSaveRowsEvent(count, startTime);
    }

    synchronized void saveAll() {
        BaseHashMap.BaseHashIterator it = new BaseHashMap.BaseHashIterator(this);
        int savecount = 0;
        while (it.hasNext()) {
            CachedObject r;
            if (savecount == this.rowTable.length) {
                this.saveRows(savecount);
                savecount = 0;
            }
            if (!(r = (CachedObject)it.next()).hasChanged()) continue;
            this.rowTable[savecount++] = r;
        }
        this.saveRows(savecount);
    }

    void logSaveRowsEvent(int saveCount, long startTime) {
        StringBuffer sb = new StringBuffer();
        sb.append("cache save rows [count,time] totals ");
        sb.append(this.saveRowCount);
        sb.append(',').append(this.saveAllTimer.elapsedTime()).append(' ');
        sb.append("operation ").append(saveCount).append(',');
        sb.append(this.saveAllTimer.elapsedTime() - startTime).append(' ');
        sb.append(this.dataFileCache.database.txManager.getGlobalChangeTimestamp());
        this.dataFileCache.database.logger.logDetailEvent(sb.toString());
    }

    public synchronized void clear() {
        super.clear();
        this.cacheBytesLength = 0L;
    }

    static final class CachedObjectComparator
    implements Comparator {
        static final int COMPARE_LAST_ACCESS = 0;
        static final int COMPARE_POSITION = 1;
        static final int COMPARE_SIZE = 2;
        private int compareType;

        CachedObjectComparator() {
        }

        void setType(int type) {
            this.compareType = type;
        }

        public int compare(Object a, Object b) {
            switch (this.compareType) {
                case 1: {
                    return ((CachedObject)a).getPos() - ((CachedObject)b).getPos();
                }
                case 2: {
                    return ((CachedObject)a).getStorageSize() - ((CachedObject)b).getStorageSize();
                }
            }
            return 0;
        }
    }
}

