/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import org.hsqldb.Database;
import org.hsqldb.error.Error;
import org.hsqldb.persist.LobStore;
import org.hsqldb.persist.RandomAccessInterface;
import org.hsqldb.persist.ScaledRAFile;
import org.hsqldb.persist.ScaledRAFileSimple;

public class LobStoreRAFile
implements LobStore {
    final int lobBlockSize;
    RandomAccessInterface file;
    Database database;

    public LobStoreRAFile(Database database, int lobBlockSize) {
        this.lobBlockSize = lobBlockSize;
        this.database = database;
        try {
            String name = database.getPath() + ".lobs";
            boolean exists = database.logger.getFileAccess().isStreamElement(name);
            if (exists) {
                this.openFile();
            }
        }
        catch (Throwable t) {
            throw Error.error(466, t);
        }
    }

    private void openFile() {
        try {
            String name = this.database.getPath() + ".lobs";
            boolean readonly = this.database.isFilesReadOnly();
            this.file = this.database.logger.isStoredFileAccess() ? ScaledRAFile.newScaledRAFile(this.database, name, readonly, 3) : new ScaledRAFileSimple(name, readonly ? "r" : "rws");
        }
        catch (Throwable t) {
            throw Error.error(466, t);
        }
    }

    public byte[] getBlockBytes(int blockAddress, int blockCount) {
        if (this.file == null) {
            throw Error.error(452);
        }
        try {
            long address = (long)blockAddress * (long)this.lobBlockSize;
            int count = blockCount * this.lobBlockSize;
            byte[] dataBytes = new byte[count];
            this.file.seek(address);
            this.file.read(dataBytes, 0, count);
            return dataBytes;
        }
        catch (Throwable t) {
            throw Error.error(466, t);
        }
    }

    public void setBlockBytes(byte[] dataBytes, int blockAddress, int blockCount) {
        if (this.file == null) {
            this.openFile();
        }
        try {
            long address = (long)blockAddress * (long)this.lobBlockSize;
            int count = blockCount * this.lobBlockSize;
            this.file.seek(address);
            this.file.write(dataBytes, 0, count);
        }
        catch (Throwable t) {
            throw Error.error(466, t);
        }
    }

    public int getBlockSize() {
        return this.lobBlockSize;
    }

    public void close() {
        try {
            if (this.file != null) {
                this.file.synch();
                this.file.close();
            }
        }
        catch (Throwable t) {
            throw Error.error(466, t);
        }
    }

    public void synch() {
        if (this.file != null) {
            this.file.synch();
        }
    }
}

