/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.types;

import java.math.BigDecimal;
import org.hsqldb.Session;
import org.hsqldb.SessionInterface;
import org.hsqldb.Tokens;
import org.hsqldb.error.Error;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.types.CharacterType;
import org.hsqldb.types.DTIType;
import org.hsqldb.types.DateTimeType;
import org.hsqldb.types.IntervalMonthData;
import org.hsqldb.types.IntervalSecondData;
import org.hsqldb.types.NumberType;
import org.hsqldb.types.TimeData;
import org.hsqldb.types.TimestampData;
import org.hsqldb.types.Type;

public final class IntervalType
extends DTIType {
    public final boolean defaultPrecision;
    public final boolean isYearMonth;

    private IntervalType(int typeGroup, int type, long precision, int scale, int startIntervalType, int endIntervalType, boolean defaultPrecision) {
        super(typeGroup, type, precision, scale, startIntervalType, endIntervalType);
        if (endIntervalType != 106 && scale != 0) {
            throw Error.error(3406);
        }
        switch (startIntervalType) {
            case 101: 
            case 102: {
                this.isYearMonth = true;
                break;
            }
            default: {
                this.isYearMonth = false;
            }
        }
        this.defaultPrecision = defaultPrecision;
    }

    public int displaySize() {
        switch (this.typeCode) {
            case 101: {
                return (int)this.precision + 1;
            }
            case 107: {
                return (int)this.precision + 4;
            }
            case 102: {
                return (int)this.precision + 1;
            }
            case 103: {
                return (int)this.precision + 1;
            }
            case 108: {
                return (int)this.precision + 4;
            }
            case 109: {
                return (int)this.precision + 7;
            }
            case 110: {
                return (int)this.precision + 10 + (this.scale == 0 ? 0 : this.scale + 1);
            }
            case 104: {
                return (int)this.precision + 1;
            }
            case 111: {
                return (int)this.precision + 4;
            }
            case 112: {
                return (int)this.precision + 7 + (this.scale == 0 ? 0 : this.scale + 1);
            }
            case 105: {
                return (int)this.precision + 1;
            }
            case 113: {
                return (int)this.precision + 4 + (this.scale == 0 ? 0 : this.scale + 1);
            }
            case 106: {
                return (int)this.precision + 1 + (this.scale == 0 ? 0 : this.scale + 1);
            }
        }
        throw Error.runtimeError(201, "IntervalType");
    }

    public int getJDBCTypeCode() {
        return this.typeCode;
    }

    public Class getJDBCClass() {
        switch (this.typeCode) {
            case 101: 
            case 102: 
            case 107: {
                return IntervalMonthData.class;
            }
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: {
                return IntervalSecondData.class;
            }
        }
        throw Error.runtimeError(201, "IntervalType");
    }

    public String getJDBCClassName() {
        switch (this.typeCode) {
            case 101: 
            case 102: 
            case 107: {
                return IntervalMonthData.class.getName();
            }
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: {
                return IntervalSecondData.class.getName();
            }
        }
        throw Error.runtimeError(201, "IntervalType");
    }

    public int getJDBCPrecision() {
        return this.displaySize();
    }

    public int getSQLGenericTypeCode() {
        return 10;
    }

    public String getNameString() {
        return "INTERVAL " + IntervalType.getQualifier(this.typeCode);
    }

    public static String getQualifier(int type) {
        switch (type) {
            case 101: {
                return "YEAR";
            }
            case 107: {
                return "YEAR TO MONTH";
            }
            case 102: {
                return "MONTH";
            }
            case 103: {
                return "DAY";
            }
            case 108: {
                return "DAY TO HOUR";
            }
            case 109: {
                return "DAY TO MINUTE";
            }
            case 110: {
                return "DAY TO SECOND";
            }
            case 104: {
                return "HOUR";
            }
            case 111: {
                return "HOUR TO MINUTE";
            }
            case 112: {
                return "HOUR TO SECOND";
            }
            case 105: {
                return "MINUTE";
            }
            case 113: {
                return "MINUTE TO SECOND";
            }
            case 106: {
                return "SECOND";
            }
        }
        throw Error.runtimeError(201, "IntervalType");
    }

    public String getDefinition() {
        if (this.precision == 2L && (this.endIntervalType != 106 || this.scale == 6)) {
            return this.getNameString();
        }
        StringBuffer sb = new StringBuffer(32);
        sb.append("INTERVAL").append(' ');
        sb.append(IntervalType.getQualifier(this.startIntervalType));
        if (this.typeCode == 106) {
            sb.append('(');
            sb.append(this.precision);
            if (this.scale != 6) {
                sb.append(',');
                sb.append(this.scale);
            }
            sb.append(')');
            return sb.toString();
        }
        if (this.precision != 2L) {
            sb.append('(');
            sb.append(this.precision);
            sb.append(')');
        }
        if (this.startIntervalType != this.endIntervalType) {
            sb.append(' ');
            sb.append("TO");
            sb.append(' ');
            sb.append(Tokens.SQL_INTERVAL_FIELD_NAMES[this.endPartIndex]);
            if (this.endIntervalType == 106 && this.scale != 6) {
                sb.append('(');
                sb.append(this.scale);
                sb.append(')');
            }
        }
        return sb.toString();
    }

    public boolean isIntervalType() {
        return true;
    }

    public boolean isYearMonthIntervalType() {
        switch (this.typeCode) {
            case 101: 
            case 102: 
            case 107: {
                return true;
            }
        }
        return false;
    }

    public boolean isDaySecondIntervalType() {
        switch (this.typeCode) {
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: {
                return true;
            }
        }
        return false;
    }

    public boolean acceptsPrecision() {
        return true;
    }

    public boolean acceptsFractionalPrecision() {
        return this.endIntervalType == 106;
    }

    public Type getAggregateType(Type other) {
        if (this.typeCode == other.typeCode) {
            if (this.precision >= other.precision && this.scale >= other.scale) {
                return this;
            }
            if (this.precision <= other.precision && this.scale <= other.scale) {
                return other;
            }
        }
        if (other == SQL_ALL_TYPES) {
            return this;
        }
        if (other.isCharacterType()) {
            return other.getAggregateType(this);
        }
        if (!other.isIntervalType()) {
            throw Error.error(5562);
        }
        int startType = ((IntervalType)other).startIntervalType > this.startIntervalType ? this.startIntervalType : ((IntervalType)other).startIntervalType;
        int endType = ((IntervalType)other).endIntervalType > this.endIntervalType ? ((IntervalType)other).endIntervalType : this.endIntervalType;
        int newType = IntervalType.getCombinedIntervalType(startType, endType);
        long newPrecision = this.precision > other.precision ? this.precision : other.precision;
        int newScale = this.scale > other.scale ? this.scale : other.scale;
        try {
            return IntervalType.getIntervalType(newType, startType, endType, newPrecision, newScale, false);
        }
        catch (RuntimeException e) {
            throw Error.error(5562);
        }
    }

    public Type getCombinedType(Type other, int operation) {
        switch (operation) {
            case 34: {
                if (!other.isNumberType()) break;
                return IntervalType.getIntervalType(this, 9L, this.scale);
            }
            case 35: {
                if (!other.isNumberType()) break;
                return this;
            }
            case 32: {
                if (other.isDateTimeType()) {
                    return other.getCombinedType(this, operation);
                }
                if (!other.isIntervalType()) break;
                IntervalType newType = (IntervalType)this.getAggregateType(other);
                return IntervalType.getIntervalType(newType, 9L, 0);
            }
            default: {
                return this.getAggregateType(other);
            }
        }
        throw Error.error(5562);
    }

    public int compare(Session session, Object a, Object b) {
        if (a == b) {
            return 0;
        }
        if (a == null) {
            return -1;
        }
        if (b == null) {
            return 1;
        }
        switch (this.typeCode) {
            case 101: 
            case 102: 
            case 107: {
                return ((IntervalMonthData)a).compareTo((IntervalMonthData)b);
            }
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: {
                return ((IntervalSecondData)a).compareTo((IntervalSecondData)b);
            }
        }
        throw Error.runtimeError(201, "IntervalType");
    }

    public Object convertToTypeLimits(SessionInterface session, Object a) {
        if (a == null) {
            return null;
        }
        if (a instanceof IntervalMonthData) {
            IntervalMonthData im = (IntervalMonthData)a;
            if (im.units > this.getIntervalValueLimit()) {
                throw Error.error(3435);
            }
        } else if (a instanceof IntervalSecondData) {
            IntervalSecondData is = (IntervalSecondData)a;
            if (is.units > this.getIntervalValueLimit()) {
                throw Error.error(3435);
            }
        }
        return a;
    }

    public Object convertToType(SessionInterface session, Object a, Type otherType) {
        if (a == null) {
            return null;
        }
        switch (otherType.typeCode) {
            case 40: {
                a = a.toString();
            }
            case 1: 
            case 12: 
            case 100: {
                return session.getScanner().convertToDatetimeInterval(session, (String)a, this);
            }
            case -6: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 25: {
                if (a instanceof BigDecimal && !NumberType.isInLongLimits((BigDecimal)a)) {
                    throw Error.error(3435);
                }
                long value = ((Number)a).longValue();
                switch (this.endIntervalType) {
                    case 101: {
                        return IntervalMonthData.newIntervalYear(value, this);
                    }
                    case 102: {
                        return IntervalMonthData.newIntervalMonth(value, this);
                    }
                    case 103: {
                        return IntervalSecondData.newIntervalDay(value, this);
                    }
                    case 104: {
                        return IntervalSecondData.newIntervalHour(value, this);
                    }
                    case 105: {
                        return IntervalSecondData.newIntervalMinute(value, this);
                    }
                    case 106: {
                        int nanos = 0;
                        if (this.scale > 0 && a instanceof BigDecimal) {
                            nanos = (int)NumberType.scaledDecimal(a, 9);
                        }
                        return new IntervalSecondData(value, nanos, this);
                    }
                }
                throw Error.error(5561);
            }
            case 101: {
                long months = ((IntervalMonthData)a).units / 12L * 12L;
                return new IntervalMonthData(months, this);
            }
            case 102: 
            case 107: {
                long months = ((IntervalMonthData)a).units;
                return new IntervalMonthData(months, this);
            }
            case 103: {
                long seconds = ((IntervalSecondData)a).units;
                seconds = seconds / (long)DTIType.yearToSecondFactors[2] * (long)DTIType.yearToSecondFactors[2];
                return new IntervalSecondData(seconds, 0, this);
            }
            case 104: 
            case 105: 
            case 108: 
            case 109: 
            case 111: {
                long seconds = ((IntervalSecondData)a).units;
                seconds = seconds / (long)DTIType.yearToSecondFactors[this.endPartIndex] * (long)DTIType.yearToSecondFactors[this.endPartIndex];
                return new IntervalSecondData(seconds, 0, this);
            }
            case 106: 
            case 110: 
            case 112: 
            case 113: {
                long seconds = ((IntervalSecondData)a).units;
                int nanos = ((IntervalSecondData)a).nanos;
                nanos = this.scale == 0 ? 0 : nanos / DTIType.nanoScaleFactors[this.scale] * DTIType.nanoScaleFactors[this.scale];
                return new IntervalSecondData(seconds, nanos, this);
            }
        }
        throw Error.error(5561);
    }

    public Object convertToDefaultType(SessionInterface session, Object a) {
        if (a == null) {
            return null;
        }
        if (a instanceof String) {
            return this.convertToType(session, a, Type.SQL_VARCHAR);
        }
        if (a instanceof Integer) {
            return this.convertToType(session, a, Type.SQL_INTEGER);
        }
        if (a instanceof Long) {
            return this.convertToType(session, a, Type.SQL_BIGINT);
        }
        if (a instanceof BigDecimal) {
            return this.convertToType(session, a, Type.SQL_DECIMAL);
        }
        throw Error.error(5561);
    }

    public String convertToString(Object a) {
        if (a == null) {
            return null;
        }
        switch (this.typeCode) {
            case 101: 
            case 102: 
            case 107: {
                return this.intervalMonthToString(a);
            }
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: {
                return this.intervalSecondToString(a);
            }
        }
        throw Error.runtimeError(201, "IntervalType");
    }

    public String convertToSQLString(Object a) {
        if (a == null) {
            return "NULL";
        }
        StringBuffer sb = new StringBuffer(32);
        sb.append("INTERVAL").append(' ');
        sb.append('\'').append(this.convertToString(a)).append('\'').append(' ');
        sb.append(Tokens.SQL_INTERVAL_FIELD_NAMES[this.startPartIndex]);
        sb.append(' ');
        sb.append("TO");
        sb.append(' ');
        sb.append(Tokens.SQL_INTERVAL_FIELD_NAMES[this.endPartIndex]);
        return sb.toString();
    }

    public boolean canConvertFrom(Type otherType) {
        if (otherType.typeCode == 0) {
            return true;
        }
        if (otherType.isCharacterType()) {
            return true;
        }
        if (otherType.isNumberType()) {
            return true;
        }
        if (!otherType.isIntervalType()) {
            return false;
        }
        return !(this.isYearMonthIntervalType() ^ ((IntervalType)otherType).isYearMonthIntervalType());
    }

    public int canMoveFrom(Type otherType) {
        if (otherType == this) {
            return 0;
        }
        if (this.typeCode == otherType.typeCode) {
            return this.scale >= otherType.scale ? 0 : -1;
        }
        if (!otherType.isIntervalType()) {
            return -1;
        }
        if (this.isYearMonth == ((IntervalType)otherType).isYearMonth) {
            if (this.scale < otherType.scale) {
                return -1;
            }
            if (this.endPartIndex >= ((IntervalType)otherType).endPartIndex) {
                if (this.precision >= otherType.precision && this.startPartIndex <= ((IntervalType)otherType).startPartIndex) {
                    return 0;
                }
                return 1;
            }
        }
        return -1;
    }

    public int compareToTypeRange(Object o) {
        long units;
        long max = precisionLimits[(int)this.precision];
        if (o instanceof IntervalMonthData) {
            units = ((IntervalMonthData)o).units;
        } else if (o instanceof IntervalSecondData) {
            units = ((IntervalSecondData)o).units;
        } else {
            return 0;
        }
        if (units >= max) {
            return 1;
        }
        if (units < 0L && -units >= max) {
            return -1;
        }
        return 0;
    }

    public Object absolute(Object a) {
        if (a == null) {
            return null;
        }
        if (a instanceof IntervalMonthData ? ((IntervalMonthData)a).units < 0L : ((IntervalSecondData)a).units < 0L || ((IntervalSecondData)a).nanos < 0) {
            return this.negate(a);
        }
        return a;
    }

    public Object negate(Object a) {
        if (a == null) {
            return null;
        }
        if (a instanceof IntervalMonthData) {
            long units = ((IntervalMonthData)a).units;
            return new IntervalMonthData(-units, this);
        }
        long units = ((IntervalSecondData)a).units;
        int nanos = ((IntervalSecondData)a).nanos;
        return new IntervalSecondData(-units, -nanos, this, true);
    }

    public Object add(Object a, Object b, Type otherType) {
        if (a == null || b == null) {
            return null;
        }
        switch (this.typeCode) {
            case 101: 
            case 102: 
            case 107: {
                long months = ((IntervalMonthData)a).units + ((IntervalMonthData)b).units;
                return new IntervalMonthData(months, this);
            }
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: {
                long seconds = ((IntervalSecondData)a).units + ((IntervalSecondData)b).units;
                long nanos = ((IntervalSecondData)a).nanos + ((IntervalSecondData)b).nanos;
                return new IntervalSecondData(seconds, nanos, this, true);
            }
        }
        throw Error.runtimeError(201, "IntervalType");
    }

    public Object subtract(Object a, Object b, Type otherType) {
        if (a == null || b == null) {
            return null;
        }
        switch (this.typeCode) {
            case 101: 
            case 102: 
            case 107: {
                if (a instanceof IntervalMonthData && b instanceof IntervalMonthData) {
                    long months = ((IntervalMonthData)a).units - ((IntervalMonthData)b).units;
                    return new IntervalMonthData(months, this);
                }
                if (a instanceof TimestampData && b instanceof TimestampData) {
                    boolean isYear = this.typeCode == 101;
                    long months = DateTimeType.subtractMonths((TimestampData)a, (TimestampData)b, isYear);
                    return new IntervalMonthData(months, this);
                }
                throw Error.runtimeError(201, "IntervalType");
            }
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: {
                if (a instanceof IntervalSecondData && b instanceof IntervalSecondData) {
                    long seconds = ((IntervalSecondData)a).units - ((IntervalSecondData)b).units;
                    long nanos = ((IntervalSecondData)a).nanos - ((IntervalSecondData)b).nanos;
                    return new IntervalSecondData(seconds, nanos, this, true);
                }
                if (a instanceof TimeData && b instanceof TimeData) {
                    long seconds = ((TimeData)a).getSeconds() - ((TimeData)b).getSeconds();
                    long nanos = ((TimeData)a).getNanos() - ((TimeData)b).getNanos();
                    return new IntervalSecondData(seconds, nanos, this, true);
                }
                if (!(a instanceof TimestampData) || !(b instanceof TimestampData)) break;
                long seconds = ((TimestampData)a).getSeconds() - ((TimestampData)b).getSeconds();
                long nanos = ((TimestampData)a).getNanos() - ((TimestampData)b).getNanos();
                return new IntervalSecondData(seconds, nanos, this, true);
            }
        }
        throw Error.runtimeError(201, "IntervalType");
    }

    public Object multiply(Object a, Object b) {
        return this.multiplyOrDivide(a, b, false);
    }

    public Object divide(Session session, Object a, Object b) {
        return this.multiplyOrDivide(a, b, true);
    }

    private Object multiplyOrDivide(Object a, Object b, boolean divide) {
        BigDecimal result;
        BigDecimal units;
        if (a == null || b == null) {
            return null;
        }
        if (a instanceof Number) {
            Object temp = a;
            a = b;
            b = temp;
        }
        if (divide && NumberType.isZero(b)) {
            throw Error.error(3432);
        }
        NumberType factorType = NumberType.getNumberType(3, 40L, 9);
        BigDecimal factor = (BigDecimal)factorType.convertToDefaultType(null, b);
        if (this.isYearMonth) {
            units = BigDecimal.valueOf(((IntervalMonthData)a).units);
        } else {
            long value = ((IntervalSecondData)a).units * (long)DTIType.nanoScaleFactors[0] + (long)((IntervalSecondData)a).nanos;
            units = BigDecimal.valueOf(value, 9);
        }
        BigDecimal bigDecimal = result = divide ? (BigDecimal)factorType.divide(null, units, factor) : (BigDecimal)factorType.multiply(units, factor);
        if (!NumberType.isInLongLimits(result)) {
            throw Error.error(3435);
        }
        if (this.isYearMonth) {
            return new IntervalMonthData(result.longValue(), this);
        }
        int nanos = (int)NumberType.scaledDecimal(result, 9);
        return new IntervalSecondData(result.longValue(), nanos, this, true);
    }

    String intervalMonthToString(Object a) {
        StringBuffer sb = new StringBuffer(8);
        long months = ((IntervalMonthData)a).units;
        if (months < 0L) {
            months = -months;
            sb.append('-');
        }
        for (int i = this.startPartIndex; i <= this.endPartIndex; ++i) {
            int factor = DTIType.yearToSecondFactors[i];
            long part = months / (long)factor;
            if (i == this.startPartIndex) {
                int zeros = (int)this.precision - IntervalType.getPrecisionExponent(part);
            } else if (part < 10L) {
                sb.append('0');
            }
            sb.append(part);
            months %= (long)factor;
            if (i >= this.endPartIndex) continue;
            sb.append((char)DTIType.yearToSecondSeparators[i]);
        }
        return sb.toString();
    }

    String intervalSecondToString(Object a) {
        long seconds = ((IntervalSecondData)a).units;
        int nanos = ((IntervalSecondData)a).nanos;
        return this.intervalSecondToString(seconds, nanos, false);
    }

    public int precedenceDegree(Type other) {
        if (other.isIntervalType()) {
            int otherIndex = ((IntervalType)other).endPartIndex;
            return otherIndex - this.endPartIndex;
        }
        return Integer.MIN_VALUE;
    }

    public int getStartIntervalType() {
        return this.startIntervalType;
    }

    public int getEndIntervalType() {
        return this.endIntervalType;
    }

    public static IntervalType newIntervalType(int type, long precision, int fractionPrecision) {
        int startType = IntervalType.getStartIntervalType(type);
        int endType = IntervalType.getEndIntervalType(type);
        int group = startType > 102 ? 106 : 102;
        return new IntervalType(group, type, precision, fractionPrecision, startType, endType, false);
    }

    public static IntervalType getIntervalType(IntervalType type, long precision, int fractionalPrecision) {
        if (type.precision >= precision && type.scale >= fractionalPrecision) {
            return type;
        }
        return IntervalType.getIntervalType(type.typeCode, precision, fractionalPrecision);
    }

    public static IntervalType getIntervalType(int type, long precision, int fractionPrecision) {
        int startType = IntervalType.getStartIntervalType(type);
        int endType = IntervalType.getEndIntervalType(type);
        return IntervalType.getIntervalType(type, startType, endType, precision, fractionPrecision, false);
    }

    public static IntervalType getIntervalType(int startIndex, int endIndex, long precision, int fractionPrecision) {
        boolean defaultPrecision;
        boolean bl = defaultPrecision = precision == -1L;
        if (startIndex == -1 || endIndex == -1) {
            throw Error.error(3406);
        }
        if (startIndex > endIndex) {
            throw Error.error(3406);
        }
        if (startIndex <= 1 && endIndex > 1) {
            throw Error.error(3406);
        }
        int startType = DTIType.intervalParts[startIndex];
        int endType = DTIType.intervalParts[endIndex];
        int type = DTIType.intervalTypes[startIndex][endIndex];
        if (precision == 0L || precision > 9L || fractionPrecision > 9) {
            throw Error.error(5592);
        }
        if (precision == -1L) {
            precision = 2L;
        }
        if (fractionPrecision == -1) {
            fractionPrecision = endType == 106 ? 6 : 0;
        }
        return IntervalType.getIntervalType(type, startType, endType, precision, fractionPrecision, defaultPrecision);
    }

    public static IntervalType getIntervalType(int type, int startType, int endType, long precision, int fractionPrecision, boolean defaultPrecision) {
        int group;
        int n = group = startType > 102 ? 106 : 102;
        if (defaultPrecision) {
            return new IntervalType(group, type, precision, fractionPrecision, startType, endType, defaultPrecision);
        }
        switch (type) {
            case 101: {
                if (precision != 2L) break;
                return SQL_INTERVAL_YEAR;
            }
            case 107: {
                if (precision != 2L) break;
                return SQL_INTERVAL_YEAR_TO_MONTH;
            }
            case 102: {
                if (precision != 2L) break;
                return SQL_INTERVAL_MONTH;
            }
            case 103: {
                if (precision != 2L) break;
                return SQL_INTERVAL_DAY;
            }
            case 108: {
                if (precision != 2L) break;
                return SQL_INTERVAL_DAY_TO_HOUR;
            }
            case 109: {
                if (precision != 2L) break;
                return SQL_INTERVAL_DAY_TO_MINUTE;
            }
            case 110: {
                if (precision != 2L || fractionPrecision != 6) break;
                return SQL_INTERVAL_DAY_TO_SECOND;
            }
            case 104: {
                if (precision != 2L) break;
                return SQL_INTERVAL_HOUR;
            }
            case 111: {
                if (precision != 2L) break;
                return SQL_INTERVAL_HOUR_TO_MINUTE;
            }
            case 105: {
                if (precision != 2L) break;
                return SQL_INTERVAL_MINUTE;
            }
            case 112: {
                if (precision != 2L || fractionPrecision != 6) break;
                return SQL_INTERVAL_HOUR_TO_SECOND;
            }
            case 113: {
                if (precision != 2L || fractionPrecision != 6) break;
                return SQL_INTERVAL_MINUTE_TO_SECOND;
            }
            case 106: {
                if (precision != 2L || fractionPrecision != 6) break;
                return SQL_INTERVAL_SECOND;
            }
            default: {
                throw Error.runtimeError(201, "IntervalType");
            }
        }
        return new IntervalType(group, type, precision, fractionPrecision, startType, endType, defaultPrecision);
    }

    public static int getStartIntervalType(int type) {
        int startType;
        switch (type) {
            case 101: 
            case 107: {
                startType = 101;
                break;
            }
            case 102: {
                startType = 102;
                break;
            }
            case 103: 
            case 108: 
            case 109: 
            case 110: {
                startType = 103;
                break;
            }
            case 104: 
            case 111: 
            case 112: {
                startType = 104;
                break;
            }
            case 105: 
            case 113: {
                startType = 105;
                break;
            }
            case 106: {
                startType = 106;
                break;
            }
            default: {
                throw Error.runtimeError(201, "IntervalType");
            }
        }
        return startType;
    }

    public static int getEndIntervalType(int type) {
        int endType;
        switch (type) {
            case 101: {
                endType = 101;
                break;
            }
            case 107: {
                endType = 102;
                break;
            }
            case 102: {
                endType = 102;
                break;
            }
            case 103: {
                endType = 103;
                break;
            }
            case 108: {
                endType = 104;
                break;
            }
            case 109: {
                endType = 105;
                break;
            }
            case 110: {
                endType = 106;
                break;
            }
            case 104: {
                endType = 104;
                break;
            }
            case 111: {
                endType = 105;
                break;
            }
            case 112: {
                endType = 106;
                break;
            }
            case 105: {
                endType = 105;
                break;
            }
            case 113: {
                endType = 106;
                break;
            }
            case 106: {
                endType = 106;
                break;
            }
            default: {
                throw Error.runtimeError(201, "IntervalType");
            }
        }
        return endType;
    }

    public static Type getCombinedIntervalType(IntervalType type1, IntervalType type2) {
        int startType = type2.startIntervalType > type1.startIntervalType ? type1.startIntervalType : type2.startIntervalType;
        int endType = type2.endIntervalType > type1.endIntervalType ? type2.endIntervalType : type1.endIntervalType;
        int type = IntervalType.getCombinedIntervalType(startType, endType);
        long precision = type1.precision > type2.precision ? type1.precision : type2.precision;
        int fractionPrecision = type1.scale > type2.scale ? type1.scale : type2.scale;
        return IntervalType.getIntervalType(type, startType, endType, precision, fractionPrecision, false);
    }

    public static int getCombinedIntervalType(int startType, int endType) {
        if (startType == endType) {
            return startType;
        }
        switch (startType) {
            case 101: {
                if (endType != 102) break;
                return 107;
            }
            case 103: {
                switch (endType) {
                    case 104: {
                        return 108;
                    }
                    case 105: {
                        return 109;
                    }
                    case 106: {
                        return 110;
                    }
                }
                break;
            }
            case 104: {
                switch (endType) {
                    case 105: {
                        return 111;
                    }
                    case 106: {
                        return 112;
                    }
                }
                break;
            }
            case 105: {
                if (endType != 106) break;
                return 113;
            }
        }
        throw Error.runtimeError(201, "IntervalType");
    }

    public static int getIntervalType(String part) {
        int index = ArrayUtil.find(Tokens.SQL_INTERVAL_FIELD_NAMES, part);
        if (index < 0) {
            throw Error.error(5562);
        }
        return intervalParts[index];
    }

    long getIntervalValueLimit() {
        long limit;
        switch (this.typeCode) {
            case 101: {
                limit = DTIType.precisionLimits[(int)this.precision] * 12L;
                break;
            }
            case 107: {
                limit = DTIType.precisionLimits[(int)this.precision] * 12L;
                limit += 12L;
                break;
            }
            case 102: {
                limit = DTIType.precisionLimits[(int)this.precision];
                break;
            }
            case 103: {
                limit = DTIType.precisionLimits[(int)this.precision] * 24L * 60L * 60L;
                break;
            }
            case 108: {
                limit = DTIType.precisionLimits[(int)this.precision] * 24L * 60L * 60L;
                break;
            }
            case 109: {
                limit = DTIType.precisionLimits[(int)this.precision] * 24L * 60L * 60L;
                break;
            }
            case 110: {
                limit = DTIType.precisionLimits[(int)this.precision] * 24L * 60L * 60L;
                break;
            }
            case 104: {
                limit = DTIType.precisionLimits[(int)this.precision] * 60L * 60L;
                break;
            }
            case 111: {
                limit = DTIType.precisionLimits[(int)this.precision] * 60L * 60L;
                break;
            }
            case 112: {
                limit = DTIType.precisionLimits[(int)this.precision] * 60L * 60L;
                break;
            }
            case 105: {
                limit = DTIType.precisionLimits[(int)this.precision] * 60L;
                break;
            }
            case 113: {
                limit = DTIType.precisionLimits[(int)this.precision] * 60L;
                break;
            }
            case 106: {
                limit = DTIType.precisionLimits[(int)this.precision];
                break;
            }
            default: {
                throw Error.runtimeError(201, "IntervalType");
            }
        }
        return limit;
    }

    public int getPart(Session session, Object interval, int part) {
        switch (part) {
            case 101: {
                return (int)(((IntervalMonthData)interval).units / 12L);
            }
            case 102: {
                long units = ((IntervalMonthData)interval).units;
                return part == this.startIntervalType ? (int)units : (int)(units % 12L);
            }
            case 103: {
                return (int)(((IntervalSecondData)interval).units / 86400L);
            }
            case 104: {
                long units = ((IntervalSecondData)interval).units / 3600L;
                return part == this.startIntervalType ? (int)units : (int)(units % 24L);
            }
            case 105: {
                long units = ((IntervalSecondData)interval).units / 60L;
                return part == this.startIntervalType ? (int)units : (int)(units % 60L);
            }
            case 106: {
                long units = ((IntervalSecondData)interval).units;
                return part == this.startIntervalType ? (int)units : (int)(units % 60L);
            }
        }
        throw Error.runtimeError(201, "IntervalType");
    }

    public long getSeconds(Object interval) {
        return ((IntervalSecondData)interval).units;
    }

    public BigDecimal getSecondPart(Object interval) {
        long seconds = ((IntervalSecondData)interval).units;
        if (this.typeCode != 106) {
            seconds %= 60L;
        }
        int nanos = ((IntervalSecondData)interval).nanos;
        return this.getSecondPart(seconds, nanos);
    }

    public long convertToLong(Object interval) {
        switch (this.endIntervalType) {
            case 101: 
            case 102: {
                long months = ((IntervalMonthData)interval).units;
                return months / (long)DTIType.yearToSecondFactors[this.endPartIndex];
            }
            case 103: 
            case 104: 
            case 105: 
            case 106: {
                long seconds = ((IntervalSecondData)interval).units;
                return seconds / (long)DTIType.yearToSecondFactors[this.endPartIndex];
            }
        }
        throw Error.runtimeError(201, "IntervalType");
    }

    public CharacterType getCharacterType() {
        CharacterType type = CharacterType.getCharacterType(12, this.displaySize());
        type.nameString = this.getNameString();
        return type;
    }
}

