/*
 * Decompiled with CFR 0.152.
 */
package org.portletbridge.web;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.beanutils.BeanMap;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.NTCredentials;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.params.HttpConnectionManagerParams;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.Serializer;
import org.apache.xml.serialize.SerializerFactory;
import org.portletbridge.rewriter.FullUrlRewriter;
import org.portletbridge.rewriter.RegExStyleSheetRewriter;
import org.portletbridge.xsl.LinkRewriterXmlFilter;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class ProxyHttpServlet
extends HttpServlet {
    private static final long serialVersionUID = 7594239856795649323L;
    private static final Log log = LogFactory.getLog((Class)(class$org$portletbridge$web$ProxyHttpServlet == null ? (class$org$portletbridge$web$ProxyHttpServlet = ProxyHttpServlet.class$("org.portletbridge.web.ProxyHttpServlet")) : class$org$portletbridge$web$ProxyHttpServlet));
    private HttpClient client = null;
    private String httpStateSessionKey = (class$org$portletbridge$web$ProxyHttpServlet == null ? (class$org$portletbridge$web$ProxyHttpServlet = ProxyHttpServlet.class$("org.portletbridge.web.ProxyHttpServlet")) : class$org$portletbridge$web$ProxyHttpServlet) + ".httpStateSessionKey";
    private XMLReader parser = null;
    private String configProxyEnabled = null;
    private String configProxyHost = null;
    private String configProxyPort = null;
    private String configProxyAuthentication = null;
    private String configProxyAuthenticationUsername = null;
    private String configProxyAuthenticationPassword = null;
    private String configProxyAuthenticationHost = null;
    private String configProxyAuthenticationDomain = null;
    private String configConnectionTimeout = null;
    private String configConnectionMaxTotal = null;
    private String configConnectionMaxPerHost = null;
    private static Set BLOCK_REQUEST_HEADERS = new HashSet();
    private static Set BLOCK_RESPONSE_HEADERS = new HashSet();
    static /* synthetic */ Class class$org$portletbridge$web$ProxyHttpServlet;

    public void init() throws ServletException {
        try {
            this.initProperties();
        }
        catch (IllegalAccessException e1) {
            throw new ServletException((Throwable)e1);
        }
        catch (InvocationTargetException e1) {
            throw new ServletException((Throwable)e1);
        }
        MultiThreadedHttpConnectionManager connectionManager = new MultiThreadedHttpConnectionManager();
        HttpConnectionManagerParams httpConnectionManagerParams = new HttpConnectionManagerParams();
        if (this.configConnectionTimeout != null) {
            httpConnectionManagerParams.setConnectionTimeout(Integer.parseInt(this.configConnectionTimeout));
        }
        if (this.configConnectionMaxTotal != null) {
            httpConnectionManagerParams.setMaxTotalConnections(Integer.parseInt(this.configConnectionMaxTotal));
        }
        connectionManager.setParams(httpConnectionManagerParams);
        this.client = new HttpClient((HttpConnectionManager)connectionManager);
        if (this.configConnectionMaxPerHost != null) {
            httpConnectionManagerParams.setMaxConnectionsPerHost(this.client.getHostConfiguration(), Integer.parseInt(this.configConnectionMaxPerHost));
        }
        if (this.configProxyEnabled != null && Boolean.valueOf(this.configProxyEnabled).booleanValue()) {
            this.client.getHostConfiguration().setProxy(this.configProxyHost, Integer.parseInt(this.configProxyPort));
        }
        try {
            this.parser = XMLReaderFactory.createXMLReader("org.cyberneko.html.parsers.SAXParser");
            this.parser.setFeature("http://cyberneko.org/html/features/balance-tags", true);
        }
        catch (SAXNotRecognizedException e) {
            throw new ServletException((Throwable)e);
        }
        catch (SAXNotSupportedException e) {
            throw new ServletException((Throwable)e);
        }
        catch (SAXException e) {
            throw new ServletException((Throwable)e);
        }
    }

    protected void initProperties() throws IllegalAccessException, InvocationTargetException {
        BeanMap map = new BeanMap((Object)this);
        String servletName = this.getServletConfig().getServletName();
        log.debug((Object)servletName);
        Iterator iter = map.keyIterator();
        while (iter.hasNext()) {
            String property = (String)iter.next();
            String initParameter = this.getServletContext().getInitParameter(servletName + "." + property);
            if (initParameter == null) continue;
            log.debug((Object)(property + "=" + initParameter));
            BeanUtils.setProperty((Object)((Object)this), (String)property, (Object)initParameter);
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String queryString = request.getQueryString();
        String url = request.getRequestURI().substring(request.getContextPath().length() + 1) + (queryString != null ? '?' + queryString : "");
        log.debug((Object)url);
        GetMethod getMethod = new GetMethod(url);
        this.process(request, response, (HttpMethodBase)getMethod);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String queryString = request.getQueryString();
        String url = request.getRequestURI().substring(request.getContextPath().length() + 1) + (queryString != null ? '?' + queryString : "");
        log.debug((Object)url);
        PostMethod postMethod = new PostMethod(url);
        this.process(request, response, (HttpMethodBase)postMethod);
    }

    protected void doHead(HttpServletRequest arg0, HttpServletResponse arg1) throws ServletException, IOException {
        throw new ServletException("HEAD Unsupported");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void process(HttpServletRequest request, HttpServletResponse response, HttpMethodBase method) throws ServletException, IOException {
        String methodUrl;
        long startTime;
        block23: {
            startTime = System.currentTimeMillis();
            methodUrl = method.getURI().toString();
            try {
                InputStream responseBodyAsStream;
                Object headerValue;
                HttpSession session = request.getSession(true);
                int statusCode = 0;
                FullUrlRewriter fullUrlRewriter = new FullUrlRewriter(methodUrl, request.getRequestURI());
                RegExStyleSheetRewriter styleSheetRewriter = new RegExStyleSheetRewriter(fullUrlRewriter);
                method.setFollowRedirects(false);
                Enumeration headerNames = request.getHeaderNames();
                while (headerNames.hasMoreElements()) {
                    String headerName = (String)headerNames.nextElement();
                    if (BLOCK_REQUEST_HEADERS.contains(headerName.toLowerCase())) continue;
                    headerValue = request.getHeader(headerName);
                    log.debug((Object)("RequestHeader:" + headerName + "=" + (String)headerValue));
                    method.setRequestHeader(headerName, (String)headerValue);
                }
                HttpState state = null;
                headerValue = session;
                synchronized (headerValue) {
                    state = (HttpState)session.getAttribute(this.httpStateSessionKey);
                    if (state == null) {
                        state = this.createState();
                        session.setAttribute(this.httpStateSessionKey, (Object)state);
                    }
                }
                statusCode = this.client.executeMethod(this.client.getHostConfiguration(), (HttpMethod)method, state);
                response.setStatus(statusCode);
                Header[] responseHeaders = method.getResponseHeaders();
                for (int i = 0; i < responseHeaders.length; ++i) {
                    Header header = responseHeaders[i];
                    String headerName = header.getName();
                    if (BLOCK_RESPONSE_HEADERS.contains(headerName.toLowerCase())) continue;
                    String headerValue2 = header.getValue();
                    log.debug((Object)("ResponseHeader:" + headerName + "=" + headerValue2));
                    response.setHeader(headerName, headerValue2);
                }
                if ((int)Math.floor(statusCode / 100) == 3) {
                    Header responseHeader = method.getResponseHeader("Location");
                    if (responseHeader != null) {
                        response.setHeader("Location", fullUrlRewriter.rewrite(responseHeader.getValue()));
                    }
                    break block23;
                }
                Header responseHeader = method.getResponseHeader("Content-Type");
                String contentType = responseHeader.getValue();
                if (contentType.indexOf("text/html") != -1) {
                    PrintWriter responseWriter = response.getWriter();
                    responseBodyAsStream = method.getResponseBodyAsStream();
                    SerializerFactory factory = SerializerFactory.getSerializerFactory((String)"html");
                    Serializer writer = factory.makeSerializer(new OutputFormat());
                    writer.setOutputCharStream((Writer)responseWriter);
                    LinkRewriterXmlFilter filter = new LinkRewriterXmlFilter();
                    filter.setParent(this.parser);
                    filter.setContentHandler(writer.asContentHandler());
                    log.debug((Object)request.getRequestURI());
                    filter.setUrlRewriter(fullUrlRewriter);
                    filter.setStyleSheetRewriter(styleSheetRewriter);
                    try {
                        InputSource inputSource = new InputSource(responseBodyAsStream);
                        filter.parse(inputSource);
                        break block23;
                    }
                    catch (SAXException e) {
                        throw new ServletException((Throwable)e);
                    }
                    catch (IOException e) {
                        throw new ServletException((Throwable)e);
                    }
                    finally {
                        responseWriter.flush();
                        responseBodyAsStream.close();
                    }
                }
                if (contentType.indexOf("text/css") != -1) {
                    String responseBodyAsString = method.getResponseBodyAsString();
                    String rewrittenCss = styleSheetRewriter.rewrite(responseBodyAsString);
                    response.getWriter().write(rewrittenCss);
                } else {
                    BufferedOutputStream outputStream = new BufferedOutputStream((OutputStream)response.getOutputStream());
                    responseBodyAsStream = method.getResponseBodyAsStream();
                    BufferedInputStream in = new BufferedInputStream(responseBodyAsStream);
                    byte[] b = new byte[4096];
                    int i = -1;
                    while ((i = in.read(b)) != -1) {
                        outputStream.write(b, 0, i);
                    }
                    outputStream.flush();
                    responseBodyAsStream.close();
                }
            }
            catch (Throwable t) {
                log.warn((Object)t, t);
            }
            finally {
                method.releaseConnection();
            }
        }
        log.info((Object)(methodUrl + " finished in " + (System.currentTimeMillis() - startTime) + "ms"));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected HttpState createState() throws ServletException {
        HttpState state = new HttpState();
        if (this.configProxyEnabled == null || !Boolean.valueOf(this.configProxyEnabled).booleanValue()) return state;
        if (this.configProxyAuthentication == null) throw new ServletException("If configProxyEnabled is try, configProxyAuthentication must be set");
        if ("ntlm".equalsIgnoreCase(this.configProxyAuthentication)) {
            state.setProxyCredentials(AuthScope.ANY, (Credentials)new NTCredentials(this.configProxyAuthenticationUsername, this.configProxyAuthenticationPassword, this.configProxyAuthenticationHost, this.configProxyAuthenticationDomain));
            return state;
        } else {
            if (!"basic".equalsIgnoreCase(this.configProxyAuthentication) && !"digest".equalsIgnoreCase(this.configProxyAuthentication)) throw new ServletException("configProxyAuthentication can only be either 'basic' or 'ntlm'");
            state.setProxyCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(this.configProxyAuthenticationUsername, this.configProxyAuthenticationPassword));
        }
        return state;
    }

    public void setConfigConnectionMaxPerHost(String configConnectionMaxPerHost) {
        this.configConnectionMaxPerHost = configConnectionMaxPerHost;
    }

    public void setConfigConnectionMaxTotal(String configConnectionMaxTotal) {
        this.configConnectionMaxTotal = configConnectionMaxTotal;
    }

    public void setConfigConnectionTimeout(String configConnectionTimeout) {
        this.configConnectionTimeout = configConnectionTimeout;
    }

    public void setConfigProxyAuthentication(String configProxyAuthentication) {
        this.configProxyAuthentication = configProxyAuthentication;
    }

    public void setConfigProxyAuthenticationHost(String configProxyAuthenticationHost) {
        this.configProxyAuthenticationHost = configProxyAuthenticationHost;
    }

    public void setConfigProxyAuthenticationPassword(String configProxyAuthenticationPassword) {
        this.configProxyAuthenticationPassword = configProxyAuthenticationPassword;
    }

    public void setConfigProxyAuthenticationUsername(String configProxyAuthenticationUsername) {
        this.configProxyAuthenticationUsername = configProxyAuthenticationUsername;
    }

    public void setConfigProxyEnabled(String configProxyEnabled) {
        this.configProxyEnabled = configProxyEnabled;
    }

    public void setConfigProxyHost(String configProxyHost) {
        this.configProxyHost = configProxyHost;
    }

    public void setConfigProxyPort(String configProxyPort) {
        this.configProxyPort = configProxyPort;
    }

    public void setHttpStateSessionKey(String httpStateSessionKey) {
        this.httpStateSessionKey = httpStateSessionKey;
    }

    public String getConfigProxyAuthenticationDomain() {
        return this.configProxyAuthenticationDomain;
    }

    public void setConfigProxyAuthenticationDomain(String configProxyAuthenticationDomain) {
        this.configProxyAuthenticationDomain = configProxyAuthenticationDomain;
    }

    public String getConfigConnectionMaxPerHost() {
        return this.configConnectionMaxPerHost;
    }

    public String getConfigConnectionMaxTotal() {
        return this.configConnectionMaxTotal;
    }

    public String getConfigConnectionTimeout() {
        return this.configConnectionTimeout;
    }

    public String getConfigProxyAuthentication() {
        return this.configProxyAuthentication;
    }

    public String getConfigProxyAuthenticationHost() {
        return this.configProxyAuthenticationHost;
    }

    public String getConfigProxyAuthenticationPassword() {
        return this.configProxyAuthenticationPassword;
    }

    public String getConfigProxyAuthenticationUsername() {
        return this.configProxyAuthenticationUsername;
    }

    public String getConfigProxyEnabled() {
        return this.configProxyEnabled;
    }

    public String getConfigProxyHost() {
        return this.configProxyHost;
    }

    public String getConfigProxyPort() {
        return this.configProxyPort;
    }

    public String getHttpStateSessionKey() {
        return this.httpStateSessionKey;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        BLOCK_REQUEST_HEADERS.add("cookie");
        BLOCK_REQUEST_HEADERS.add("accept-encoding");
        BLOCK_REQUEST_HEADERS.add("connection");
        BLOCK_REQUEST_HEADERS.add("keep-alive");
        BLOCK_RESPONSE_HEADERS.add("connection");
        BLOCK_RESPONSE_HEADERS.add("proxy-connection");
        BLOCK_RESPONSE_HEADERS.add("content-length");
        BLOCK_RESPONSE_HEADERS.add("location");
        BLOCK_RESPONSE_HEADERS.add("set-cookie");
        BLOCK_RESPONSE_HEADERS.add("content-encoding");
        BLOCK_RESPONSE_HEADERS.add("transfer-encoding");
    }
}

