/*
 * Decompiled with CFR 0.152.
 */
package jodd.asm;

import jodd.mutable.MutableInteger;

public class AsmUtil {
    private static final String INVALID_BASE_TYPE = "Invalid base type: ";
    private static final String INVALID_TYPE_DESCRIPTION = "Invalid type description: ";

    public static String typedesc2ClassName(String desc) {
        String className = desc;
        switch (desc.charAt(0)) {
            case 'B': 
            case 'C': 
            case 'D': 
            case 'F': 
            case 'I': 
            case 'J': 
            case 'S': 
            case 'V': 
            case 'Z': {
                if (desc.length() == 1) break;
                throw new IllegalArgumentException(INVALID_BASE_TYPE + desc);
            }
            case 'L': {
                className = className.substring(1, className.length() - 1);
            }
            case '[': {
                className = className.replace('/', '.');
                break;
            }
            default: {
                throw new IllegalArgumentException(INVALID_TYPE_DESCRIPTION + desc);
            }
        }
        return className;
    }

    public static String typeref2Name(String desc) {
        if (desc.charAt(0) != 'L') {
            throw new IllegalArgumentException(INVALID_TYPE_DESCRIPTION + desc);
        }
        String name = desc.substring(1, desc.length() - 1);
        return name.replace('/', '.');
    }

    public static Class loadBaseTypeClass(String desc) throws ClassNotFoundException {
        if (desc.length() != 1) {
            throw new ClassNotFoundException(INVALID_BASE_TYPE + desc);
        }
        switch (desc.charAt(0)) {
            case 'B': {
                return Byte.TYPE;
            }
            case 'C': {
                return Character.TYPE;
            }
            case 'D': {
                return Double.TYPE;
            }
            case 'F': {
                return Float.TYPE;
            }
            case 'I': {
                return Integer.TYPE;
            }
            case 'J': {
                return Long.TYPE;
            }
            case 'S': {
                return Short.TYPE;
            }
            case 'Z': {
                return Boolean.TYPE;
            }
            case 'V': {
                return Void.TYPE;
            }
        }
        throw new ClassNotFoundException(INVALID_BASE_TYPE + desc);
    }

    public static String typedescToSignature(String desc) {
        return AsmUtil.typedescToSignature(desc, new MutableInteger());
    }

    public static String typedescToSignature(String desc, MutableInteger from) {
        int fromIndex = from.getValue();
        ++from.value;
        switch (desc.charAt(fromIndex)) {
            case 'B': {
                return "byte";
            }
            case 'C': {
                return "char";
            }
            case 'D': {
                return "double";
            }
            case 'F': {
                return "float";
            }
            case 'I': {
                return "int";
            }
            case 'J': {
                return "long";
            }
            case 'S': {
                return "short";
            }
            case 'Z': {
                return "boolean";
            }
            case 'V': {
                return "void";
            }
            case 'L': {
                int index = desc.indexOf(59, fromIndex);
                if (index < 0) {
                    throw new IllegalArgumentException(INVALID_TYPE_DESCRIPTION + desc);
                }
                from.setValue(index + 1);
                String str = desc.substring(fromIndex + 1, index);
                return str.replace('/', '.');
            }
            case '[': {
                StringBuilder brackets = new StringBuilder();
                int n = fromIndex;
                while (desc.charAt(n) == '[') {
                    brackets.append("[]");
                    ++n;
                }
                from.value = n;
                String type = AsmUtil.typedescToSignature(desc, from);
                return type + brackets;
            }
        }
        throw new IllegalArgumentException(INVALID_TYPE_DESCRIPTION + desc);
    }

    public static String typeToTyperef(Class type) {
        if (!type.isArray()) {
            if (!type.isPrimitive()) {
                return 'L' + type.getName().replace('.', '/') + ';';
            }
            if (type == Integer.TYPE) {
                return "I";
            }
            if (type == Long.TYPE) {
                return "J";
            }
            if (type == Boolean.TYPE) {
                return "Z";
            }
            if (type == Double.TYPE) {
                return "D";
            }
            if (type == Float.TYPE) {
                return "F";
            }
            if (type == Short.TYPE) {
                return "S";
            }
            if (type == Void.TYPE) {
                return "V";
            }
            if (type == Character.TYPE) {
                return "B";
            }
        }
        return type.getName();
    }
}

