/*
 * Decompiled with CFR 0.152.
 */
package jodd.introspector;

import java.lang.reflect.Field;
import java.util.HashMap;
import jodd.introspector.ClassDescriptor;
import jodd.introspector.FieldDescriptor;

class Fields {
    private final ClassDescriptor classDescriptor;
    private final HashMap<String, FieldDescriptor> fieldsMap;
    private int count;
    private Field[] allFields;

    Fields(ClassDescriptor classDescriptor, int maxFields) {
        this.classDescriptor = classDescriptor;
        this.fieldsMap = new HashMap(maxFields);
        this.count = 0;
    }

    void addField(String name, Field field) {
        this.fieldsMap.put(name, new FieldDescriptor(this.classDescriptor, field));
        this.allFields = null;
        ++this.count;
    }

    Field getField(String name) {
        FieldDescriptor fieldDescriptor = this.fieldsMap.get(name);
        if (fieldDescriptor == null) {
            return null;
        }
        return fieldDescriptor.getField();
    }

    FieldDescriptor getFieldDescriptor(String name) {
        return this.fieldsMap.get(name);
    }

    int getCount() {
        return this.count;
    }

    Field[] getAllFields() {
        if (this.allFields == null) {
            Field[] allFieldsNew = new Field[this.fieldsMap.size()];
            int ndx = 0;
            for (FieldDescriptor fieldDescriptor : this.fieldsMap.values()) {
                allFieldsNew[ndx] = fieldDescriptor.getField();
                ++ndx;
            }
            this.allFields = allFieldsNew;
        }
        return this.allFields;
    }
}

