/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.accounting.aggregator;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.gcube.accounting.datamodel.validations.validators.MatcherReplace;
import org.gcube.accounting.persistence.AccountingPersistenceConfiguration;
import org.gcube.com.fasterxml.jackson.databind.JavaType;
import org.gcube.com.fasterxml.jackson.databind.ObjectMapper;
import org.gcube.com.fasterxml.jackson.databind.type.CollectionType;
import org.gcube.documentstore.persistence.ExecutorUtils;
import org.gcube.documentstore.records.DSMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegexRulesAggregator
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(RegexRulesAggregator.class);
    public static final ScheduledExecutorService REGEX_REDISCOVERY_POOL = Executors.newScheduledThreadPool(50, new ThreadFactory(){
        private int counter = 0;
        private static final String prefix = "AggregationRegexRediscoveryThread";

        @Override
        public Thread newThread(Runnable r) {
            return new Thread(r, "AggregationRegexRediscoveryThread-" + this.counter++);
        }
    });
    protected static final String DELAY = "delay";
    protected static final String TIME_UNIT = "timeUnit";
    protected static final String MATCHER_REPLACE_RULES = "MatcherReplaceRules";
    protected TimeUnit timeUnit = TimeUnit.MINUTES;
    protected long delay = TimeUnit.MINUTES.toMinutes(15L);
    protected ScheduledFuture<?> rulesReloader;
    protected List<MatcherReplace> matcherReplaceList = new ArrayList<MatcherReplace>();
    protected AccountingPersistenceConfiguration accountingPersistenceConfiguration;
    protected static RegexRulesAggregator instance;
    protected boolean changeRate = false;
    protected ScheduledFuture<?> reloadAggregatorRules;

    public static synchronized RegexRulesAggregator getInstance() {
        if (instance == null) {
            instance = new RegexRulesAggregator();
        }
        return instance;
    }

    protected RegexRulesAggregator() {
        this.readConfiguration();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MatcherReplace> getMatcherReplaceList() {
        List<MatcherReplace> list = this.matcherReplaceList;
        synchronized (list) {
            return this.matcherReplaceList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MatcherReplace addMatcherReplace(MatcherReplace matcherReplace) {
        List<MatcherReplace> list = this.matcherReplaceList;
        synchronized (list) {
            this.matcherReplaceList.add(matcherReplace);
        }
        return matcherReplace;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void vacumRules() {
        List<MatcherReplace> list = this.matcherReplaceList;
        synchronized (list) {
            this.matcherReplaceList = new ArrayList<MatcherReplace>();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readConfiguration() {
        try {
            this.accountingPersistenceConfiguration = new AccountingPersistenceConfiguration(this.getClass());
            try {
                long oldDelay = this.delay;
                String delayString = this.accountingPersistenceConfiguration.getProperty(DELAY);
                this.delay = Long.parseLong(delayString);
                if (oldDelay != this.delay) {
                    this.changeRate = true;
                }
                TimeUnit oldTimeUnit = this.timeUnit;
                String timeUnitString = this.accountingPersistenceConfiguration.getProperty(TIME_UNIT);
                this.timeUnit = TimeUnit.valueOf(timeUnitString.toUpperCase());
                if (oldTimeUnit.ordinal() != this.timeUnit.ordinal()) {
                    this.changeRate = true;
                }
            }
            catch (Exception e) {
                logger.warn("Unable to retrieve regex reload delay. Goign to use last known delay {} {}", (Object)this.delay, (Object)this.timeUnit.name().toLowerCase());
            }
            String rulesString = this.accountingPersistenceConfiguration.getProperty(MATCHER_REPLACE_RULES);
            ObjectMapper mapper = DSMapper.getObjectMapper();
            CollectionType type = mapper.getTypeFactory().constructCollectionType(List.class, MatcherReplace.class);
            List rules = (List)mapper.readValue(rulesString, (JavaType)type);
            List<MatcherReplace> list = this.matcherReplaceList;
            synchronized (list) {
                this.matcherReplaceList = rules;
            }
        }
        catch (Exception e) {
            logger.error("Unable to properly load RegexRules", (Throwable)e);
        }
    }

    @Override
    public void run() {
        this.readConfiguration();
        if (this.changeRate) {
            this.stop();
        }
        if (this.reloadAggregatorRules == null) {
            this.reloadAggregatorRules = REGEX_REDISCOVERY_POOL.scheduleAtFixedRate(this, this.delay, this.delay, this.timeUnit);
        }
    }

    public void stop() {
        if (this.reloadAggregatorRules != null) {
            try {
                this.reloadAggregatorRules.cancel(true);
                this.reloadAggregatorRules = null;
            }
            catch (Throwable t) {
                logger.error("Unable to properly stop {} reloader", (Object)this.getClass().getSimpleName(), (Object)t);
            }
        }
    }

    @Deprecated
    public void start() {
    }

    public static void shutdown() {
        RegexRulesAggregator.getInstance().stop();
        ExecutorUtils.shutDownPool((ExecutorService)REGEX_REDISCOVERY_POOL);
    }
}

