/*
 * Decompiled with CFR 0.152.
 */
package org.apache.portals.bridges.struts;

import java.io.IOException;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.portals.bridges.struts.PortletServlet;
import org.apache.portals.bridges.struts.StrutsPortletRenderContext;
import org.apache.portals.bridges.struts.StrutsPortletURL;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.config.ActionConfig;

public class PortletServletRequestDispatcher
implements RequestDispatcher {
    private static final Log log = LogFactory.getLog((Class)PortletServletRequestDispatcher.class);
    private RequestDispatcher dispatcher;
    private String path;
    private boolean named;

    public PortletServletRequestDispatcher(RequestDispatcher dispatcher, String path, boolean named) {
        this.dispatcher = dispatcher;
        this.path = path;
        this.named = named;
    }

    private void invoke(ServletRequest request, ServletResponse response, boolean include) throws ServletException, IOException {
        String request_type = (String)request.getAttribute("org.apache.portals.bridges.struts.request_type");
        if (request_type != null && request_type.equals("ACTION")) {
            String originURL;
            if (log.isDebugEnabled()) {
                log.debug((Object)("saving " + (this.named ? "named " : " ") + "dispatch to :" + this.path + ", from " + request_type + " " + StrutsPortletURL.getPageURL(request)));
            }
            HttpServletRequest req = (HttpServletRequest)request;
            StrutsPortletRenderContext context = new StrutsPortletRenderContext();
            context.setPath(this.path);
            context.setDispatchNamed(this.named);
            ActionConfig actionConfig = (ActionConfig)request.getAttribute("org.apache.struts.action.mapping.instance");
            if (actionConfig != null && actionConfig.getAttribute() != null && actionConfig.getScope().equals("request")) {
                ActionForm actionForm = (ActionForm)request.getAttribute(actionConfig.getAttribute());
                context.setActionForm(actionForm);
                Boolean requestCancelled = (Boolean)request.getAttribute("org.apache.struts.action.CANCEL");
                if (requestCancelled != null && requestCancelled.booleanValue()) {
                    context.setRequestCancelled(true);
                }
            }
            context.setMessages((ActionMessages)request.getAttribute("org.apache.struts.action.ACTION_MESSAGE"));
            context.setErrors((ActionMessages)request.getAttribute("org.apache.struts.action.ERROR"));
            if (context.getErrors() != null && (originURL = StrutsPortletURL.getOriginURL(request)) != null) {
                request.setAttribute("org.apache.portals.bridges.struts.redirect_page_url", (Object)originURL);
            }
            String portletName = (String)req.getAttribute("org.apache.portals.bridges.struts.portlet_name");
            try {
                req.getSession(true).setAttribute("org.apache.portals.bridges.struts.render_context_" + portletName, (Object)context);
            }
            catch (IllegalStateException ise) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Session invalidated: redirecting to: " + this.path + " instead."));
                }
                ((HttpServletResponse)response).sendRedirect(this.path);
            }
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)("invoking " + (this.named ? "named " : " ") + " dispatch to :" + this.path + ", from " + request_type + " " + StrutsPortletURL.getPageURL(request)));
            }
            this.dispatcher.include(request, response);
        }
    }

    public void forward(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        if (PortletServlet.isPortletRequest(request)) {
            this.invoke(request, response, false);
        } else {
            this.dispatcher.forward(request, response);
        }
    }

    public void include(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        if (PortletServlet.isPortletRequest(request)) {
            this.invoke(request, response, true);
        } else {
            this.dispatcher.include(request, response);
        }
    }

    public String toString() {
        return this.dispatcher.toString();
    }
}

