/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.connectionpool.impl;

import com.netflix.astyanax.connectionpool.LatencyScoreStrategy;
import com.netflix.astyanax.connectionpool.impl.AbstractLatencyScoreStrategyImpl;
import java.util.NoSuchElementException;
import java.util.concurrent.LinkedBlockingQueue;

public class SmaLatencyScoreStrategyImpl
extends AbstractLatencyScoreStrategyImpl {
    private static final String NAME = "SMA";
    private final int windowSize;

    public SmaLatencyScoreStrategyImpl(int updateInterval, int resetInterval, int windowSize, int blockedThreshold, double keepRatio, double scoreThreshold) {
        super(NAME, updateInterval, resetInterval, blockedThreshold, keepRatio, scoreThreshold);
        this.windowSize = windowSize;
    }

    public SmaLatencyScoreStrategyImpl(int updateInterval, int resetInterval, int windowSize, double badnessThreshold) {
        this(updateInterval, resetInterval, windowSize, 10, 0.65, badnessThreshold);
    }

    public SmaLatencyScoreStrategyImpl() {
        super(NAME);
        this.windowSize = 20;
    }

    @Override
    public final LatencyScoreStrategy.Instance newInstance() {
        return new LatencyScoreStrategy.Instance(){
            private final LinkedBlockingQueue<Long> latencies;
            private volatile Double cachedScore;
            {
                this.latencies = new LinkedBlockingQueue(SmaLatencyScoreStrategyImpl.this.windowSize);
                this.cachedScore = 0.0;
            }

            @Override
            public void addSample(long sample) {
                if (!this.latencies.offer(sample)) {
                    try {
                        this.latencies.remove();
                    }
                    catch (NoSuchElementException noSuchElementException) {
                        // empty catch block
                    }
                    this.latencies.offer(sample);
                }
            }

            @Override
            public double getScore() {
                return this.cachedScore;
            }

            @Override
            public void reset() {
                this.latencies.clear();
            }

            @Override
            public void update() {
                this.cachedScore = this.getMean();
            }

            private double getMean() {
                long sum = 0L;
                int count = 0;
                for (long d : this.latencies) {
                    sum += d;
                    ++count;
                }
                return count > 0 ? (double)(sum / (long)count) : 0.0;
            }
        };
    }
}

