/*
 * Decompiled with CFR 0.152.
 */
package org.jabsorb.localarg;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.jabsorb.JSONRPCBridge;
import org.jabsorb.localarg.LocalArgResolveException;
import org.jabsorb.localarg.LocalArgResolver;
import org.jabsorb.localarg.LocalArgResolverData;
import org.jabsorb.localarg.impl.HttpServletRequestArgResolver;
import org.jabsorb.localarg.impl.HttpServletResponseArgResolver;
import org.jabsorb.localarg.impl.HttpSessionArgResolver;
import org.jabsorb.localarg.impl.JSONRPCBridgeServletArgResolver;
import org.jabsorb.reflect.ClassAnalyzer;
import org.jabsorb.serializer.UnmarshallException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalArgController {
    private static final Logger log = LoggerFactory.getLogger((Class)LocalArgController.class);
    private static Map localArgResolverMap = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isLocalArg(Class param) {
        Map map = localArgResolverMap;
        synchronized (map) {
            return localArgResolverMap.containsKey(param);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerLocalArgResolver(Class argClazz, Class contextInterface, LocalArgResolver argResolver) {
        Map map = localArgResolverMap;
        synchronized (map) {
            HashSet<LocalArgResolverData> resolverSet = (HashSet<LocalArgResolverData>)localArgResolverMap.get(argClazz);
            if (resolverSet == null) {
                resolverSet = new HashSet<LocalArgResolverData>();
                localArgResolverMap.put(argClazz, resolverSet);
            }
            resolverSet.add(new LocalArgResolverData(argResolver, argClazz, contextInterface));
            ClassAnalyzer.invalidateCache();
        }
        log.info("registered local arg resolver " + argResolver.getClass().getName() + " for local class " + argClazz.getName() + " with context " + contextInterface.getName());
    }

    public static Object resolveLocalArg(Object[] context, Class param) throws UnmarshallException {
        Set resolverSet = (Set)localArgResolverMap.get(param);
        Iterator i = resolverSet.iterator();
        while (i.hasNext()) {
            LocalArgResolverData resolverData = (LocalArgResolverData)i.next();
            for (int j = 0; j < context.length; ++j) {
                if (!resolverData.understands(context[j])) continue;
                try {
                    return resolverData.getArgResolver().resolveArg(context[j]);
                }
                catch (LocalArgResolveException e) {
                    throw new UnmarshallException("error resolving local argument: " + e, e);
                }
            }
        }
        throw new UnmarshallException("couldn't find local arg resolver");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregisterLocalArgResolver(Class argClazz, Class contextInterface, LocalArgResolver argResolver) {
        Map map = localArgResolverMap;
        synchronized (map) {
            HashSet resolverSet = (HashSet)localArgResolverMap.get(argClazz);
            if (resolverSet == null || !resolverSet.remove(new LocalArgResolverData(argResolver, argClazz, contextInterface))) {
                log.warn("local arg resolver " + argResolver.getClass().getName() + " not registered for local class " + argClazz.getName() + " with context " + contextInterface.getName());
                return;
            }
            if (resolverSet.isEmpty()) {
                localArgResolverMap.remove(argClazz);
            }
            ClassAnalyzer.invalidateCache();
        }
        log.info("unregistered local arg resolver " + argResolver.getClass().getName() + " for local class " + argClazz.getName() + " with context " + contextInterface.getName());
    }

    static {
        LocalArgController.registerLocalArgResolver(HttpServletRequest.class, HttpServletRequest.class, new HttpServletRequestArgResolver());
        LocalArgController.registerLocalArgResolver(HttpServletResponse.class, HttpServletResponse.class, new HttpServletResponseArgResolver());
        LocalArgController.registerLocalArgResolver(HttpSession.class, HttpServletRequest.class, new HttpSessionArgResolver());
        LocalArgController.registerLocalArgResolver(JSONRPCBridge.class, HttpServletRequest.class, new JSONRPCBridgeServletArgResolver());
    }
}

