/*
 * Decompiled with CFR 0.152.
 */
package org.apache.abdera.ext.opensearch.server.impl;

import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.abdera.ext.opensearch.OpenSearchConstants;
import org.apache.abdera.ext.opensearch.model.IntegerElement;
import org.apache.abdera.ext.opensearch.server.OpenSearchUrlAdapter;
import org.apache.abdera.factory.Factory;
import org.apache.abdera.model.Document;
import org.apache.abdera.model.Entry;
import org.apache.abdera.model.Feed;
import org.apache.abdera.model.Person;
import org.apache.abdera.protocol.server.RequestContext;
import org.apache.abdera.protocol.server.ResponseContext;
import org.apache.abdera.protocol.server.context.BaseResponseContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractOpenSearchUrlAdapter<T>
implements OpenSearchUrlAdapter {
    @Override
    public ResponseContext search(RequestContext request, Map<String, String> parameters) {
        List<T> searchResults = this.doSearch(request, parameters);
        Feed feed = this.createFeed(request, parameters, searchResults);
        Document document = feed.getDocument();
        BaseResponseContext response = new BaseResponseContext(document);
        return response;
    }

    protected abstract String getOpenSearchFeedId(RequestContext var1);

    protected abstract String getOpenSearchFeedTitle(RequestContext var1);

    protected abstract Person getOpenSearchFeedAuthor(RequestContext var1);

    protected abstract Date getOpenSearchFeedUpdatedDate(RequestContext var1);

    protected abstract List<T> doSearch(RequestContext var1, Map<String, String> var2);

    protected abstract void fillEntry(Entry var1, T var2);

    protected int getOpenSearchFeedTotalResults(RequestContext request, Map<String, String> parameters, List<T> searchResults) {
        return searchResults.size();
    }

    protected int getOpenSearchFeedItemsPerPage(RequestContext request, Map<String, String> parameters, List<T> searchResults) {
        return searchResults.size();
    }

    protected int getOpenSearchFeedStartIndex(RequestContext request, Map<String, String> parameters, List<T> searchResults) {
        return -1;
    }

    protected void postProcess(Feed feed, RequestContext request, Map<String, String> parameters, List<T> searchResults) {
    }

    private Feed createFeed(RequestContext searchRequest, Map<String, String> parameters, List<T> searchResults) {
        int startIndex;
        int itemsPerPage;
        Factory factory = searchRequest.getAbdera().getFactory();
        Feed feed = factory.newFeed();
        feed.setId(this.getOpenSearchFeedId(searchRequest));
        feed.setTitle(this.getOpenSearchFeedTitle(searchRequest));
        feed.addAuthor(this.getOpenSearchFeedAuthor(searchRequest));
        feed.setUpdated(this.getOpenSearchFeedUpdatedDate(searchRequest));
        feed.addLink(searchRequest.getUri().toString(), "self");
        int totalResults = this.getOpenSearchFeedTotalResults(searchRequest, parameters, searchResults);
        if (totalResults > -1) {
            ((IntegerElement)feed.addExtension(OpenSearchConstants.TOTAL_RESULTS)).setValue(totalResults);
        }
        if ((itemsPerPage = this.getOpenSearchFeedItemsPerPage(searchRequest, parameters, searchResults)) > -1) {
            ((IntegerElement)feed.addExtension(OpenSearchConstants.ITEMS_PER_PAGE)).setValue(itemsPerPage);
        }
        if ((startIndex = this.getOpenSearchFeedStartIndex(searchRequest, parameters, searchResults)) > -1) {
            ((IntegerElement)feed.addExtension(OpenSearchConstants.START_INDEX)).setValue(startIndex);
        }
        for (T entity : searchResults) {
            Entry entry = factory.newEntry();
            this.fillEntry(entry, entity);
            feed.addEntry(entry);
        }
        this.postProcess(feed, searchRequest, parameters, searchResults);
        return feed;
    }
}

