/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.chars;

import it.unimi.dsi.fastutil.chars.CharArrayIndirectPriorityQueue;
import it.unimi.dsi.fastutil.chars.CharComparator;
import it.unimi.dsi.fastutil.chars.CharComparators;
import it.unimi.dsi.fastutil.chars.CharIndirectDoublePriorityQueue;

public class CharArrayIndirectDoublePriorityQueue
extends CharArrayIndirectPriorityQueue
implements CharIndirectDoublePriorityQueue {
    protected CharComparator secondaryComparator;

    public CharArrayIndirectDoublePriorityQueue(char[] refArray, int capacity, CharComparator c, CharComparator d) {
        super(refArray, capacity, c);
        this.secondaryComparator = d;
    }

    public CharArrayIndirectDoublePriorityQueue(char[] refArray, int capacity, CharComparator c) {
        super(refArray, capacity, c == null ? CharComparators.OPPOSITE_COMPARATOR : CharComparators.oppositeComparator(c));
    }

    public CharArrayIndirectDoublePriorityQueue(char[] refArray, int capacity) {
        this(refArray, capacity, null);
    }

    public CharArrayIndirectDoublePriorityQueue(char[] refArray, CharComparator c, CharComparator d) {
        this(refArray, refArray.length, c, d);
    }

    public CharArrayIndirectDoublePriorityQueue(char[] refArray, CharComparator c) {
        this(refArray, refArray.length, c);
    }

    public CharArrayIndirectDoublePriorityQueue(char[] refArray) {
        this(refArray, refArray.length, null);
    }

    public CharArrayIndirectDoublePriorityQueue(char[] refArray, int[] a, int size, CharComparator c, CharComparator d) {
        this(refArray, 0, c, d);
        this.array = a;
        this.size = size;
    }

    public CharArrayIndirectDoublePriorityQueue(char[] refArray, int[] a, CharComparator c, CharComparator d) {
        this(refArray, a, a.length, c, d);
    }

    public CharArrayIndirectDoublePriorityQueue(char[] refArray, int[] a, int size, CharComparator c) {
        this(refArray, 0, c);
        this.array = a;
        this.size = size;
    }

    public CharArrayIndirectDoublePriorityQueue(char[] refArray, int[] a, CharComparator c) {
        this(refArray, a, a.length, c);
    }

    public CharArrayIndirectDoublePriorityQueue(char[] refArray, int[] a, int size) {
        this(refArray, a, size, null);
    }

    public CharArrayIndirectDoublePriorityQueue(char[] refArray, int[] a) {
        this(refArray, a, a.length);
    }

    private int findSecondaryFirst() {
        int i = this.size;
        int firstIndex = --i;
        char first = this.refArray[this.array[firstIndex]];
        if (this.secondaryComparator == null) {
            while (i-- != 0) {
                if (this.refArray[this.array[i]] >= first) continue;
                firstIndex = i;
                first = this.refArray[this.array[firstIndex]];
            }
        } else {
            while (i-- != 0) {
                if (this.secondaryComparator.compare(this.refArray[this.array[i]], first) >= 0) continue;
                firstIndex = i;
                first = this.refArray[this.array[firstIndex]];
            }
        }
        return firstIndex;
    }

    private int findSecondaryLast() {
        int i = this.size;
        int lastIndex = --i;
        char last = this.refArray[this.array[lastIndex]];
        if (this.secondaryComparator == null) {
            while (i-- != 0) {
                if (last >= this.refArray[this.array[i]]) continue;
                lastIndex = i;
                last = this.refArray[this.array[lastIndex]];
            }
        } else {
            while (i-- != 0) {
                if (this.secondaryComparator.compare(last, this.refArray[this.array[i]]) >= 0) continue;
                lastIndex = i;
                last = this.refArray[this.array[lastIndex]];
            }
        }
        return lastIndex;
    }

    public int secondaryFirst() {
        return this.array[this.findSecondaryFirst()];
    }

    public int secondaryLast() {
        return this.array[this.findSecondaryLast()];
    }

    public void changed(int i) {
    }

    public CharComparator secondaryComparator() {
        return this.secondaryComparator;
    }
}

