/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.compat.portal.kernel.util;

import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.util.DateUtil;
import com.liferay.portal.kernel.util.FastDateFormatFactoryUtil;
import java.text.Format;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class Time
extends com.liferay.portal.kernel.util.Time {
    public static String getRelativeTimeDescription(Date date, Locale locale, TimeZone timeZone, Format dateTimeFormat) {
        return Time.getRelativeTimeDescription(date.getTime(), locale, timeZone, dateTimeFormat);
    }

    public static String getRelativeTimeDescription(long milliseconds, Locale locale, TimeZone timeZone) {
        return Time.getRelativeTimeDescription(milliseconds, locale, timeZone, null);
    }

    public static String getRelativeTimeDescription(long milliseconds, Locale locale, TimeZone timeZone, Format dateTimeFormat) {
        Format timeFormat = FastDateFormatFactoryUtil.getTime((Locale)locale, (TimeZone)timeZone);
        int daysBetween = DateUtil.getDaysBetween((Date)new Date(milliseconds), (Date)new Date(), (TimeZone)timeZone);
        long millisAgo = System.currentTimeMillis() - milliseconds;
        if (millisAgo < 3600000L) {
            long minutes = millisAgo / 60000L;
            if (minutes <= 1L) {
                return LanguageUtil.get((Locale)locale, (String)"about-a-minute-ago");
            }
            return LanguageUtil.format((Locale)locale, (String)"x-minutes-ago", (Object)minutes);
        }
        if (millisAgo / 3600000L == 1L) {
            return LanguageUtil.get((Locale)locale, (String)"about-an-hour-ago");
        }
        if (millisAgo < 86400000L || daysBetween == 0) {
            return LanguageUtil.format((Locale)locale, (String)"x-hours-ago", (Object)(millisAgo / 3600000L));
        }
        if (daysBetween == 1) {
            return LanguageUtil.format((Locale)locale, (String)"yesterday-at-x", (Object)timeFormat.format(milliseconds));
        }
        if (dateTimeFormat == null) {
            dateTimeFormat = FastDateFormatFactoryUtil.getSimpleDateFormat((String)"EEEE, MMMMM dd, yyyy", (Locale)locale, (TimeZone)timeZone);
        }
        return dateTimeFormat.format(milliseconds);
    }
}

