/*
 * Decompiled with CFR 0.152.
 */
package com.ecyrd.jspwiki.rss;

import com.ecyrd.jspwiki.WikiContext;
import com.ecyrd.jspwiki.WikiEngine;
import com.ecyrd.jspwiki.WikiPage;
import com.ecyrd.jspwiki.rss.Entry;
import com.ecyrd.jspwiki.rss.Feed;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import org.apache.ecs.Element;
import org.apache.ecs.xml.XML;

public class RSS10Feed
extends Feed {
    public RSS10Feed(WikiContext context) {
        super(context);
    }

    private XML getRDFItems() {
        XML items = new XML("items");
        XML rdfseq = new XML("rdf:Seq");
        for (Entry e : this.m_entries) {
            String url = e.getURL();
            rdfseq.addElement(new XML("rdf:li").addAttribute("rdf:resource", url));
        }
        items.addElement((Element)rdfseq);
        return items;
    }

    private void addItemList(XML root) {
        SimpleDateFormat iso8601fmt = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        WikiEngine engine = this.m_wikiContext.getEngine();
        for (Entry e : this.m_entries) {
            String url = e.getURL();
            XML item = new XML("item");
            item.addAttribute("rdf:about", url);
            item.addElement((Element)new XML("title").addElement(RSS10Feed.format(e.getTitle())));
            item.addElement((Element)new XML("link").addElement(url));
            XML content = new XML("description");
            content.addElement(RSS10Feed.format(e.getContent()));
            item.addElement((Element)content);
            WikiPage p = e.getPage();
            if (p.getVersion() != -1) {
                item.addElement((Element)new XML("wiki:version").addElement(Integer.toString(p.getVersion())));
            }
            if (p.getVersion() > 1) {
                item.addElement((Element)new XML("wiki:diff").addElement(engine.getURL(WikiContext.DIFF, p.getName(), "r1=-1", true)));
            }
            Calendar cal = Calendar.getInstance();
            cal.setTime(p.getLastModified());
            cal.add(14, -(cal.get(15) + (cal.getTimeZone().inDaylightTime(p.getLastModified()) ? cal.get(16) : 0)));
            item.addElement((Element)new XML("dc:date").addElement(iso8601fmt.format(cal.getTime())));
            String author = e.getAuthor();
            if (author == null) {
                author = "unknown";
            }
            XML contributor = new XML("dc:creator");
            item.addElement((Element)contributor);
            contributor.addElement(RSS10Feed.format(author));
            item.addElement((Element)new XML("wiki:history").addElement(engine.getURL(WikiContext.INFO, p.getName(), null, true)));
            root.addElement((Element)item);
        }
    }

    private XML getChannelElement() {
        XML channel = new XML("channel");
        channel.addAttribute("rdf:about", this.m_feedURL);
        channel.addElement((Element)new XML("link").addElement(this.m_feedURL));
        if (this.m_channelTitle != null) {
            channel.addElement((Element)new XML("title").addElement(RSS10Feed.format(this.m_channelTitle)));
        }
        if (this.m_channelDescription != null) {
            channel.addElement((Element)new XML("description").addElement(RSS10Feed.format(this.m_channelDescription)));
        }
        if (this.m_channelLanguage != null) {
            channel.addElement((Element)new XML("dc:language").addElement(this.m_channelLanguage));
        }
        channel.setPrettyPrint(true);
        channel.addElement((Element)this.getRDFItems());
        return channel;
    }

    public String getString() {
        XML root = new XML("rdf:RDF");
        root.addAttribute("xmlns:rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#");
        root.addAttribute("xmlns", "http://purl.org/rss/1.0/");
        root.addAttribute("xmlns:dc", "http://purl.org/dc/elements/1.1/");
        root.addAttribute("xmlns:wiki", "http://purl.org/rss/1.0/modules/wiki/");
        root.addElement((Element)this.getChannelElement());
        this.addItemList(root);
        root.setPrettyPrint(true);
        return root.toString();
    }
}

